/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import weblogic.xml.jaxp.RegistryParser;
import weblogic.xml.jaxp.RegistryXMLReader;
import weblogic.xml.jaxp.SAXFactoryProperties;
import weblogic.xml.jaxp.XMLContext;
import weblogic.xml.util.Debug;
import weblogic.xml.util.XMLConstants;

public class RegistrySAXParser
extends SAXParser
implements XMLConstants {
    private static final boolean debug = Boolean.getBoolean("weblogic.xml.debug");
    static Debug.DebugFacility dbg = XMLContext.dbg;
    private SAXParser saxParser;
    private SAXFactoryProperties saxFactoryProperties;
    private boolean isXIncludeAware = false;
    private Schema schema = null;
    private RegistryParser parser;
    private RegistryXMLReader reader;
    private SAXFactoryProperties initSaxFactoryProperties;

    protected RegistrySAXParser(SAXParserFactory sAXParserFactory, SAXFactoryProperties sAXFactoryProperties) {
        this(sAXParserFactory, sAXFactoryProperties, false, null);
    }

    protected RegistrySAXParser(SAXParserFactory sAXParserFactory, SAXFactoryProperties sAXFactoryProperties, boolean bl, Schema schema) {
        this.saxFactoryProperties = sAXFactoryProperties;
        this.initSaxFactoryProperties = (SAXFactoryProperties)sAXFactoryProperties.clone();
        try {
            if (sAXParserFactory != null) {
                this.saxParser = sAXParserFactory.newSAXParser();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new FactoryConfigurationError("WebLogicSAXParser cannot be created which satisfies the requested configuration." + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new FactoryConfigurationError("WebLogicSAXParser cannot be created." + sAXException.getMessage());
        }
        this.parser = new RegistryParser(this.saxParser, this.saxFactoryProperties);
        this.reader = new RegistryXMLReader(this.saxParser, this.saxFactoryProperties);
    }

    public Parser getParser() throws SAXException {
        return this.parser;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        Object object = this.saxFactoryProperties.getProperty(string);
        if (object == null && this.saxParser != null) {
            return this.saxParser.getProperty(string);
        }
        if (object == null) {
            throw new SAXNotRecognizedException("You have specified a custom parser in the console. Properties for such parsers are set at the parse time.");
        }
        return object;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.saxFactoryProperties.setProperty(string, object);
        if (this.saxParser != null) {
            this.saxParser.setProperty(string, object);
        }
    }

    public XMLReader getXMLReader() throws SAXException {
        return this.reader;
    }

    public boolean isNamespaceAware() {
        if (this.saxParser == null) {
            return this.saxFactoryProperties.get(SAXFactoryProperties.NAMESPACEAWARE);
        }
        return this.saxParser.isNamespaceAware();
    }

    public boolean isValidating() {
        if (this.saxParser == null) {
            return this.saxFactoryProperties.get(SAXFactoryProperties.VALIDATING);
        }
        return this.saxParser.isValidating();
    }

    public boolean isXIncludeAware() {
        if (this.saxParser == null) {
            return this.saxFactoryProperties.get(SAXFactoryProperties.XINCL);
        }
        return this.saxParser.isXIncludeAware();
    }

    public Schema getSchema() {
        if (this.saxParser == null) {
            return (Schema)this.saxFactoryProperties.getProperty(SAXFactoryProperties.SCHEMA);
        }
        return this.saxParser.getSchema();
    }

    public void reset() {
        this.saxFactoryProperties.copyFrom(this.initSaxFactoryProperties);
        this.parser.reset();
        this.reader.reset();
    }
}

