/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import weblogic.xml.XMLLogger;
import weblogic.xml.jaxp.RegistrySAXParser;
import weblogic.xml.jaxp.SAXFactoryProperties;
import weblogic.xml.jaxp.WebLogicSAXParserFactory;
import weblogic.xml.jaxp.XMLContext;
import weblogic.xml.registry.RegistryEntityResolver;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.util.Debug;

public class RegistrySAXParserFactory
extends SAXParserFactory {
    static Debug.DebugFacility dbg = XMLContext.dbg;
    private SAXParserFactory factory;
    private SAXFactoryProperties factoryProperties;

    public RegistrySAXParserFactory() {
        block5: {
            this.factory = null;
            try {
                RegistryEntityResolver registryEntityResolver = new RegistryEntityResolver();
                boolean bl = registryEntityResolver.hasDocumentSpecificParserEntries();
                this.factoryProperties = new SAXFactoryProperties();
                if (bl) break block5;
                try {
                    this.factory = registryEntityResolver.getSAXParserFactory();
                }
                catch (XMLRegistryException xMLRegistryException) {
                    XMLLogger.logXMLRegistryException((String)xMLRegistryException.getMessage());
                }
                if (this.factory == null) {
                    this.factory = new WebLogicSAXParserFactory();
                }
            }
            catch (XMLRegistryException xMLRegistryException) {
                XMLLogger.logXMLRegistryException((String)xMLRegistryException.getMessage());
                throw new FactoryConfigurationError("Failed to find SAXParserFactory. " + xMLRegistryException.getMessage());
            }
        }
    }

    public SAXParser newSAXParser() {
        RegistrySAXParser registrySAXParser = new RegistrySAXParser(this.factory, (SAXFactoryProperties)this.factoryProperties.clone());
        return registrySAXParser;
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bl = this.factoryProperties.getFeature(string);
        if (bl == null && this.factory != null) {
            return this.factory.getFeature(string);
        }
        if (bl == null) {
            throw new SAXNotRecognizedException("You have specified a document-specific parser in the console. Features for such parsers are set at the parse time.");
        }
        return bl;
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.factoryProperties.setFeature(string, bl);
        if (this.factory != null) {
            this.factory.setFeature(string, bl);
        }
    }

    public boolean isNamespaceAware() {
        if (this.factory == null) {
            return this.factoryProperties.get(SAXFactoryProperties.NAMESPACEAWARE);
        }
        return this.factory.isNamespaceAware();
    }

    public boolean isValidating() {
        if (this.factory == null) {
            return this.factoryProperties.get(SAXFactoryProperties.VALIDATING);
        }
        return this.factory.isValidating();
    }

    public void setNamespaceAware(boolean bl) {
        this.factoryProperties.put(SAXFactoryProperties.NAMESPACEAWARE, bl);
        if (this.factory != null) {
            this.factory.setNamespaceAware(bl);
        }
    }

    public void setValidating(boolean bl) {
        this.factoryProperties.put(SAXFactoryProperties.VALIDATING, bl);
        if (this.factory != null) {
            this.factory.setValidating(bl);
        }
    }

    public boolean isXIncludeAware() {
        if (this.factory == null) {
            return this.factoryProperties.get(SAXFactoryProperties.XINCL);
        }
        return this.factory.isXIncludeAware();
    }

    public void setXIncludeAware(boolean bl) {
        this.factoryProperties.put(SAXFactoryProperties.XINCL, bl);
        if (this.factory != null) {
            this.factory.setXIncludeAware(bl);
        }
    }

    public Schema getSchema() {
        if (this.factory == null) {
            return (Schema)this.factoryProperties.getProperty(SAXFactoryProperties.SCHEMA);
        }
        return this.factory.getSchema();
    }

    public void setSchema(Schema schema) {
        this.factoryProperties.setProperty(SAXFactoryProperties.SCHEMA, schema);
        if (this.factory != null) {
            this.factory.setSchema(schema);
        }
    }
}

