/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.ParserAdapter;
import weblogic.logging.NonCatalogLogger;
import weblogic.xml.XMLLogger;
import weblogic.xml.jaxp.ChainingEntityResolver;
import weblogic.xml.jaxp.ParserCreationHelper;
import weblogic.xml.jaxp.ReParsingContentHandler;
import weblogic.xml.jaxp.ReParsingDTDHandler;
import weblogic.xml.jaxp.ReParsingDeclHandler;
import weblogic.xml.jaxp.ReParsingErrorHandler;
import weblogic.xml.jaxp.ReParsingEventQueue;
import weblogic.xml.jaxp.ReParsingLexicalHandler;
import weblogic.xml.jaxp.ReParsingStatus;
import weblogic.xml.jaxp.SAXFactoryProperties;
import weblogic.xml.jaxp.XMLContext;
import weblogic.xml.registry.ReParsingEntityNotChangedException;
import weblogic.xml.registry.RegistryEntityResolver;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.sax.XMLInputSource;
import weblogic.xml.util.Debug;
import weblogic.xml.util.InputSourceUtil;
import weblogicx.xml.parser.BaseParser;

public class RegistryXMLReader
implements XMLReader {
    static Debug.DebugFacility dbg = XMLContext.dbg;
    static NonCatalogLogger logger = new NonCatalogLogger(RegistryXMLReader.class.getName());
    private RegistryEntityResolver registry;
    private final ChainingEntityResolver chainingEntityResolver = new ChainingEntityResolver();
    private ReParsingContentHandler contentHandlerProxy = new ReParsingContentHandler();
    private ReParsingDTDHandler dtdHandlerProxy = new ReParsingDTDHandler();
    private ReParsingErrorHandler errorHandlerProxy = new ReParsingErrorHandler();
    private XMLReader xmlReader;
    private SAXFactoryProperties saxFactoryProperties;
    private XMLInputSource xmlInputSource = null;
    private SAXParser saxParser = null;
    private ReParsingLexicalHandler lexicalHandlerProxy = new ReParsingLexicalHandler();
    private ReParsingDeclHandler declHandlerProxy = new ReParsingDeclHandler();
    private Map<String, SAXParser> cache = new HashMap<String, SAXParser>();

    public RegistryXMLReader() {
        try {
            this.registry = new RegistryEntityResolver();
            this.chainingEntityResolver.pushEntityResolver(this.registry);
            this.saxFactoryProperties = new SAXFactoryProperties();
            this.saxFactoryProperties.put(SAXFactoryProperties.NAMESPACEAWARE, true);
            this.xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            this.xmlReader.setEntityResolver(this.chainingEntityResolver);
        }
        catch (XMLRegistryException xMLRegistryException) {
            throw new FactoryConfigurationError((Exception)((Object)xMLRegistryException), "Could not access XML Registry. " + xMLRegistryException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new FactoryConfigurationError(parserConfigurationException, "Could not create parser. " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new FactoryConfigurationError(sAXException, "Could not create parser. " + sAXException.getMessage());
        }
    }

    protected RegistryXMLReader(SAXParser sAXParser, SAXFactoryProperties sAXFactoryProperties) {
        try {
            this.registry = new RegistryEntityResolver();
            this.chainingEntityResolver.pushEntityResolver(this.registry);
            this.saxFactoryProperties = sAXFactoryProperties;
            if (sAXParser != null) {
                this.xmlReader = sAXParser.getXMLReader();
                this.xmlReader.setEntityResolver(this.chainingEntityResolver);
            }
        }
        catch (XMLRegistryException xMLRegistryException) {
            throw new FactoryConfigurationError((Exception)((Object)xMLRegistryException), "Could not access XML Registry. " + xMLRegistryException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new FactoryConfigurationError(sAXException, "Could not create parser. " + sAXException.getMessage());
        }
    }

    public RegistryEntityResolver getRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws SAXException, IOException {
        block30: {
            if (inputSource == null) {
                throw new IllegalArgumentException("InputSource is missing.");
            }
            try {
                try {
                    this.xmlReader = this.getXMLReaderInternal(inputSource);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new SAXException(parserConfigurationException);
                }
                boolean bl = this.isHandleEntityInvalidation(inputSource);
                if (!bl) {
                    if (this.errorHandlerProxy.getErrorHandler() != null) {
                        this.xmlReader.setErrorHandler(this.errorHandlerProxy.getErrorHandler());
                    }
                    if (this.contentHandlerProxy.getContentHandler() != null) {
                        this.xmlReader.setContentHandler(this.contentHandlerProxy.getContentHandler());
                    }
                    if (this.dtdHandlerProxy.getDTDHandler() != null) {
                        this.xmlReader.setDTDHandler(this.dtdHandlerProxy.getDTDHandler());
                    }
                    this.xmlReader.parse(inputSource);
                    break block30;
                }
                boolean bl2 = false;
                ReParsingEventQueue reParsingEventQueue = new ReParsingEventQueue();
                try {
                    ReParsingStatus reParsingStatus = new ReParsingStatus();
                    this.registry.hookStatus(reParsingStatus);
                    this.errorHandlerProxy.hookStatus(reParsingStatus);
                    this.errorHandlerProxy.registerQueue(reParsingEventQueue);
                    this.contentHandlerProxy.registerQueue(reParsingEventQueue);
                    this.dtdHandlerProxy.registerQueue(reParsingEventQueue);
                    this.delegateExtendedHandlers(reParsingEventQueue);
                    SAXParseException sAXParseException = null;
                    Object var7_8 = null;
                    try {
                        InputSourceUtil.transformInputSource(inputSource);
                    }
                    catch (Exception exception) {
                        reParsingStatus.inLastReParsing = true;
                    }
                    int n = 0;
                    while (true) {
                        if (n >= 2) {
                            reParsingStatus.inLastReParsing = true;
                        }
                        try {
                            this.xmlReader.parse(inputSource);
                            sAXParseException = null;
                        }
                        catch (SAXParseException sAXParseException2) {
                            sAXParseException = sAXParseException2;
                            reParsingStatus.error = sAXParseException2;
                        }
                        catch (ReParsingEntityNotChangedException reParsingEntityNotChangedException) {
                            bl2 = true;
                            break;
                        }
                        if (!reParsingStatus.needReParse()) break;
                        reParsingStatus.prepareReParsing();
                        reParsingEventQueue.shiftLastEvents();
                        try {
                            this.saxParser.reset();
                            this.xmlReader = this.saxParser.getXMLReader();
                            this.setupXMLReader();
                            this.delegateExtendedHandlers(reParsingEventQueue);
                            InputSourceUtil.resetInputSource(inputSource);
                        }
                        catch (Exception exception) {
                            break;
                        }
                        ++n;
                    }
                    if (sAXParseException != null) {
                        throw sAXParseException;
                    }
                }
                finally {
                    this.registry.hookStatus(null);
                    this.errorHandlerProxy.hookStatus(null);
                    if (!bl2) {
                        reParsingEventQueue.shiftLastEvents();
                    }
                    try {
                        reParsingEventQueue.reSendLastEvents();
                    }
                    finally {
                        reParsingEventQueue.clearAllEvents();
                        this.errorHandlerProxy.registerQueue(null);
                        this.contentHandlerProxy.registerQueue(null);
                        this.dtdHandlerProxy.registerQueue(null);
                        this.cleanUpExtendedHandlers();
                    }
                }
            }
            finally {
                if (this.xmlInputSource != null) {
                    this.xmlInputSource = null;
                }
            }
        }
    }

    private boolean isHandleEntityInvalidation(InputSource inputSource) {
        String string = null;
        try {
            if (this.registry.hasDocumentSpecificEntityEntries() && this.registry.hasHandleEntityInvalidationSetSupport()) {
                if (this.xmlInputSource == null) {
                    this.xmlInputSource = new XMLInputSource(inputSource);
                }
                String string2 = this.xmlInputSource.getPublicIdInternal();
                String string3 = this.xmlInputSource.getDoctypeSystemIdInternal();
                string = this.registry.getHandleEntityInvalidation(string2, string3);
            }
            if (string == null) {
                string = this.registry.getHandleEntityInvalidation();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "true".equals(string);
    }

    public void parse(String string) throws SAXException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("System ID is missing.");
        }
        this.parse(new InputSource(string));
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandlerProxy.setErrorHandler(errorHandler);
        if (this.xmlReader != null) {
            this.xmlReader.setErrorHandler(errorHandler);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (dbg.areDebuggingAt(2)) {
            int n = this.chainingEntityResolver.getResolverCount();
            dbg.assertion(n == 1 || n == 2);
        }
        if (this.chainingEntityResolver.getResolverCount() == 2) {
            this.chainingEntityResolver.popEntityResolver();
        }
        this.chainingEntityResolver.pushEntityResolver(entityResolver);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandlerProxy.setDTDHandler(dTDHandler);
        if (this.xmlReader != null) {
            this.xmlReader.setDTDHandler(dTDHandler);
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandlerProxy.setContentHandler(contentHandler);
        if (this.xmlReader != null) {
            this.xmlReader.setContentHandler(contentHandler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandlerProxy.getContentHandler();
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandlerProxy.getDTDHandler();
    }

    public EntityResolver getEntityResolver() {
        return this.chainingEntityResolver.peekEntityResolver();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandlerProxy.getErrorHandler();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bl = this.saxFactoryProperties.getFeature(string);
        if (bl == null && this.xmlReader != null) {
            return this.xmlReader.getFeature(string);
        }
        if (bl == null) {
            throw new SAXNotRecognizedException("You have specified a document-specific parser in the console. Features for such parsers are set at the parse time.");
        }
        return bl;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        Object object = this.saxFactoryProperties.getProperty(string);
        if (object == null && this.xmlReader != null) {
            return this.xmlReader.getProperty(string);
        }
        if (object == null) {
            throw new SAXNotRecognizedException("You have specified a custom parser in the console. Properties for such parsers are set at the parse time.");
        }
        return object;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.saxFactoryProperties.setFeature(string, bl);
        if (this.xmlReader != null) {
            this.xmlReader.setFeature(string, bl);
        }
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.saxFactoryProperties.setProperty(string, object);
        if (this.xmlReader != null) {
            this.xmlReader.setProperty(string, object);
        }
    }

    private XMLReader getXMLReaderInternal(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        if (this.xmlInputSource != null) {
            this.xmlInputSource = null;
        }
        if (this.registry.hasDocumentSpecificParserEntries()) {
            this.xmlInputSource = new XMLInputSource(inputSource);
            this.xmlReader = this.getXMLReader(this.xmlInputSource);
        } else {
            this.xmlReader = this.getXMLReader(null);
        }
        this.setupXMLReader();
        return this.xmlReader;
    }

    private XMLReader getXMLReader(XMLInputSource xMLInputSource) throws ParserConfigurationException, SAXException {
        Object object;
        XMLReader xMLReader = null;
        SAXParserFactory sAXParserFactory = null;
        ParserCreationHelper parserCreationHelper = new ParserCreationHelper(this.registry);
        if (xMLInputSource != null && (object = parserCreationHelper.getCustomParser(xMLInputSource)) != null) {
            if (object instanceof BaseParser && (this.saxFactoryProperties.get(SAXFactoryProperties.VALIDATING) || this.saxFactoryProperties.get(SAXFactoryProperties.NAMESPACEAWARE))) {
                throw new ParserConfigurationException("Custom-generated parser " + object.getClass().getName() + " cannot be used. This parser is neither validating nor namespaceaware.");
            }
            xMLReader = new ParserAdapter((Parser)object);
        }
        if (xMLReader == null) {
            if (xMLInputSource != null) {
                sAXParserFactory = parserCreationHelper.getCustomSAXParserFactory(xMLInputSource);
            }
            if (sAXParserFactory == null) {
                sAXParserFactory = parserCreationHelper.getDefaultSAXParserFactory();
            }
            if (this.cache.containsKey(object = sAXParserFactory.getClass().getName())) {
                this.saxParser = this.cache.get(object);
                xMLReader = this.saxParser.getXMLReader();
            } else {
                Schema schema;
                sAXParserFactory.setValidating(this.saxFactoryProperties.get(SAXFactoryProperties.VALIDATING));
                if (this.saxFactoryProperties.isSetExplicitly(SAXFactoryProperties.NAMESPACEAWARE)) {
                    sAXParserFactory.setNamespaceAware(this.saxFactoryProperties.get(SAXFactoryProperties.NAMESPACEAWARE));
                }
                if ((schema = (Schema)this.saxFactoryProperties.getProperty(SAXFactoryProperties.SCHEMA)) != null) {
                    sAXParserFactory.setSchema(schema);
                }
                if (this.saxFactoryProperties.get(SAXFactoryProperties.XINCL)) {
                    sAXParserFactory.setXIncludeAware(true);
                }
                this.saxParser = sAXParserFactory.newSAXParser();
                this.cache.put((String)object, this.saxParser);
                xMLReader = this.saxParser.getXMLReader();
            }
        }
        return xMLReader;
    }

    private void setupXMLReader() throws SAXException {
        String string;
        this.xmlReader.setContentHandler(this.contentHandlerProxy);
        this.xmlReader.setDTDHandler(this.dtdHandlerProxy);
        this.xmlReader.setErrorHandler(this.errorHandlerProxy);
        this.xmlReader.setEntityResolver(this.chainingEntityResolver);
        Enumeration enumeration = this.saxFactoryProperties.features();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Boolean bl = this.saxFactoryProperties.getFeature(string);
            try {
                this.xmlReader.setFeature(string, bl);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                XMLLogger.logPropertyNotAccepted((String)string, (String)bl.toString(), (String)sAXNotRecognizedException.getMessage());
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                XMLLogger.logPropertyNotAccepted((String)string, (String)bl.toString(), (String)sAXNotSupportedException.getMessage());
            }
        }
        enumeration = this.saxFactoryProperties.properties();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Object object = this.saxFactoryProperties.getProperty(string);
            try {
                this.xmlReader.setProperty(string, object);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                XMLLogger.logPropertyNotAccepted((String)string, (String)(object == null ? "null" : object.toString()), (String)sAXNotRecognizedException.getMessage());
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                XMLLogger.logPropertyNotAccepted((String)string, (String)(object == null ? "null" : object.toString()), (String)sAXNotSupportedException.getMessage());
            }
        }
    }

    private void delegateExtendedHandlers(ReParsingEventQueue reParsingEventQueue) throws SAXNotRecognizedException, SAXNotSupportedException {
        String string = "http://xml.org/sax/properties/lexical-handler";
        Object object = null;
        try {
            object = this.xmlReader.getProperty(string);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        if (object != null && object instanceof LexicalHandler && !(object instanceof ReParsingLexicalHandler)) {
            this.lexicalHandlerProxy.setLexicalHandler((LexicalHandler)object);
            this.lexicalHandlerProxy.registerQueue(reParsingEventQueue);
            this.xmlReader.setProperty(string, this.lexicalHandlerProxy);
        }
        string = "http://xml.org/sax/properties/declaration-handler";
        object = null;
        try {
            object = this.xmlReader.getProperty(string);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        if (object != null && object instanceof DeclHandler && !(object instanceof ReParsingDeclHandler)) {
            this.declHandlerProxy.setDeclHandler((DeclHandler)object);
            this.declHandlerProxy.registerQueue(reParsingEventQueue);
            this.xmlReader.setProperty(string, this.declHandlerProxy);
        }
    }

    private void cleanUpExtendedHandlers() {
        this.lexicalHandlerProxy.setLexicalHandler(null);
        this.lexicalHandlerProxy.registerQueue(null);
        this.declHandlerProxy.setDeclHandler(null);
        this.declHandlerProxy.registerQueue(null);
    }

    void reset() {
        this.contentHandlerProxy.setContentHandler(null);
        this.dtdHandlerProxy.setDTDHandler(null);
        this.errorHandlerProxy.setErrorHandler(null);
        this.resetCachedSAXParsers();
    }

    private void resetCachedSAXParsers() {
        for (SAXParser sAXParser : this.cache.values()) {
            sAXParser.reset();
        }
    }
}

