/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class SAXFactoryProperties {
    public static String NAMESPACEAWARE = "Namespaceaware";
    public static String VALIDATING = "Validating";
    public static String XINCL = "XIncludeAware";
    public static String SCHEMA = "Schema";
    private LinkedHashMap factoryProperties = new LinkedHashMap();
    private Set facPropertySettingMarks;
    private LinkedHashMap features;
    private LinkedHashMap properties;
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public SAXFactoryProperties() {
        this.factoryProperties.put(NAMESPACEAWARE, Boolean.FALSE);
        this.factoryProperties.put(VALIDATING, Boolean.FALSE);
        this.factoryProperties.put(XINCL, Boolean.FALSE);
        this.facPropertySettingMarks = new HashSet();
        this.features = new LinkedHashMap();
        this.properties = new LinkedHashMap();
    }

    public void put(String string, boolean bl) {
        this.factoryProperties.put(string, new Boolean(bl));
        this.facPropertySettingMarks.add(string);
    }

    public boolean get(String string) {
        Boolean bl = (Boolean)this.factoryProperties.get(string);
        return bl;
    }

    public boolean isSetExplicitly(String string) {
        return this.facPropertySettingMarks.contains(string);
    }

    public void setFeature(String string, boolean bl) {
        this.features.put(string, new Boolean(bl));
    }

    public Boolean getFeature(String string) {
        Boolean bl = (Boolean)this.features.get(string);
        return bl;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
        if (JAXP_SCHEMA_LANGUAGE.equals(string) && this.properties.containsKey(JAXP_SCHEMA_SOURCE)) {
            Object v = this.properties.remove(JAXP_SCHEMA_SOURCE);
            this.properties.put(JAXP_SCHEMA_SOURCE, v);
        }
    }

    public Object getProperty(String string) {
        Object v = this.properties.get(string);
        return v;
    }

    public Enumeration features() {
        return Collections.enumeration(this.features.keySet());
    }

    public Enumeration properties() {
        return Collections.enumeration(this.properties.keySet());
    }

    public Object clone() {
        SAXFactoryProperties sAXFactoryProperties = new SAXFactoryProperties();
        sAXFactoryProperties.factoryProperties.clear();
        sAXFactoryProperties.facPropertySettingMarks.clear();
        sAXFactoryProperties.features.clear();
        sAXFactoryProperties.properties.clear();
        sAXFactoryProperties.factoryProperties.putAll(this.factoryProperties);
        sAXFactoryProperties.facPropertySettingMarks.addAll(this.facPropertySettingMarks);
        sAXFactoryProperties.features.putAll(this.features);
        sAXFactoryProperties.properties.putAll(this.properties);
        return sAXFactoryProperties;
    }

    public void copyFrom(SAXFactoryProperties sAXFactoryProperties) {
        this.factoryProperties.clear();
        this.facPropertySettingMarks.clear();
        this.features.clear();
        this.properties.clear();
        this.factoryProperties.putAll(sAXFactoryProperties.factoryProperties);
        this.facPropertySettingMarks.addAll(sAXFactoryProperties.facPropertySettingMarks);
        this.features.putAll(sAXFactoryProperties.features);
        this.properties.putAll(sAXFactoryProperties.properties);
    }
}

