/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import weblogic.xml.jaxp.Utils;
import weblogic.xml.registry.RegistryEntityResolver;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.util.XMLConstants;

public class WebLogicDocumentBuilderFactory
extends DocumentBuilderFactory
implements XMLConstants {
    static Boolean allow_external_dtd = new Boolean(!"false".equalsIgnoreCase(System.getProperty("weblogic.xml.jaxp.allow.externalDTD")));
    static boolean IBM = System.getProperty("java.vendor", "unknown").toLowerCase(Locale.ENGLISH).indexOf("ibm") >= 0;
    private static String[] parserFactories = new String[]{"com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", "weblogic.apache.xerces.jaxp.DocumentBuilderFactoryImpl"};
    private static String[] ibmParserFactories = new String[]{"org.apache.xerces.jaxp.DocumentBuilderFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", "weblogic.apache.xerces.jaxp.DocumentBuilderFactoryImpl"};
    private boolean disabledEntityResolutionRegistry = false;
    private DocumentBuilderFactory delegate = IBM ? (DocumentBuilderFactory)Utils.getDelegate(ibmParserFactories) : (DocumentBuilderFactory)Utils.getDelegate(parserFactories);

    public WebLogicDocumentBuilderFactory() {
        if (allow_external_dtd.booleanValue()) {
            return;
        }
        try {
            this.delegate.setAttribute("http://xml.org/sax/features/external-general-entities", allow_external_dtd);
            this.delegate.setAttribute("http://xml.org/sax/features/external-parameter-entities", allow_external_dtd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        return this.delegate.getAttribute(string);
    }

    public boolean isCoalescing() {
        return this.delegate.isCoalescing();
    }

    public boolean isDisabledEntityResolutionRegistry() {
        return this.disabledEntityResolutionRegistry;
    }

    public boolean isExpandEntityReferences() {
        return this.delegate.isExpandEntityReferences();
    }

    public boolean isIgnoringComments() {
        return this.delegate.isIgnoringComments();
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.delegate.isIgnoringElementContentWhitespace();
    }

    public boolean isNamespaceAware() {
        return this.delegate.isNamespaceAware();
    }

    public boolean isValidating() {
        return this.delegate.isValidating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = null;
        boolean bl = false;
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        try {
            if (classLoader != this.getClass().getClassLoader()) {
                bl = true;
                thread2.setContextClassLoader(this.getClass().getClassLoader());
            }
            documentBuilder = this.delegate.newDocumentBuilder();
            Object var6_5 = null;
            if (bl) {
                thread2.setContextClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (bl) {
                thread2.setContextClassLoader(classLoader);
            }
            throw throwable;
        }
        if (!this.disabledEntityResolutionRegistry) {
            try {
                RegistryEntityResolver registryEntityResolver = new RegistryEntityResolver();
                documentBuilder.setEntityResolver(registryEntityResolver);
            }
            catch (XMLRegistryException xMLRegistryException) {
                throw new FactoryConfigurationError((Exception)((Object)xMLRegistryException), "Could not access XML Registry");
            }
        }
        return documentBuilder;
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        this.delegate.setAttribute(string, object);
    }

    public void setCoalescing(boolean bl) {
        this.delegate.setCoalescing(bl);
    }

    public void setDisabledEntityResolutionRegistry(boolean bl) {
        this.disabledEntityResolutionRegistry = bl;
    }

    public void setExpandEntityReferences(boolean bl) {
        this.delegate.setExpandEntityReferences(bl);
    }

    public void setIgnoringComments(boolean bl) {
        this.delegate.setIgnoringComments(bl);
    }

    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.delegate.setIgnoringElementContentWhitespace(bl);
    }

    public void setNamespaceAware(boolean bl) {
        this.delegate.setNamespaceAware(bl);
    }

    public void setValidating(boolean bl) {
        this.delegate.setValidating(bl);
    }

    public boolean getFeature(String string) throws ParserConfigurationException {
        return this.delegate.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException {
        this.delegate.setFeature(string, bl);
    }

    public boolean isXIncludeAware() throws UnsupportedOperationException {
        return this.delegate.isXIncludeAware();
    }

    public void setXIncludeAware(boolean bl) throws UnsupportedOperationException {
        this.delegate.setXIncludeAware(bl);
    }

    public Schema getSchema() throws UnsupportedOperationException {
        return this.delegate.getSchema();
    }

    public void setSchema(Schema schema) throws UnsupportedOperationException {
        this.delegate.setSchema(schema);
    }
}

