/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import weblogic.xml.jaxp.ChainingEntityResolver;
import weblogic.xml.jaxp.XMLContext;
import weblogic.xml.registry.RegistryEntityResolver;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.util.Debug;

public class WebLogicParser
implements Parser {
    static Debug.DebugFacility dbg = XMLContext.dbg;
    private final ChainingEntityResolver chainingEntityResolver = new ChainingEntityResolver();
    private Parser parser;
    private boolean entityResolverDisabled;

    public WebLogicParser(SAXParser sAXParser, boolean bl) {
        try {
            this.parser = sAXParser.getParser();
            this.entityResolverDisabled = bl;
            if (!bl) {
                this.chainingEntityResolver.pushEntityResolver(new RegistryEntityResolver());
                this.parser.setEntityResolver(this.chainingEntityResolver);
            }
        }
        catch (SAXException sAXException) {
            throw new FactoryConfigurationError(sAXException, "Error getting a parser from a factory " + sAXException.getMessage());
        }
        catch (XMLRegistryException xMLRegistryException) {
            throw new FactoryConfigurationError((Exception)((Object)xMLRegistryException), "Could not access XML Registry");
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.parser.parse(inputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        this.parser.parse(string);
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.parser.setDocumentHandler(documentHandler);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.parser.setDTDHandler(dTDHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (dbg.areDebuggingAt(2)) {
            int n = this.chainingEntityResolver.getResolverCount();
            dbg.assertion(n == 1 || n == 2);
        }
        if (this.chainingEntityResolver.getResolverCount() == 2) {
            this.chainingEntityResolver.popEntityResolver();
        }
        this.chainingEntityResolver.pushEntityResolver(entityResolver);
        if (this.entityResolverDisabled) {
            this.enableEntityResolver();
        }
    }

    private synchronized void enableEntityResolver() {
        if (!this.entityResolverDisabled) {
            return;
        }
        this.parser.setEntityResolver(this.chainingEntityResolver);
        this.entityResolverDisabled = false;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    public void setLocale(Locale locale) throws SAXException {
        this.parser.setLocale(locale);
    }
}

