/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import weblogic.xml.jaxp.Utils;
import weblogic.xml.jaxp.WebLogicSAXParser;

public class WebLogicSAXParserFactory
extends SAXParserFactory {
    static boolean allow_external_dtd = !"false".equalsIgnoreCase(System.getProperty("weblogic.xml.jaxp.allow.externalDTD"));
    static boolean IBM = System.getProperty("java.vendor", "unknown").toLowerCase(Locale.ENGLISH).indexOf("ibm") >= 0;
    String[] parserFactories = new String[]{"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", "weblogic.apache.xerces.jaxp.SAXParserFactoryImpl"};
    private static String[] ibmParserFactories = new String[]{"org.apache.xerces.jaxp.SAXParserFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", "weblogic.apache.xerces.jaxp.SAXParserFactoryImpl"};
    private SAXParserFactory factory = IBM ? (SAXParserFactory)Utils.getDelegate(ibmParserFactories) : (SAXParserFactory)Utils.getDelegate(this.parserFactories);
    private boolean disabledEntityResolutionRegistry = false;

    public WebLogicSAXParserFactory() {
        try {
            this.factory.setFeature("http://xml.org/sax/features/external-general-entities", allow_external_dtd);
            this.factory.setFeature("http://xml.org/sax/features/external-parameter-entities", allow_external_dtd);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        WebLogicSAXParser webLogicSAXParser = null;
        boolean bl = false;
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        try {
            if (classLoader != this.getClass().getClassLoader()) {
                bl = true;
                thread2.setContextClassLoader(this.getClass().getClassLoader());
            }
            webLogicSAXParser = new WebLogicSAXParser(this.factory, this.disabledEntityResolutionRegistry);
            Object var6_5 = null;
            if (bl) {
                thread2.setContextClassLoader(classLoader);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (bl) {
                thread2.setContextClassLoader(classLoader);
            }
            throw throwable;
        }
        return webLogicSAXParser;
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.factory.setFeature(string, bl);
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.factory.getFeature(string);
    }

    public boolean isDisabledEntityResolutionRegistry() {
        return this.disabledEntityResolutionRegistry;
    }

    public void setDisabledEntityResolutionRegistry(boolean bl) {
        this.disabledEntityResolutionRegistry = bl;
    }

    public void setNamespaceAware(boolean bl) {
        this.factory.setNamespaceAware(bl);
    }

    public boolean isNamespaceAware() {
        return this.factory.isNamespaceAware();
    }

    public void setValidating(boolean bl) {
        this.factory.setValidating(bl);
    }

    public boolean isValidating() {
        return this.factory.isValidating();
    }

    public boolean isXIncludeAware() throws UnsupportedOperationException {
        return this.factory.isXIncludeAware();
    }

    public void setXIncludeAware(boolean bl) throws UnsupportedOperationException {
        this.factory.setXIncludeAware(bl);
    }

    public Schema getSchema() throws UnsupportedOperationException {
        return this.factory.getSchema();
    }

    public void setSchema(Schema schema) throws UnsupportedOperationException {
        this.factory.setSchema(schema);
    }
}

