/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxp;

import java.io.IOException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import weblogic.xml.jaxp.ChainingEntityResolver;
import weblogic.xml.jaxp.XMLContext;
import weblogic.xml.registry.RegistryEntityResolver;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.util.Debug;

public class WebLogicXMLReader
implements XMLReader {
    static Debug.DebugFacility dbg = XMLContext.dbg;
    private final ChainingEntityResolver chainingEntityResolver = new ChainingEntityResolver();
    private XMLReader xmlReader;

    public WebLogicXMLReader() {
    }

    public WebLogicXMLReader(SAXParser sAXParser) {
        try {
            this.xmlReader = sAXParser.getXMLReader();
            this.chainingEntityResolver.pushEntityResolver(new RegistryEntityResolver());
            this.xmlReader.setEntityResolver(this.chainingEntityResolver);
        }
        catch (SAXException sAXException) {
            throw new FactoryConfigurationError(sAXException, "Error getting a parser from a factory " + sAXException.getMessage());
        }
        catch (XMLRegistryException xMLRegistryException) {
            throw new FactoryConfigurationError((Exception)((Object)xMLRegistryException), "Could not access XML Registry");
        }
    }

    public ContentHandler getContentHandler() {
        return this.xmlReader.getContentHandler();
    }

    public DTDHandler getDTDHandler() {
        return this.xmlReader.getDTDHandler();
    }

    public EntityResolver getEntityResolver() {
        return this.chainingEntityResolver.peekEntityResolver();
    }

    public ErrorHandler getErrorHandler() {
        return this.xmlReader.getErrorHandler();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getFeature(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getProperty(string);
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        dbg.assertion(this.xmlReader != null);
        this.xmlReader.parse(inputSource);
    }

    public void parse(String string) throws SAXException, IOException {
        dbg.assertion(this.xmlReader != null);
        this.xmlReader.parse(string);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.xmlReader.setContentHandler(contentHandler);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.xmlReader.setDTDHandler(dTDHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        if (dbg.areDebuggingAt(2)) {
            int n = this.chainingEntityResolver.getResolverCount();
            dbg.assertion(n == 1 || n == 2);
        }
        if (this.chainingEntityResolver.getResolverCount() == 2) {
            this.chainingEntityResolver.popEntityResolver();
        }
        this.chainingEntityResolver.pushEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.xmlReader.setErrorHandler(errorHandler);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setFeature(string, bl);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setProperty(string, object);
    }
}

