/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import weblogic.xml.jaxr.registry.infomodel.RegistryObjectImpl;

public abstract class BaseJAXRObject {
    private static ThreadLocal inProcess = new ThreadLocal();

    private boolean isInProcess() {
        return (Boolean)inProcess.get();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BaseJAXRObject)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BaseJAXRObject baseJAXRObject = (BaseJAXRObject)object;
        Object[] objectArray = this.getDefiningElements();
        if (objectArray == null) {
            return super.equals(object);
        }
        Object[] objectArray2 = baseJAXRObject.getDefiningElements();
        boolean bl = Arrays.equals(objectArray, objectArray2);
        return bl;
    }

    public int hashCode() {
        Object[] objectArray = this.getDefiningElements();
        if (objectArray == null) {
            return super.hashCode();
        }
        if (objectArray.length == 0) {
            return 0;
        }
        int n = 17;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            n = 37 * n + object.hashCode();
        }
        return n;
    }

    public String toString() {
        inProcess.set(Boolean.TRUE);
        Object[] objectArray = this.getDefiningElements();
        if (objectArray == null) {
            return super.toString();
        }
        String[] stringArray = this.getVariableNames();
        String string = BaseJAXRObject.toStringImplementation(this, objectArray, stringArray);
        inProcess.set(Boolean.FALSE);
        return string;
    }

    protected Object[] getDefiningElements() {
        return null;
    }

    protected String[] getVariableNames() {
        return null;
    }

    protected static String toStringImplementation(Object object, Object[] objectArray, String[] stringArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        boolean bl = false;
        if (stringArray != null && stringArray.length == objectArray.length) {
            bl = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(object.getClass().getName());
        stringBuffer.append(": \n[\n");
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (bl) {
                stringBuffer.append(stringArray[i]);
            } else if (object2 != null) {
                stringBuffer.append(object2.getClass().getName());
            } else {
                stringBuffer.append("unknown");
            }
            stringBuffer.append(": ");
            if (object2 instanceof BaseJAXRObject && ((BaseJAXRObject)object2).isInProcess()) {
                stringBuffer.append("");
            } else {
                stringBuffer.append(object2);
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static String toString(Object[] objectArray) {
        String string = objectArray == null ? "[]" : Arrays.asList(objectArray).toString();
        return string;
    }

    protected static Object[] mergeObjectArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null || objectArray.length == 0) {
            return objectArray2;
        }
        if (objectArray2 == null || objectArray2.length == 0) {
            return objectArray;
        }
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    protected static String[] mergeStringArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray2;
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    protected String getName(Object object) {
        String string;
        if (object == null) {
            string = "Null";
        } else if (object instanceof RegistryObjectImpl) {
            RegistryObjectImpl registryObjectImpl = (RegistryObjectImpl)object;
            string = registryObjectImpl.getName().toString();
        } else {
            string = object.getClass().getName();
        }
        return string;
    }

    protected String getNames(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        if (collection == null) {
            stringBuffer.append("Null");
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("-").append(this.getName(iterator.next()));
            }
        }
        return stringBuffer.toString();
    }

    protected void checkCapability(RegistryService registryService, int n) throws JAXRException {
        if (n > registryService.getCapabilityProfile().getCapabilityLevel()) {
            throw new UnsupportedCapabilityException();
        }
    }
}

