/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry;

import java.util.Collection;
import java.util.Collections;
import javax.xml.registry.BulkResponse;
import weblogic.xml.jaxr.registry.JAXRResponseImpl;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;

public class BulkResponseImpl
extends JAXRResponseImpl
implements BulkResponse {
    private static final long serialVersionUID = -1L;
    private Collection m_data;
    private Collection m_exceptions;
    private boolean m_isPartial;

    public BulkResponseImpl(RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
        this.setResponse(Collections.EMPTY_LIST, null, false);
    }

    public Collection getCollection() {
        this.handleAsynchronous();
        return this.m_data;
    }

    public Collection getExceptions() {
        this.handleAsynchronous();
        return this.m_exceptions;
    }

    public boolean isPartialResponse() {
        return this.m_isPartial;
    }

    public void setResponse(Collection collection, Collection collection2, boolean bl) {
        this.m_data = collection;
        this.m_exceptions = collection2;
        this.m_isPartial = bl;
        int n = collection2 != null && collection2.size() > 0 ? 2 : (collection != null ? 0 : 3);
        this.setStatus(n);
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_data, this.m_exceptions, new Boolean(this.m_isPartial)};
        Object[] objectArray2 = BulkResponseImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_data", "m_exceptions", "m_isPartial"};
        String[] stringArray2 = BulkResponseImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsynchronous() {
        if (!this.isAvailable()) {
            BulkResponseImpl bulkResponseImpl = this;
            synchronized (bulkResponseImpl) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.getLogger().debug("Unexpected interruption of thread wait");
                    this.getLogger().debug(interruptedException);
                }
            }
        }
    }
}

