/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry;

import java.util.Collection;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import weblogic.xml.jaxr.registry.LifeCycleManagerImpl;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.command.CommandHandler;
import weblogic.xml.jaxr.registry.command.DeleteAssociationsCommand;
import weblogic.xml.jaxr.registry.command.DeleteClassificationSchemesCommand;
import weblogic.xml.jaxr.registry.command.DeleteConceptsCommand;
import weblogic.xml.jaxr.registry.command.DeleteOrganizationsCommand;
import weblogic.xml.jaxr.registry.command.DeleteServiceBindingsCommand;
import weblogic.xml.jaxr.registry.command.DeleteServicesCommand;
import weblogic.xml.jaxr.registry.command.SaveAssociationsCommand;
import weblogic.xml.jaxr.registry.command.SaveClassificationSchemesCommand;
import weblogic.xml.jaxr.registry.command.SaveConceptsCommand;
import weblogic.xml.jaxr.registry.command.SaveOrganizationsCommand;
import weblogic.xml.jaxr.registry.command.SaveServiceBindingsCommand;
import weblogic.xml.jaxr.registry.command.SaveServicesCommand;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class BusinessLifeCycleManagerImpl
extends LifeCycleManagerImpl
implements BusinessLifeCycleManager {
    public BusinessLifeCycleManagerImpl(RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
    }

    public BulkResponse saveOrganizations(Collection collection) throws JAXRException {
        this.getLogger().trace("+BusinessLifeCycleManager.saveOrganizations()");
        this.getLogger().debug("Save Organizations called with organizations [" + collection + "]");
        JAXRUtil.verifyCollectionContent(collection, Organization.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        SaveOrganizationsCommand saveOrganizationsCommand = new SaveOrganizationsCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(saveOrganizationsCommand);
        this.getLogger().debug("Save Organizations will return bulkResponse [" + bulkResponse + "]");
        this.getLogger().trace("-BusinessLifeCycleManager.saveOrganizations()");
        return bulkResponse;
    }

    public BulkResponse saveServices(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Service.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        SaveServicesCommand saveServicesCommand = new SaveServicesCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(saveServicesCommand);
        return bulkResponse;
    }

    public BulkResponse saveServiceBindings(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, ServiceBinding.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        SaveServiceBindingsCommand saveServiceBindingsCommand = new SaveServiceBindingsCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(saveServiceBindingsCommand);
        return bulkResponse;
    }

    public BulkResponse saveConcepts(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Concept.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        SaveConceptsCommand saveConceptsCommand = new SaveConceptsCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(saveConceptsCommand);
        return bulkResponse;
    }

    public BulkResponse saveClassificationSchemes(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, ClassificationScheme.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        SaveClassificationSchemesCommand saveClassificationSchemesCommand = new SaveClassificationSchemesCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(saveClassificationSchemesCommand);
        return bulkResponse;
    }

    public BulkResponse saveAssociations(Collection collection, boolean bl) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Association.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        SaveAssociationsCommand saveAssociationsCommand = new SaveAssociationsCommand(registryServiceImpl, collection, bl);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(saveAssociationsCommand);
        return bulkResponse;
    }

    public BulkResponse deleteOrganizations(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Key.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        DeleteOrganizationsCommand deleteOrganizationsCommand = new DeleteOrganizationsCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(deleteOrganizationsCommand);
        return bulkResponse;
    }

    public BulkResponse deleteServices(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Key.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        DeleteServicesCommand deleteServicesCommand = new DeleteServicesCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(deleteServicesCommand);
        return bulkResponse;
    }

    public BulkResponse deleteServiceBindings(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Key.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        DeleteServiceBindingsCommand deleteServiceBindingsCommand = new DeleteServiceBindingsCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(deleteServiceBindingsCommand);
        return bulkResponse;
    }

    public BulkResponse deleteConcepts(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Key.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        DeleteConceptsCommand deleteConceptsCommand = new DeleteConceptsCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(deleteConceptsCommand);
        return bulkResponse;
    }

    public BulkResponse deleteClassificationSchemes(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Key.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        DeleteClassificationSchemesCommand deleteClassificationSchemesCommand = new DeleteClassificationSchemesCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(deleteClassificationSchemesCommand);
        return bulkResponse;
    }

    public BulkResponse deleteAssociations(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Key.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        DeleteAssociationsCommand deleteAssociationsCommand = new DeleteAssociationsCommand(registryServiceImpl, collection);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(deleteAssociationsCommand);
        return bulkResponse;
    }

    public void confirmAssociation(Association association) throws JAXRException, InvalidRequestException {
        JAXRUtil.verifyNotNull(association, Association.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        registryServiceImpl.getRegistryProxy().confirmAssociation(association);
    }

    public void unConfirmAssociation(Association association) throws JAXRException, InvalidRequestException {
        JAXRUtil.verifyNotNull(association, Association.class);
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        registryServiceImpl.getRegistryProxy().unConfirmAssociation(association);
    }
}

