/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry;

import java.util.Collection;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import weblogic.xml.jaxr.registry.QueryManagerImpl;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.command.CommandHandler;
import weblogic.xml.jaxr.registry.command.FindAssociationsCommand;
import weblogic.xml.jaxr.registry.command.FindCallerAssociationsCommand;
import weblogic.xml.jaxr.registry.command.FindClassificationSchemesCommand;
import weblogic.xml.jaxr.registry.command.FindConceptsCommand;
import weblogic.xml.jaxr.registry.command.FindOrganizationsCommand;
import weblogic.xml.jaxr.registry.command.FindServiceBindingsCommand;
import weblogic.xml.jaxr.registry.command.FindServicesCommand;

public class BusinessQueryManagerImpl
extends QueryManagerImpl
implements BusinessQueryManager {
    public BusinessQueryManagerImpl(RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
    }

    public BulkResponse findAssociations(Collection collection, String string, String string2, Collection collection2) throws JAXRException {
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        FindAssociationsCommand findAssociationsCommand = new FindAssociationsCommand(registryServiceImpl, collection, string, string2, collection2);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(findAssociationsCommand);
        return bulkResponse;
    }

    public BulkResponse findCallerAssociations(Collection collection, Boolean bl, Boolean bl2, Collection collection2) throws JAXRException {
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        FindCallerAssociationsCommand findCallerAssociationsCommand = new FindCallerAssociationsCommand(registryServiceImpl, collection, bl, bl2, collection2);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(findCallerAssociationsCommand);
        return bulkResponse;
    }

    public BulkResponse findOrganizations(Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, Collection collection6) throws JAXRException {
        this.getLogger().trace("+BusinessQueryManager.findOrganizations()");
        this.getLogger().debug("Find Organizations called with findQualifiers [" + collection + "] namePatterns [" + collection2 + "] classifications [" + collection3 + "] specifications [" + collection4 + "] externalIdentifiers [" + collection5 + "] externalLinks [" + collection6 + "]");
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        FindOrganizationsCommand findOrganizationsCommand = new FindOrganizationsCommand(registryServiceImpl, collection, collection2, collection3, collection4, collection5, collection6);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(findOrganizationsCommand);
        this.getLogger().debug("Find Organizations will return bulkResponse [" + bulkResponse + "]");
        this.getLogger().trace("-BusinessQueryManager.findOrganizations()");
        return bulkResponse;
    }

    public BulkResponse findServices(Key key, Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        FindServicesCommand findServicesCommand = new FindServicesCommand(registryServiceImpl, key, collection, collection2, collection3, collection4);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(findServicesCommand);
        return bulkResponse;
    }

    public BulkResponse findServiceBindings(Key key, Collection collection, Collection collection2, Collection collection3) throws JAXRException {
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        FindServiceBindingsCommand findServiceBindingsCommand = new FindServiceBindingsCommand(registryServiceImpl, key, collection, collection2, collection3);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(findServiceBindingsCommand);
        return bulkResponse;
    }

    public BulkResponse findClassificationSchemes(Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        FindClassificationSchemesCommand findClassificationSchemesCommand = new FindClassificationSchemesCommand(registryServiceImpl, collection, collection2, collection3, collection4);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(findClassificationSchemesCommand);
        return bulkResponse;
    }

    public ClassificationScheme findClassificationSchemeByName(Collection collection, String string) throws JAXRException {
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        return registryServiceImpl.getRegistryProxy().findClassificationSchemeByName(collection, string);
    }

    public BulkResponse findConcepts(Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5) throws JAXRException {
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        FindConceptsCommand findConceptsCommand = new FindConceptsCommand(registryServiceImpl, collection, collection2, collection3, collection4, collection5);
        BulkResponse bulkResponse = CommandHandler.runBulkQueryCommand(findConceptsCommand);
        return bulkResponse;
    }

    public Concept findConceptByPath(String string) throws JAXRException {
        RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)this.getRegistryService();
        return registryServiceImpl.getRegistryProxy().findConceptByPath(string);
    }

    public BulkResponse findRegistryPackages(Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
        this.checkCapability(this.getRegistryService(), 1);
        return null;
    }
}

