/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry;

import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.Connection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import weblogic.xml.jaxr.registry.BaseJAXRObject;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.provider.EnvironmentHelper;
import weblogic.xml.jaxr.registry.provider.ProviderInfo;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;

public class ConnectionImpl
extends BaseJAXRObject
implements Connection {
    private Properties m_properties;
    private ProviderInfo m_providerInfo;
    private RegistryServiceImpl m_registryService;
    private Set m_credentials;
    private boolean m_isSynchronous = true;
    private URL m_queryURL;
    private URL m_publishURL;
    private boolean m_isClosed = false;
    private Boolean m_isContainer;

    public ConnectionImpl(Properties properties, ProviderInfo providerInfo) throws JAXRException {
        this.m_properties = properties == null ? new Properties() : properties;
        this.m_providerInfo = providerInfo;
        String string = this.m_properties.getProperty("javax.xml.registry.queryManagerURL");
        String string2 = this.m_properties.getProperty("javax.xml.registry.lifeCycleManagerURL");
        try {
            this.m_queryURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = JAXRMessages.getMessage("jaxr.provider.invalidQueryURL", new Object[]{string});
            throw new InvalidRequestException(string3);
        }
        if (string2 == null || string2.length() == 0) {
            this.m_publishURL = this.m_queryURL;
        } else {
            try {
                this.m_publishURL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                String string4 = JAXRMessages.getMessage("jaxr.provider.invalidPublishURL", new Object[]{string2});
                throw new InvalidRequestException(string4);
            }
        }
        String string5 = this.m_properties.getProperty("javax.xml.registry.security.authenticationMethod");
        if ("CLIENT_CERTIFICATE".equalsIgnoreCase(string5) || "HTTP_BASIC".equalsIgnoreCase(string5) || "MS_PASSPORT".equalsIgnoreCase(string5)) {
            this.checkCapability(this.m_registryService, 1);
        } else if (string5 != null && !"UDDI_GET_AUTHTOKEN".equalsIgnoreCase(string5)) {
            String string6 = JAXRMessages.getMessage("jaxr.provider.invalidAuthenticationMethod", new String[]{string5});
            throw new InvalidRequestException(string6);
        }
        this.m_registryService = new RegistryServiceImpl(this);
        this.m_isContainer = EnvironmentHelper.getInstance().isJ2EEContainer(this.m_registryService);
    }

    public RegistryService getRegistryService() throws JAXRException {
        if (this.isClosed()) {
            throw new InvalidRequestException(JAXRMessages.getMessage("jaxr.registry.connection.closed"));
        }
        return this.m_registryService;
    }

    public void close() throws JAXRException {
        if (!this.isClosed()) {
            this.m_registryService.closeConnection();
            this.m_registryService = null;
            this.m_isClosed = true;
        }
    }

    public boolean isClosed() throws JAXRException {
        return this.m_isClosed;
    }

    public boolean isSynchronous() throws JAXRException {
        if (this.isClosed()) {
            throw new InvalidRequestException(JAXRMessages.getMessage("jaxr.registry.connection.closed"));
        }
        if (this.m_isSynchronous) {
            return true;
        }
        if (this.m_isContainer != null && this.m_isContainer.booleanValue()) {
            this.m_registryService.getLogger().debug("Running in a container: Always behave synchronously!");
            return true;
        }
        return false;
    }

    public void setSynchronous(boolean bl) throws JAXRException {
        if (this.isClosed()) {
            throw new InvalidRequestException(JAXRMessages.getMessage("jaxr.registry.connection.closed"));
        }
        this.m_isSynchronous = bl;
    }

    public void setCredentials(Set hashSet) throws JAXRException {
        if (this.isClosed()) {
            throw new InvalidRequestException(JAXRMessages.getMessage("jaxr.registry.connection.closed"));
        }
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        this.m_credentials = hashSet;
        String string = null;
        String string2 = null;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext() && string == null) {
            Object e = iterator.next();
            if (!(e instanceof PasswordAuthentication)) continue;
            PasswordAuthentication passwordAuthentication = (PasswordAuthentication)e;
            string = passwordAuthentication.getUserName();
            string2 = new String(passwordAuthentication.getPassword());
        }
        this.m_registryService.setCredentials(string, string2);
    }

    public Set getCredentials() throws JAXRException {
        if (this.isClosed()) {
            throw new InvalidRequestException(JAXRMessages.getMessage("jaxr.registry.connection.closed"));
        }
        return this.m_credentials;
    }

    public URL getQueryURL() throws InvalidRequestException, JAXRException {
        if (this.isClosed()) {
            throw new InvalidRequestException(JAXRMessages.getMessage("jaxr.registry.connection.closed"));
        }
        return this.m_queryURL;
    }

    public URL getPublishURL() throws InvalidRequestException, JAXRException {
        if (this.isClosed()) {
            throw new InvalidRequestException(JAXRMessages.getMessage("jaxr.registry.connection.closed"));
        }
        return this.m_publishURL;
    }

    public Integer getMaxRows() {
        Integer n;
        String string = this.m_properties.getProperty("javax.xml.registry.uddi.maxRows");
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = null;
        }
        return n;
    }

    ProviderInfo getProviderInfo() {
        return this.m_providerInfo;
    }

    Properties getProperties() {
        return this.m_properties;
    }
}

