/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import weblogic.xml.jaxr.registry.BaseJAXRObject;
import weblogic.xml.jaxr.registry.BulkResponseImpl;
import weblogic.xml.jaxr.registry.BusinessLifeCycleManagerImpl;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.bridge.uddi.UDDIBridgeMapperUtil;
import weblogic.xml.jaxr.registry.infomodel.AssociationImpl;
import weblogic.xml.jaxr.registry.infomodel.AuditableEventImpl;
import weblogic.xml.jaxr.registry.infomodel.BaseInfoModelObject;
import weblogic.xml.jaxr.registry.infomodel.ClassificationImpl;
import weblogic.xml.jaxr.registry.infomodel.ClassificationSchemeImpl;
import weblogic.xml.jaxr.registry.infomodel.ConceptImpl;
import weblogic.xml.jaxr.registry.infomodel.EmailAddressImpl;
import weblogic.xml.jaxr.registry.infomodel.ExternalIdentifierImpl;
import weblogic.xml.jaxr.registry.infomodel.ExternalLinkImpl;
import weblogic.xml.jaxr.registry.infomodel.ExtrinsicObjectImpl;
import weblogic.xml.jaxr.registry.infomodel.InternationalStringImpl;
import weblogic.xml.jaxr.registry.infomodel.KeyImpl;
import weblogic.xml.jaxr.registry.infomodel.LocalizedStringImpl;
import weblogic.xml.jaxr.registry.infomodel.OrganizationImpl;
import weblogic.xml.jaxr.registry.infomodel.PersonNameImpl;
import weblogic.xml.jaxr.registry.infomodel.PostalAddressImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryEntryImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryPackageImpl;
import weblogic.xml.jaxr.registry.infomodel.ServiceBindingImpl;
import weblogic.xml.jaxr.registry.infomodel.ServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.SlotImpl;
import weblogic.xml.jaxr.registry.infomodel.SpecificationLinkImpl;
import weblogic.xml.jaxr.registry.infomodel.TelephoneNumberImpl;
import weblogic.xml.jaxr.registry.infomodel.UserImpl;
import weblogic.xml.jaxr.registry.infomodel.VersionableImpl;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;
import weblogic.xml.jaxr.registry.util.JAXRLogger;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class LifeCycleManagerImpl
extends BaseJAXRObject
implements LifeCycleManager {
    private RegistryServiceImpl m_registryServiceImpl;
    private Map m_objects;
    private Map m_capabilities;

    public LifeCycleManagerImpl(RegistryServiceImpl registryServiceImpl) {
        this.m_registryServiceImpl = registryServiceImpl;
        if (this.m_objects == null) {
            this.m_objects = LifeCycleManagerImpl.getAllObjects();
        }
        if (this.m_capabilities == null) {
            this.m_capabilities = this.getCapabilityLevels();
        }
    }

    public Object createObject(String string) throws JAXRException, InvalidRequestException {
        try {
            Object t;
            Class clazz = (Class)this.m_objects.get(string);
            if (clazz == null) {
                String string2 = JAXRMessages.getMessage("jaxr.registry.createObject.unknownType", new Object[]{string});
                throw new InvalidRequestException(string2);
            }
            int n = this.m_registryServiceImpl.getCapabilityProfile().getCapabilityLevel();
            int n2 = (Integer)this.m_capabilities.get(string);
            if (n2 > n) {
                String string3 = JAXRMessages.getMessage("jaxr.registry.invalidClassCapability", new Object[]{string, new Integer(n), new Integer(n2)});
                throw new UnsupportedCapabilityException(string3);
            }
            if (BaseInfoModelObject.class.isAssignableFrom(clazz)) {
                Constructor constructor = clazz.getConstructor(this.m_registryServiceImpl.getClass());
                t = constructor.newInstance(this.m_registryServiceImpl);
            } else {
                t = clazz.newInstance();
            }
            return t;
        }
        catch (InstantiationException instantiationException) {
            String string4 = JAXRMessages.getMessage("jaxr.registry.lifeCycleManagerImplException", new Object[]{"InstantiationException"});
            throw new JAXRException(string4, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = JAXRMessages.getMessage("jaxr.registry.lifeCycleManagerImplException", new Object[]{"IllegalAccessException"});
            throw new JAXRException(string5, (Throwable)illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string6 = JAXRMessages.getMessage("jaxr.registry.lifeCycleManagerImplException", new Object[]{"NoSuchMethodException"});
            throw new JAXRException(string6, (Throwable)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string7 = JAXRMessages.getMessage("jaxr.registry.lifeCycleManagerImplException", new Object[]{"InvocationTargetException"});
            throw new JAXRException(string7, (Throwable)invocationTargetException);
        }
    }

    public Association createAssociation(RegistryObject registryObject, Concept concept) throws JAXRException {
        AssociationImpl associationImpl = new AssociationImpl(this.m_registryServiceImpl);
        associationImpl.setTargetObject(registryObject);
        associationImpl.setAssociationType(concept);
        return associationImpl;
    }

    public Classification createClassification(ClassificationScheme classificationScheme, String string, String string2) throws JAXRException {
        ClassificationImpl classificationImpl = new ClassificationImpl(this.m_registryServiceImpl);
        classificationImpl.setClassificationScheme(classificationScheme);
        classificationImpl.setName(new InternationalStringImpl(string, this.m_registryServiceImpl));
        classificationImpl.setValue(string2);
        return classificationImpl;
    }

    public Classification createClassification(ClassificationScheme classificationScheme, InternationalString internationalString, String string) throws JAXRException {
        ClassificationImpl classificationImpl = new ClassificationImpl(this.m_registryServiceImpl);
        classificationImpl.setClassificationScheme(classificationScheme);
        classificationImpl.setName(internationalString);
        classificationImpl.setValue(string);
        return classificationImpl;
    }

    public Classification createClassification(Concept concept) throws JAXRException, InvalidRequestException {
        if (concept.getClassificationScheme() != null) {
            ClassificationImpl classificationImpl = new ClassificationImpl(this.m_registryServiceImpl);
            classificationImpl.setConcept(concept);
            return classificationImpl;
        }
        String string = JAXRMessages.getMessage("jaxr.registry.invalidConcept");
        throw new InvalidRequestException(string);
    }

    public ClassificationScheme createClassificationScheme(String string, String string2) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl classificationSchemeImpl = new ClassificationSchemeImpl(this.m_registryServiceImpl);
        classificationSchemeImpl.setName(new InternationalStringImpl(string, this.m_registryServiceImpl));
        classificationSchemeImpl.setDescription(new InternationalStringImpl(string2, this.m_registryServiceImpl));
        return classificationSchemeImpl;
    }

    public ClassificationScheme createClassificationScheme(InternationalString internationalString, InternationalString internationalString2) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl classificationSchemeImpl = new ClassificationSchemeImpl(this.m_registryServiceImpl);
        classificationSchemeImpl.setName(internationalString);
        classificationSchemeImpl.setDescription(internationalString2);
        return classificationSchemeImpl;
    }

    public ClassificationScheme createClassificationScheme(Concept concept) throws JAXRException, InvalidRequestException {
        if (concept.getClassificationScheme() == null && concept.getParentConcept() == null) {
            ClassificationSchemeImpl classificationSchemeImpl = new ClassificationSchemeImpl(concept, this.m_registryServiceImpl);
            return classificationSchemeImpl;
        }
        throw new InvalidRequestException();
    }

    public Concept createConcept(RegistryObject registryObject, String string, String string2) throws JAXRException {
        ConceptImpl conceptImpl = new ConceptImpl(registryObject, new InternationalStringImpl(string, this.m_registryServiceImpl), string2, this.m_registryServiceImpl);
        return conceptImpl;
    }

    public Concept createConcept(RegistryObject registryObject, InternationalString internationalString, String string) throws JAXRException {
        ConceptImpl conceptImpl = new ConceptImpl(registryObject, internationalString, string, this.m_registryServiceImpl);
        return conceptImpl;
    }

    public EmailAddress createEmailAddress(String string) throws JAXRException {
        EmailAddressImpl emailAddressImpl = new EmailAddressImpl(this.m_registryServiceImpl);
        emailAddressImpl.setAddress(string);
        return emailAddressImpl;
    }

    public EmailAddress createEmailAddress(String string, String string2) throws JAXRException {
        EmailAddressImpl emailAddressImpl = new EmailAddressImpl(this.m_registryServiceImpl);
        emailAddressImpl.setAddress(string);
        emailAddressImpl.setType(string2);
        return emailAddressImpl;
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme classificationScheme, String string, String string2) throws JAXRException {
        return this.createExternalIdentifier(classificationScheme, new InternationalStringImpl(string, this.m_registryServiceImpl), string2);
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme classificationScheme, InternationalString internationalString, String string) throws JAXRException {
        ExternalIdentifierImpl externalIdentifierImpl = new ExternalIdentifierImpl(this.m_registryServiceImpl);
        externalIdentifierImpl.setIdentificationScheme(classificationScheme);
        externalIdentifierImpl.setName(internationalString);
        externalIdentifierImpl.setValue(string);
        return externalIdentifierImpl;
    }

    public ExternalLink createExternalLink(String string, String string2) throws JAXRException {
        return this.createExternalLink(string, new InternationalStringImpl(string2, this.m_registryServiceImpl));
    }

    public ExternalLink createExternalLink(String string, InternationalString internationalString) throws JAXRException {
        ExternalLinkImpl externalLinkImpl = new ExternalLinkImpl(this.m_registryServiceImpl);
        externalLinkImpl.setDescription(internationalString);
        externalLinkImpl.setExternalURI(string, false);
        return externalLinkImpl;
    }

    public ExtrinsicObject createExtrinsicObject(DataHandler dataHandler) throws JAXRException {
        this.checkCapability(this.getRegistryService(), 1);
        return null;
    }

    public InternationalString createInternationalString() throws JAXRException {
        return new InternationalStringImpl(this.m_registryServiceImpl);
    }

    public InternationalString createInternationalString(String string) throws JAXRException {
        return new InternationalStringImpl(string, this.m_registryServiceImpl);
    }

    public InternationalString createInternationalString(Locale locale, String string) throws JAXRException {
        return new InternationalStringImpl(locale, string, this.m_registryServiceImpl);
    }

    public Key createKey(String string) throws JAXRException {
        return new KeyImpl(string, this.m_registryServiceImpl);
    }

    public LocalizedString createLocalizedString(Locale locale, String string) throws JAXRException {
        JAXRUtil.verifyNotNull(string, String.class);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return new LocalizedStringImpl(locale, string, this.m_registryServiceImpl);
    }

    public LocalizedString createLocalizedString(Locale locale, String string, String string2) throws JAXRException {
        JAXRUtil.verifyNotNull(string, String.class);
        JAXRUtil.verifyNotNull(string2, String.class);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return new LocalizedStringImpl(locale, string, string2, this.m_registryServiceImpl);
    }

    public Organization createOrganization(String string) throws JAXRException {
        return new OrganizationImpl(new InternationalStringImpl(string, this.m_registryServiceImpl), this.m_registryServiceImpl);
    }

    public Organization createOrganization(InternationalString internationalString) throws JAXRException {
        return new OrganizationImpl(internationalString, this.m_registryServiceImpl);
    }

    public PersonName createPersonName(String string, String string2, String string3) throws JAXRException {
        this.checkCapability(this.getRegistryService(), 1);
        return null;
    }

    public PersonName createPersonName(String string) throws JAXRException {
        PersonNameImpl personNameImpl = new PersonNameImpl(this.m_registryServiceImpl);
        personNameImpl.setFullName(string);
        return personNameImpl;
    }

    public PostalAddress createPostalAddress(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws JAXRException {
        PostalAddressImpl postalAddressImpl = new PostalAddressImpl(this.m_registryServiceImpl);
        postalAddressImpl.setCity(string3);
        postalAddressImpl.setCountry(string5);
        postalAddressImpl.setPostalCode(string6);
        postalAddressImpl.setStateOrProvince(string4);
        postalAddressImpl.setStreet(string2);
        postalAddressImpl.setStreetNumber(string);
        postalAddressImpl.setType(string7);
        return postalAddressImpl;
    }

    public RegistryPackage createRegistryPackage(String string) throws JAXRException {
        this.checkCapability(this.getRegistryService(), 1);
        return null;
    }

    public RegistryPackage createRegistryPackage(InternationalString internationalString) throws JAXRException {
        this.checkCapability(this.getRegistryService(), 1);
        return null;
    }

    public Service createService(String string) throws JAXRException {
        return this.createService(new InternationalStringImpl(string, this.m_registryServiceImpl));
    }

    public Service createService(InternationalString internationalString) throws JAXRException {
        ServiceImpl serviceImpl = new ServiceImpl(this.m_registryServiceImpl);
        serviceImpl.setName(internationalString);
        return serviceImpl;
    }

    public ServiceBinding createServiceBinding() throws JAXRException {
        return new ServiceBindingImpl(this.m_registryServiceImpl);
    }

    public Slot createSlot(String string, String string2, String string3) throws JAXRException {
        SlotImpl slotImpl = new SlotImpl(this.m_registryServiceImpl);
        slotImpl.setName(string);
        slotImpl.setSlotType(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        slotImpl.setValues(arrayList);
        return slotImpl;
    }

    public Slot createSlot(String string, Collection collection, String string2) throws JAXRException {
        SlotImpl slotImpl = new SlotImpl(this.m_registryServiceImpl);
        slotImpl.setName(string);
        slotImpl.setSlotType(string2);
        slotImpl.setValues(collection);
        return slotImpl;
    }

    public SpecificationLink createSpecificationLink() throws JAXRException {
        SpecificationLinkImpl specificationLinkImpl = new SpecificationLinkImpl(this.m_registryServiceImpl);
        return specificationLinkImpl;
    }

    public TelephoneNumber createTelephoneNumber() throws JAXRException {
        return new TelephoneNumberImpl(this.m_registryServiceImpl);
    }

    public User createUser() throws JAXRException {
        return new UserImpl(this.m_registryServiceImpl);
    }

    public BulkResponse saveObjects(Collection collection) throws JAXRException {
        BulkResponseImpl bulkResponseImpl = new BulkResponseImpl(this.m_registryServiceImpl);
        BusinessLifeCycleManagerImpl businessLifeCycleManagerImpl = new BusinessLifeCycleManagerImpl(this.m_registryServiceImpl);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BulkResponse bulkResponse;
            ArrayList arrayList = new ArrayList();
            Object e = iterator.next();
            arrayList.add(e);
            if (e instanceof Association) {
                bulkResponse = businessLifeCycleManagerImpl.saveAssociations(arrayList, false);
            } else if (e instanceof ClassificationScheme) {
                bulkResponse = businessLifeCycleManagerImpl.saveClassificationSchemes(arrayList);
            } else if (e instanceof Concept) {
                bulkResponse = businessLifeCycleManagerImpl.saveConcepts(arrayList);
            } else if (e instanceof Organization) {
                bulkResponse = businessLifeCycleManagerImpl.saveOrganizations(arrayList);
            } else if (e instanceof ServiceBinding) {
                bulkResponse = businessLifeCycleManagerImpl.saveServiceBindings(arrayList);
            } else if (e instanceof Service) {
                bulkResponse = businessLifeCycleManagerImpl.saveServices(arrayList);
            } else {
                String string = JAXRMessages.getMessage("jaxr.infomodel.collection.invalidRegistryObjectType");
                throw new UnexpectedObjectException(string);
            }
            UDDIBridgeMapperUtil.accumulateBulkResponses(bulkResponseImpl, bulkResponse);
        }
        return bulkResponseImpl;
    }

    public BulkResponse deprecateObjects(Collection collection) throws JAXRException {
        this.checkCapability(this.getRegistryService(), 1);
        return null;
    }

    public BulkResponse unDeprecateObjects(Collection collection) throws JAXRException {
        this.checkCapability(this.getRegistryService(), 1);
        return null;
    }

    public BulkResponse deleteObjects(Collection collection) throws JAXRException {
        this.checkCapability(this.getRegistryService(), 1);
        return null;
    }

    public BulkResponse deleteObjects(Collection collection, String string) throws JAXRException {
        BulkResponse bulkResponse;
        BusinessLifeCycleManagerImpl businessLifeCycleManagerImpl = new BusinessLifeCycleManagerImpl(this.m_registryServiceImpl);
        if (string.equals("Association")) {
            bulkResponse = businessLifeCycleManagerImpl.deleteAssociations(collection);
        } else if (string.equals("ClassificationScheme")) {
            bulkResponse = businessLifeCycleManagerImpl.deleteClassificationSchemes(collection);
        } else if (string.equals("Concept")) {
            bulkResponse = businessLifeCycleManagerImpl.deleteConcepts(collection);
        } else if (string.equals("Organization")) {
            bulkResponse = businessLifeCycleManagerImpl.deleteOrganizations(collection);
        } else if (string.equals("ServiceBinding")) {
            bulkResponse = businessLifeCycleManagerImpl.deleteServiceBindings(collection);
        } else if (string.equals("Service")) {
            bulkResponse = businessLifeCycleManagerImpl.deleteServices(collection);
        } else {
            String string2 = JAXRMessages.getMessage("jaxr.infomodel.collection.invalidRegistryObjectType");
            throw new UnexpectedObjectException(string2);
        }
        return bulkResponse;
    }

    public RegistryService getRegistryService() throws JAXRException {
        return this.m_registryServiceImpl;
    }

    protected JAXRLogger getLogger() {
        return this.m_registryServiceImpl.getLogger();
    }

    private static Map getAllObjects() {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        hashMap.put("Association", AssociationImpl.class);
        hashMap.put("AuditableEvent", AuditableEventImpl.class);
        hashMap.put("Classification", ClassificationImpl.class);
        hashMap.put("ClassificationScheme", ClassificationSchemeImpl.class);
        hashMap.put("Concept", ConceptImpl.class);
        hashMap.put("EmailAddress", EmailAddressImpl.class);
        hashMap.put("ExternalLink", ExternalLinkImpl.class);
        hashMap.put("ExternalIdentifier", ExternalIdentifierImpl.class);
        hashMap.put("ExtrinsicObject", ExtrinsicObjectImpl.class);
        hashMap.put("InternationalString", InternationalStringImpl.class);
        hashMap.put("Key", KeyImpl.class);
        hashMap.put("LocalizedString", LocalizedStringImpl.class);
        hashMap.put("Organization", OrganizationImpl.class);
        hashMap.put("PersonName", PersonNameImpl.class);
        hashMap.put("PostalAddress", PostalAddressImpl.class);
        hashMap.put("RegistryEntry", RegistryEntryImpl.class);
        hashMap.put("RegistryPackage", RegistryPackageImpl.class);
        hashMap.put("Service", ServiceImpl.class);
        hashMap.put("ServiceBinding", ServiceBindingImpl.class);
        hashMap.put("Slot", SlotImpl.class);
        hashMap.put("SpecificationLink", SpecificationLinkImpl.class);
        hashMap.put("TelephoneNumber", TelephoneNumberImpl.class);
        hashMap.put("User", UserImpl.class);
        hashMap.put("Versionable", VersionableImpl.class);
        return hashMap;
    }

    private Map getCapabilityLevels() {
        Integer n = new Integer(0);
        Integer n2 = new Integer(1);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Association", n);
        hashMap.put("AuditableEvent", n2);
        hashMap.put("Classification", n);
        hashMap.put("ClassificationScheme", n);
        hashMap.put("Concept", n);
        hashMap.put("EmailAddress", n);
        hashMap.put("ExternalLink", n);
        hashMap.put("ExternalIdentifier", n);
        hashMap.put("ExtrinsicObject", n2);
        hashMap.put("InternationalString", n);
        hashMap.put("Key", n);
        hashMap.put("LocalizedString", n);
        hashMap.put("Organization", n);
        hashMap.put("PersonName", n);
        hashMap.put("PostalAddress", n);
        hashMap.put("RegistryEntry", n2);
        hashMap.put("RegistryPackage", n2);
        hashMap.put("Service", n);
        hashMap.put("ServiceBinding", n);
        hashMap.put("Slot", n);
        hashMap.put("SpecificationLink", n);
        hashMap.put("TelephoneNumber", n);
        hashMap.put("User", n);
        hashMap.put("Versionable", n2);
        return hashMap;
    }
}

