/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.ClassificationScheme;
import weblogic.xml.jaxr.registry.BaseJAXRObject;
import weblogic.xml.jaxr.registry.BusinessLifeCycleManagerImpl;
import weblogic.xml.jaxr.registry.BusinessQueryManagerImpl;
import weblogic.xml.jaxr.registry.ConnectionImpl;
import weblogic.xml.jaxr.registry.provider.RegistryProxy;
import weblogic.xml.jaxr.registry.provider.RegistryProxyFactory;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;
import weblogic.xml.jaxr.registry.util.JAXRLogger;

public class RegistryServiceImpl
extends BaseJAXRObject
implements RegistryService {
    private ConnectionImpl m_connectionImpl;
    private BusinessLifeCycleManager m_businessLifeCycleManager;
    private BusinessQueryManager m_businessQueryManager;
    private RegistryProxy m_registryProxy;
    private Map m_asynchronousResponses;
    private JAXRLogger m_logger;
    private String m_currentUser;
    private Map m_semanticEquivalences;
    private static int s_sequenceId = 0;

    public RegistryServiceImpl(ConnectionImpl connectionImpl) throws JAXRException {
        this.m_connectionImpl = connectionImpl;
        this.m_registryProxy = this.createRegistryProxy();
        this.m_businessLifeCycleManager = new BusinessLifeCycleManagerImpl(this);
        this.m_businessQueryManager = new BusinessQueryManagerImpl(this);
        this.m_asynchronousResponses = new HashMap();
        String string = connectionImpl.getProperties().getProperty("javax.xml.registry.semanticEquivalences");
        this.m_semanticEquivalences = this.getSemanticEquivalences(string);
    }

    public CapabilityProfile getCapabilityProfile() throws JAXRException {
        return this.m_connectionImpl.getProviderInfo().getCapabilityProfile();
    }

    public BusinessLifeCycleManager getBusinessLifeCycleManager() {
        return this.m_businessLifeCycleManager;
    }

    public BusinessQueryManager getBusinessQueryManager() throws JAXRException {
        return this.m_businessQueryManager;
    }

    public DeclarativeQueryManager getDeclarativeQueryManager() throws JAXRException {
        this.checkCapability(this, 1);
        return null;
    }

    public BulkResponse getBulkResponse(String string) throws InvalidRequestException, JAXRException {
        BulkResponse bulkResponse = (BulkResponse)this.m_asynchronousResponses.get(string);
        if (bulkResponse == null) {
            String string2 = JAXRMessages.getMessage("jaxr.provider.invalidRequestId", new Object[]{string});
            throw new InvalidRequestException(string2);
        }
        this.m_asynchronousResponses.remove(string);
        return bulkResponse;
    }

    public ClassificationScheme getDefaultPostalScheme() throws JAXRException {
        Properties properties = this.m_connectionImpl.getProperties();
        String string = properties.getProperty("javax.xml.registry.postalAddressScheme");
        ClassificationScheme classificationScheme = string == null ? null : this.m_businessQueryManager.findClassificationSchemeByName(null, string);
        return classificationScheme;
    }

    public String makeRegistrySpecificRequest(String string) throws JAXRException {
        String string2 = this.m_registryProxy.makeRegistrySpecificRequest(string);
        return string2;
    }

    public ConnectionImpl getConnectionImpl() {
        return this.m_connectionImpl;
    }

    public void setCredentials(String string, String string2) throws JAXRException {
        this.m_currentUser = string;
        this.m_registryProxy.setCredentials(string, string2);
    }

    public void closeConnection() throws JAXRException {
        if (this.m_registryProxy != null) {
            this.m_registryProxy.closeConnection();
            this.m_registryProxy = null;
        }
    }

    public RegistryProxy getRegistryProxy() throws JAXRException {
        if (this.m_registryProxy == null) {
            String string = JAXRMessages.getMessage("jaxr.provider.connection.closed");
            throw new InvalidRequestException(string);
        }
        return this.m_registryProxy;
    }

    public void addBulkResponse(String string, BulkResponse bulkResponse) {
        this.m_asynchronousResponses.put(string, bulkResponse);
    }

    public JAXRLogger getLogger() {
        if (this.m_logger == null) {
            this.m_logger = this.m_connectionImpl.getProviderInfo().getLogger();
        }
        return this.m_logger;
    }

    public String getCurrentUser() {
        return this.m_currentUser;
    }

    public String getSemanticEquivalent(String string) {
        String string2 = string == null ? null : (String)this.m_semanticEquivalences.get(string);
        return string2;
    }

    public int getSequenceId() {
        return s_sequenceId++;
    }

    private Map getSemanticEquivalences(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                if (stringTokenizer2.countTokens() != 2) continue;
                String string4 = stringTokenizer2.nextToken().trim();
                int n = string4.indexOf("urn:");
                if (n >= 0) {
                    string4 = string4.substring(n + 4);
                }
                if ((n = (string2 = stringTokenizer2.nextToken().trim()).indexOf("urn:")) >= 0) {
                    string2 = string2.substring(n + 4);
                }
                hashMap.put(string4, string2);
                hashMap.put(string2, string4);
            }
        }
        return hashMap;
    }

    private RegistryProxy createRegistryProxy() throws JAXRException {
        RegistryProxyFactory registryProxyFactory = this.m_connectionImpl.getProviderInfo().getRegistryProxyFactory(this);
        return registryProxyFactory.createRegistryProxy();
    }
}

