/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.bridge.uddi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import weblogic.auddi.uddi.FatalErrorException;
import weblogic.auddi.uddi.InvalidKeyPassedException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.UnsupportedException;
import weblogic.auddi.uddi.datastructure.AccessPoint;
import weblogic.auddi.uddi.datastructure.Address;
import weblogic.auddi.uddi.datastructure.AddressLine;
import weblogic.auddi.uddi.datastructure.AddressLines;
import weblogic.auddi.uddi.datastructure.Addresses;
import weblogic.auddi.uddi.datastructure.AssertionStatusItem;
import weblogic.auddi.uddi.datastructure.AssertionStatusItems;
import weblogic.auddi.uddi.datastructure.AuthorizedName;
import weblogic.auddi.uddi.datastructure.BindingKey;
import weblogic.auddi.uddi.datastructure.BindingTemplate;
import weblogic.auddi.uddi.datastructure.BindingTemplates;
import weblogic.auddi.uddi.datastructure.BusinessEntity;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.BusinessService;
import weblogic.auddi.uddi.datastructure.BusinessServices;
import weblogic.auddi.uddi.datastructure.CategoryBag;
import weblogic.auddi.uddi.datastructure.Contact;
import weblogic.auddi.uddi.datastructure.Contacts;
import weblogic.auddi.uddi.datastructure.Description;
import weblogic.auddi.uddi.datastructure.Descriptions;
import weblogic.auddi.uddi.datastructure.DiscoveryURL;
import weblogic.auddi.uddi.datastructure.DiscoveryURLs;
import weblogic.auddi.uddi.datastructure.Email;
import weblogic.auddi.uddi.datastructure.Emails;
import weblogic.auddi.uddi.datastructure.HostingRedirector;
import weblogic.auddi.uddi.datastructure.IdentifierBag;
import weblogic.auddi.uddi.datastructure.InstanceDetails;
import weblogic.auddi.uddi.datastructure.InstanceParms;
import weblogic.auddi.uddi.datastructure.KeyedReference;
import weblogic.auddi.uddi.datastructure.Language;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.Operator;
import weblogic.auddi.uddi.datastructure.OverviewDoc;
import weblogic.auddi.uddi.datastructure.Phone;
import weblogic.auddi.uddi.datastructure.Phones;
import weblogic.auddi.uddi.datastructure.PublisherAssertion;
import weblogic.auddi.uddi.datastructure.SearchNames;
import weblogic.auddi.uddi.datastructure.ServiceKey;
import weblogic.auddi.uddi.datastructure.TModel;
import weblogic.auddi.uddi.datastructure.TModelBag;
import weblogic.auddi.uddi.datastructure.TModelInstanceDetails;
import weblogic.auddi.uddi.datastructure.TModelInstanceInfo;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.datastructure.UniqueNames;
import weblogic.auddi.uddi.request.inquiry.FindQualifier;
import weblogic.auddi.uddi.request.inquiry.FindQualifiers;
import weblogic.xml.jaxr.registry.BulkResponseImpl;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.bridge.uddi.UDDITaxonomies;
import weblogic.xml.jaxr.registry.infomodel.LocalizedStringImpl;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;
import weblogic.xml.jaxr.registry.util.ClassificationSchemeHelper;

public class UDDIBridgeMapperUtil {
    private static final String[] urlTypeArray = new String[]{"http", "https", "ftp", "phone", "mailto"};
    private static final String DEFAULT_URL_TYPE = "http";
    private static final String[][] ASSOCIATION_TYPE_MAPPING = new String[][]{{"equivalentTo", "identity"}, {"relatedTo", "peer-peer"}, {"hasChild", "parent-child"}};

    private UDDIBridgeMapperUtil() {
    }

    public static JAXRException mapException(UDDIException uDDIException) {
        uDDIException.printStackTrace();
        if (uDDIException instanceof UnsupportedException) {
            return new UnsupportedCapabilityException(uDDIException.getMessage());
        }
        return new RegistryException(uDDIException.getMessage());
    }

    public static void accumulateBulkResponses(BulkResponseImpl bulkResponseImpl, BulkResponse[] bulkResponseArray) throws JAXRException {
        if (bulkResponseImpl.getCollection().size() == 0) {
            bulkResponseImpl.setResponse(new ArrayList(), bulkResponseImpl.getExceptions(), bulkResponseImpl.isPartialResponse());
        }
        for (int i = 0; i < bulkResponseArray.length; ++i) {
            BulkResponse bulkResponse = bulkResponseArray[i];
            bulkResponseImpl.getCollection().addAll(bulkResponse.getCollection());
            Collection collection = bulkResponse.getExceptions();
            if (collection != null) {
                if (bulkResponseImpl.getExceptions() == null) {
                    bulkResponseImpl.setResponse(bulkResponseImpl.getCollection(), new ArrayList(), bulkResponseImpl.isPartialResponse());
                }
                bulkResponseImpl.getExceptions().addAll(collection);
            }
            if (i == 0) {
                bulkResponseImpl.setStatus(bulkResponse.getStatus());
                continue;
            }
            UDDIBridgeMapperUtil.updateStatus(bulkResponseImpl, bulkResponse);
        }
    }

    public static void accumulateBulkResponses(BulkResponseImpl bulkResponseImpl, BulkResponse bulkResponse) throws JAXRException {
        if (bulkResponse != null) {
            BulkResponse[] bulkResponseArray = new BulkResponse[]{bulkResponse};
            UDDIBridgeMapperUtil.accumulateBulkResponses(bulkResponseImpl, bulkResponseArray);
        }
    }

    public static AccessPoint getAccessPoint(String string, Collection collection) throws JAXRException {
        AccessPoint accessPoint;
        if (string == null) {
            accessPoint = null;
        } else {
            String string2 = DEFAULT_URL_TYPE;
            for (Classification classification : collection) {
                String string3;
                InternationalString internationalString;
                ClassificationScheme classificationScheme;
                Concept concept = classification.getConcept();
                if (concept == null || (classificationScheme = concept.getClassificationScheme()) == null || (internationalString = classificationScheme.getName()) == null || !(string3 = internationalString.getValue()).equalsIgnoreCase("URLType")) continue;
                if (UDDIBridgeMapperUtil.isPredefinedURLType(concept.getValue())) {
                    string2 = concept.getValue();
                    continue;
                }
                string2 = "other";
            }
            try {
                accessPoint = new AccessPoint(string2, string);
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return accessPoint;
    }

    private static boolean isPredefinedURLType(String string) {
        for (int i = 0; i < urlTypeArray.length; ++i) {
            if (string.toLowerCase(Locale.ENGLISH).indexOf(urlTypeArray[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isConcept(TModel tModel) {
        boolean bl = UDDITaxonomies.isClassificationScheme(tModel);
        return !bl;
    }

    public static Address getAddress(PostalAddress postalAddress, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        try {
            Address address;
            if (postalAddress == null) {
                address = null;
            } else {
                address = new Address();
                address.addAddressLine(UDDIBridgeMapperUtil.getAddressLine(postalAddress.getStreetNumber()));
                address.addAddressLine(UDDIBridgeMapperUtil.getAddressLine(postalAddress.getStreet()));
                address.addAddressLine(UDDIBridgeMapperUtil.getAddressLine(postalAddress.getCity()));
                address.addAddressLine(UDDIBridgeMapperUtil.getAddressLine(postalAddress.getStateOrProvince()));
                address.addAddressLine(UDDIBridgeMapperUtil.getAddressLine(postalAddress.getPostalCode()));
                address.addAddressLine(UDDIBridgeMapperUtil.getAddressLine(postalAddress.getCountry()));
                ClassificationScheme classificationScheme = postalAddress.getPostalScheme();
                if (classificationScheme == null) {
                    classificationScheme = registryServiceImpl.getDefaultPostalScheme();
                }
                if (classificationScheme != null) {
                    address.setTModelKey(new TModelKey(classificationScheme.getKey().getId()));
                }
                UDDIBridgeMapperUtil.setSemanticEquivalences(address, classificationScheme, registryServiceImpl);
                AddressLines addressLines = UDDIBridgeMapperUtil.getAddressLines(postalAddress.getSlot("addressLines"));
                if (addressLines != null) {
                    AddressLine addressLine = addressLines.getFirst();
                    while (addressLine != null) {
                        address.addAddressLine(addressLine);
                        addressLine = addressLines.getNext();
                    }
                }
                address.setUseType(postalAddress.getType());
                address.setSortCode(UDDIBridgeMapperUtil.getSortCode(postalAddress.getSlot("sortCode")));
            }
            return address;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    private static void setSemanticEquivalences(Address address, ClassificationScheme classificationScheme, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        ClassificationScheme classificationScheme2 = ClassificationSchemeHelper.getClassificationSchemeByName("PostalAddressAttributes", registryServiceImpl);
        Collection collection = classificationScheme2.getChildrenConcepts();
        AddressLine addressLine = address.getAddressLines().getFirst();
        for (Concept concept : collection) {
            String string = registryServiceImpl.getSemanticEquivalent(concept.getKey().getId());
            if (string != null) {
                InternationalString internationalString;
                boolean bl = true;
                if (classificationScheme != null) {
                    internationalString = classificationScheme.getChildrenConcepts().iterator();
                    while (internationalString.hasNext() && bl) {
                        Concept concept2 = (Concept)internationalString.next();
                        Key key = concept2.getKey();
                        if (key == null || !key.getId().equalsIgnoreCase(string)) continue;
                        InternationalString internationalString2 = concept2.getName();
                        if (internationalString2 != null) {
                            addressLine.setKeyName(internationalString2.getValue());
                        }
                        addressLine.setKeyValue(concept2.getValue());
                        bl = false;
                    }
                }
                if (bl) {
                    internationalString = concept.getName();
                    if (internationalString != null) {
                        addressLine.setKeyName(internationalString.getValue());
                    }
                    addressLine.setKeyValue(concept.getValue());
                }
            }
            addressLine = address.getAddressLines().getNext();
        }
    }

    public static Addresses getAddresses(Collection collection, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        Addresses addresses;
        if (collection == null || collection.size() == 0) {
            addresses = null;
        } else {
            addresses = new Addresses();
            try {
                for (PostalAddress postalAddress : collection) {
                    addresses.add(UDDIBridgeMapperUtil.getAddress(postalAddress, registryServiceImpl));
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return addresses;
    }

    public static AddressLine getAddressLine(String string) {
        AddressLine addressLine = string == null ? null : new AddressLine(string);
        return addressLine;
    }

    public static AddressLines getAddressLines(Slot slot) throws JAXRException {
        AddressLines addressLines;
        if (slot == null) {
            addressLines = null;
        } else {
            addressLines = new AddressLines();
            try {
                Collection collection = slot.getValues();
                for (String string : collection) {
                    addressLines.add(UDDIBridgeMapperUtil.getAddressLine(string));
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return addressLines;
    }

    public static AuthorizedName getAuthorizedName(Slot slot) throws JAXRException {
        AuthorizedName authorizedName = slot == null ? null : new AuthorizedName(UDDIBridgeMapperUtil.getSlotValue(slot));
        return authorizedName;
    }

    public static BindingKey getBindingKey(Key key) throws JAXRException {
        BindingKey bindingKey;
        if (key == null) {
            bindingKey = null;
        } else {
            try {
                bindingKey = new BindingKey(key.getId());
            }
            catch (InvalidKeyPassedException invalidKeyPassedException) {
                throw UDDIBridgeMapperUtil.mapException(invalidKeyPassedException);
            }
        }
        return bindingKey;
    }

    public static BindingTemplate getBindingTemplate(ServiceBinding serviceBinding) throws JAXRException {
        BindingTemplate bindingTemplate;
        if (serviceBinding == null) {
            bindingTemplate = null;
        } else {
            bindingTemplate = new BindingTemplate();
            try {
                bindingTemplate.setBindingKey(UDDIBridgeMapperUtil.getBindingKey(serviceBinding.getKey()));
                if (serviceBinding.getService() != null) {
                    bindingTemplate.setServiceKey(UDDIBridgeMapperUtil.getServiceKey(serviceBinding.getService().getKey()));
                }
                bindingTemplate.setDescriptions(UDDIBridgeMapperUtil.getDescriptions(serviceBinding.getDescription()));
                if (serviceBinding.getAccessURI() != null) {
                    bindingTemplate.setAccessPoint(UDDIBridgeMapperUtil.getAccessPoint(serviceBinding.getAccessURI(), serviceBinding.getClassifications()));
                } else {
                    bindingTemplate.setHostingRedirector(UDDIBridgeMapperUtil.getHostingRedirector(serviceBinding.getTargetBinding()));
                }
                bindingTemplate.setTModelInstanceDetails(UDDIBridgeMapperUtil.getTModelInstanceDetails(serviceBinding.getSpecificationLinks()));
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return bindingTemplate;
    }

    public static BindingTemplates getBindingTemplates(Collection collection) throws JAXRException {
        BindingTemplates bindingTemplates;
        if (collection == null || collection.size() == 0) {
            bindingTemplates = null;
        } else {
            bindingTemplates = new BindingTemplates();
            for (ServiceBinding serviceBinding : collection) {
                bindingTemplates.add(UDDIBridgeMapperUtil.getBindingTemplate(serviceBinding));
            }
        }
        return bindingTemplates;
    }

    public static BusinessEntity getBusinessEntity(Organization organization, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        BusinessEntity businessEntity;
        if (organization == null) {
            businessEntity = null;
        } else {
            businessEntity = new BusinessEntity();
            businessEntity.setBusinessKey(UDDIBridgeMapperUtil.getBusinessKey(organization.getKey()));
            businessEntity.setOperator(UDDIBridgeMapperUtil.getOperatorAsString(organization.getSlot("operator")));
            businessEntity.setDiscoveryURLs(UDDIBridgeMapperUtil.getDiscoveryURLs(organization.getExternalLinks()));
            businessEntity.setNames(UDDIBridgeMapperUtil.getNames(organization.getName()));
            businessEntity.setDescriptions(UDDIBridgeMapperUtil.getDescriptions(organization.getDescription()));
            businessEntity.setContacts(UDDIBridgeMapperUtil.getContacts(organization.getUsers(), registryServiceImpl));
            businessEntity.setBusinessServices(UDDIBridgeMapperUtil.getBusinessServices(organization.getServices()));
            businessEntity.setIdentifierBag(UDDIBridgeMapperUtil.getIdentifierBag(organization.getExternalIdentifiers()));
            businessEntity.setCategoryBag(UDDIBridgeMapperUtil.getCategoryBagFromClassifications(organization.getClassifications()));
        }
        return businessEntity;
    }

    public static BusinessKey getBusinessKey(Key key) throws JAXRException {
        BusinessKey businessKey = null;
        if (key == null) {
            businessKey = null;
        } else {
            try {
                businessKey = new BusinessKey(key.getId());
            }
            catch (InvalidKeyPassedException invalidKeyPassedException) {
                throw UDDIBridgeMapperUtil.mapException(invalidKeyPassedException);
            }
        }
        return businessKey;
    }

    public static BusinessService getBusinessService(Service service2) throws JAXRException {
        BusinessService businessService;
        if (service2 == null) {
            businessService = null;
        } else {
            businessService = new BusinessService();
            businessService.setBusinessKey(UDDIBridgeMapperUtil.getBusinessKey(service2.getProvidingOrganization().getKey()));
            businessService.setServiceKey(UDDIBridgeMapperUtil.getServiceKey(service2.getKey()));
            businessService.setNames(UDDIBridgeMapperUtil.getNames(service2.getName()));
            businessService.setDescriptions(UDDIBridgeMapperUtil.getDescriptions(service2.getDescription()));
            businessService.setBindingTemplates(UDDIBridgeMapperUtil.getBindingTemplates(service2.getServiceBindings()));
            businessService.setCategoryBag(UDDIBridgeMapperUtil.getCategoryBagFromClassifications(service2.getClassifications()));
        }
        return businessService;
    }

    public static BusinessServices getBusinessServices(Collection collection) throws JAXRException {
        BusinessServices businessServices;
        if (collection == null || collection.size() == 0) {
            businessServices = null;
        } else {
            businessServices = new BusinessServices();
            try {
                for (Service service2 : collection) {
                    businessServices.add(UDDIBridgeMapperUtil.getBusinessService(service2));
                }
            }
            catch (UDDIException uDDIException) {
                UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return businessServices;
    }

    public static CategoryBag getCategoryBagFromClassifications(Collection collection) throws JAXRException {
        CategoryBag categoryBag;
        if (collection == null || collection.size() == 0) {
            categoryBag = null;
        } else {
            categoryBag = new CategoryBag();
            try {
                for (Classification classification : collection) {
                    Concept concept = classification.getConcept();
                    if (concept != null) {
                        categoryBag.add(UDDIBridgeMapperUtil.getKeyedReference(concept));
                        continue;
                    }
                    categoryBag.add(UDDIBridgeMapperUtil.getKeyedReference(classification));
                }
            }
            catch (UDDIException uDDIException) {
                UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return categoryBag;
    }

    public static Contact getContact(User user, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        Contact contact;
        if (user == null) {
            contact = null;
        } else {
            contact = new Contact();
            contact.setUseType(user.getType());
            contact.setDescriptions(UDDIBridgeMapperUtil.getDescriptions(user.getDescription()));
            contact.setPersonName(user.getPersonName().getFullName());
            contact.setPhones(UDDIBridgeMapperUtil.getPhones(user.getTelephoneNumbers(null)));
            contact.setEmails(UDDIBridgeMapperUtil.getEmails(user.getEmailAddresses()));
            contact.setAddresses(UDDIBridgeMapperUtil.getAddresses(user.getPostalAddresses(), registryServiceImpl));
        }
        return contact;
    }

    public static Phones getPhones(Collection collection) throws JAXRException {
        Phones phones;
        if (collection == null || collection.size() == 0) {
            phones = null;
        } else {
            phones = new Phones();
            try {
                for (TelephoneNumber telephoneNumber : collection) {
                    phones.add(UDDIBridgeMapperUtil.getPhone(telephoneNumber));
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return phones;
    }

    public static Phone getPhone(TelephoneNumber telephoneNumber) throws JAXRException {
        Phone phone = telephoneNumber == null ? null : new Phone(telephoneNumber.getNumber(), telephoneNumber.getType());
        return phone;
    }

    public static Emails getEmails(Collection collection) throws JAXRException {
        Emails emails;
        if (collection == null || collection.size() == 0) {
            emails = null;
        } else {
            emails = new Emails();
            try {
                for (EmailAddress emailAddress : collection) {
                    emails.add(UDDIBridgeMapperUtil.getEmail(emailAddress));
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return emails;
    }

    public static Email getEmail(EmailAddress emailAddress) throws JAXRException {
        Email email = emailAddress == null ? null : new Email(emailAddress.getAddress(), emailAddress.getType());
        return email;
    }

    public static String getSortCode(Slot slot) throws JAXRException {
        String string2;
        if (slot == null) {
            string2 = null;
        } else {
            string2 = "";
            Collection collection = slot.getValues();
            for (String string2 : collection) {
            }
        }
        return string2;
    }

    public static ServiceKey getServiceKey(Key key) throws JAXRException {
        ServiceKey serviceKey;
        if (key == null) {
            serviceKey = null;
        } else {
            try {
                serviceKey = new ServiceKey(key.getId());
            }
            catch (InvalidKeyPassedException invalidKeyPassedException) {
                throw UDDIBridgeMapperUtil.mapException(invalidKeyPassedException);
            }
        }
        return serviceKey;
    }

    public static Contacts getContacts(Collection collection, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        Contacts contacts;
        if (collection == null || collection.size() == 0) {
            contacts = null;
        } else {
            contacts = new Contacts();
            try {
                for (User user : collection) {
                    contacts.add(UDDIBridgeMapperUtil.getContact(user, registryServiceImpl));
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return contacts;
    }

    public static TModel getTModelFromConcept(Concept concept) throws JAXRException {
        TModel tModel;
        if (concept == null) {
            tModel = null;
        } else {
            tModel = new TModel();
            tModel.setAuthorizedName(UDDIBridgeMapperUtil.getAuthorizedName(concept.getSlot("authorizedName")));
            CategoryBag categoryBag = UDDIBridgeMapperUtil.getCategoryBagFromClassifications(concept.getClassifications());
            categoryBag = UDDIBridgeMapperUtil.addCategorization(categoryBag, "Concept");
            tModel.setCategoryBag(categoryBag);
            tModel.setDescriptions(UDDIBridgeMapperUtil.getDescriptions(concept.getDescription()));
            tModel.setIdentifierBag(UDDIBridgeMapperUtil.getIdentifierBag(concept.getExternalIdentifiers()));
            tModel.setName(UDDIBridgeMapperUtil.getName(concept.getName()));
            tModel.setOperator(UDDIBridgeMapperUtil.getOperator(concept.getSlot("operator")));
            tModel.setOverviewDoc(UDDIBridgeMapperUtil.getOverviewDoc(concept.getExternalLinks()));
            tModel.setTModelKey(UDDIBridgeMapperUtil.getTModelKey(concept.getKey()));
        }
        return tModel;
    }

    public static TModel getTModelFromClassificationScheme(ClassificationScheme classificationScheme) throws JAXRException {
        TModel tModel;
        if (classificationScheme == null) {
            tModel = null;
        } else {
            tModel = new TModel();
            tModel.setAuthorizedName(UDDIBridgeMapperUtil.getAuthorizedName(classificationScheme.getSlot("authorizedName")));
            CategoryBag categoryBag = UDDIBridgeMapperUtil.getCategoryBagFromClassifications(classificationScheme.getClassifications());
            categoryBag = UDDIBridgeMapperUtil.addCategorization(categoryBag, "ClassificationScheme");
            tModel.setCategoryBag(categoryBag);
            tModel.setDescriptions(UDDIBridgeMapperUtil.getDescriptions(classificationScheme.getDescription()));
            tModel.setIdentifierBag(UDDIBridgeMapperUtil.getIdentifierBag(classificationScheme.getExternalIdentifiers()));
            tModel.setName(UDDIBridgeMapperUtil.getName(classificationScheme.getName()));
            tModel.setOperator(UDDIBridgeMapperUtil.getOperator(classificationScheme.getSlot("operator")));
            tModel.setOverviewDoc(UDDIBridgeMapperUtil.getOverviewDoc(classificationScheme.getExternalLinks()));
            tModel.setTModelKey(UDDIBridgeMapperUtil.getTModelKey(classificationScheme.getKey()));
        }
        return tModel;
    }

    public static Descriptions getDescriptions(InternationalString internationalString) throws JAXRException {
        Descriptions descriptions;
        if (internationalString == null) {
            descriptions = null;
        } else {
            descriptions = new Descriptions();
            try {
                for (LocalizedString localizedString : internationalString.getLocalizedStrings()) {
                    Locale locale = localizedString.getLocale();
                    Description description = new Description(localizedString.getValue(), new Language(locale.getLanguage()));
                    descriptions.add(description);
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return descriptions;
    }

    public static DiscoveryURL getDiscoveryURL(ExternalLink externalLink) throws JAXRException {
        DiscoveryURL discoveryURL;
        if (externalLink == null) {
            discoveryURL = null;
        } else {
            try {
                String string = externalLink.getName().getValue();
                discoveryURL = new DiscoveryURL(string == null ? "businessEntity" : string, externalLink.getExternalURI());
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return discoveryURL;
    }

    public static UniqueNames getNames(InternationalString internationalString) throws JAXRException {
        UniqueNames uniqueNames;
        if (internationalString == null) {
            uniqueNames = null;
        } else {
            uniqueNames = new UniqueNames();
            try {
                for (LocalizedString localizedString : internationalString.getLocalizedStrings()) {
                    Locale locale = localizedString.getLocale();
                    Name name = new Name(localizedString.getValue(), new Language(locale.getLanguage()));
                    uniqueNames.add(name);
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return uniqueNames;
    }

    public static SearchNames getSearchNames(Collection collection) throws JAXRException {
        SearchNames searchNames;
        if (collection == null) {
            searchNames = null;
        } else {
            searchNames = new SearchNames();
            try {
                for (Object e : collection) {
                    String string;
                    Name name = null;
                    if (e instanceof String) {
                        string = (String)e;
                        name = new Name(string);
                    } else {
                        string = (LocalizedString)e;
                        Locale locale = string.getLocale();
                        name = new Name(string.getValue(), new Language(locale.getLanguage()));
                    }
                    searchNames.add(name);
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return searchNames;
    }

    public static Name getName(InternationalString internationalString) throws JAXRException {
        Name name;
        if (internationalString == null) {
            name = null;
        } else {
            try {
                name = new Name(internationalString.getValue());
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return name;
    }

    public static DiscoveryURLs getDiscoveryURLs(Collection collection) throws JAXRException {
        DiscoveryURLs discoveryURLs;
        if (collection == null || collection.size() == 0) {
            discoveryURLs = null;
        } else {
            try {
                discoveryURLs = new DiscoveryURLs();
                for (ExternalLink externalLink : collection) {
                    discoveryURLs.add(UDDIBridgeMapperUtil.getDiscoveryURL(externalLink));
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return discoveryURLs;
    }

    public static HostingRedirector getHostingRedirector(ServiceBinding serviceBinding) throws JAXRException {
        HostingRedirector hostingRedirector = serviceBinding == null ? null : new HostingRedirector(UDDIBridgeMapperUtil.getBindingKey(serviceBinding.getKey()));
        return hostingRedirector;
    }

    public static TModelInstanceDetails getTModelInstanceDetails(Collection collection) throws JAXRException {
        TModelInstanceDetails tModelInstanceDetails;
        if (collection == null || collection.size() == 0) {
            tModelInstanceDetails = null;
        } else {
            tModelInstanceDetails = new TModelInstanceDetails();
            for (SpecificationLink specificationLink : collection) {
                tModelInstanceDetails.add(UDDIBridgeMapperUtil.getTModelInstanceInfo(specificationLink));
            }
        }
        return tModelInstanceDetails;
    }

    public static TModelInstanceInfo getTModelInstanceInfo(SpecificationLink specificationLink) throws JAXRException {
        TModelInstanceInfo tModelInstanceInfo;
        if (specificationLink == null) {
            tModelInstanceInfo = null;
        } else {
            tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.setTModelKey(UDDIBridgeMapperUtil.getTModelKey(specificationLink.getSpecificationObject()));
            tModelInstanceInfo.setDescriptions(UDDIBridgeMapperUtil.getDescriptions(specificationLink.getUsageDescription()));
            tModelInstanceInfo.setInstanceDetails(UDDIBridgeMapperUtil.getInstanceDetails(specificationLink));
        }
        return tModelInstanceInfo;
    }

    public static TModelKey getTModelKey(RegistryObject registryObject) throws JAXRException {
        TModelKey tModelKey;
        if (registryObject == null) {
            tModelKey = null;
        } else {
            try {
                tModelKey = new TModelKey(registryObject.getKey().getId());
            }
            catch (InvalidKeyPassedException invalidKeyPassedException) {
                throw UDDIBridgeMapperUtil.mapException(invalidKeyPassedException);
            }
            catch (FatalErrorException fatalErrorException) {
                throw UDDIBridgeMapperUtil.mapException(fatalErrorException);
            }
        }
        return tModelKey;
    }

    public static TModelKey getTModelKey(Key key) throws JAXRException {
        TModelKey tModelKey;
        if (key == null) {
            tModelKey = null;
        } else {
            try {
                tModelKey = new TModelKey(key.getId());
            }
            catch (InvalidKeyPassedException invalidKeyPassedException) {
                throw UDDIBridgeMapperUtil.mapException(invalidKeyPassedException);
            }
            catch (FatalErrorException fatalErrorException) {
                throw UDDIBridgeMapperUtil.mapException(fatalErrorException);
            }
        }
        return tModelKey;
    }

    public static InstanceDetails getInstanceDetails(SpecificationLink specificationLink) throws JAXRException {
        InstanceDetails instanceDetails;
        if (specificationLink == null) {
            instanceDetails = null;
        } else {
            instanceDetails = new InstanceDetails();
            instanceDetails.setInstanceParms(UDDIBridgeMapperUtil.getInstanceParms(specificationLink.getUsageParameters()));
            instanceDetails.setOverviewDoc(UDDIBridgeMapperUtil.getOverviewDoc(specificationLink.getExternalLinks()));
        }
        return instanceDetails;
    }

    public static InstanceParms getInstanceParms(Collection collection) throws JAXRException {
        InstanceParms instanceParms;
        if (collection == null || collection.size() == 0) {
            instanceParms = null;
        } else {
            try {
                instanceParms = null;
                Iterator iterator = collection.iterator();
                instanceParms = new InstanceParms((String)iterator.next());
                if (iterator.hasNext()) {
                    String string = JAXRMessages.getMessage("jaxr.uddi.uddiBridgeMapperUtil.invalidUsageParametersNember");
                    throw new InvalidRequestException(string);
                }
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return instanceParms;
    }

    public static IdentifierBag getIdentifierBag(Collection collection) throws JAXRException {
        IdentifierBag identifierBag;
        if (collection == null || collection.size() == 0) {
            identifierBag = null;
        } else {
            identifierBag = new IdentifierBag();
            try {
                for (ExternalIdentifier externalIdentifier : collection) {
                    identifierBag.add(UDDIBridgeMapperUtil.getKeyedReference(externalIdentifier));
                }
            }
            catch (UDDIException uDDIException) {
                UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return identifierBag;
    }

    private static String getOperatorAsString(Slot slot) throws JAXRException {
        Operator operator2;
        String string = slot == null ? null : ((operator2 = UDDIBridgeMapperUtil.getOperator(slot)) == null ? null : operator2.getName());
        return string;
    }

    private static String getSlotValue(Slot slot) throws JAXRException {
        String string2;
        if (slot == null) {
            string2 = null;
        } else {
            string2 = "";
            for (String string2 : slot.getValues()) {
            }
        }
        return string2;
    }

    public static Operator getOperator(Slot slot) throws JAXRException {
        Operator operator2 = slot == null ? null : new Operator(UDDIBridgeMapperUtil.getSlotValue(slot));
        return operator2;
    }

    public static OverviewDoc getOverviewDoc(Collection collection) throws JAXRException {
        OverviewDoc overviewDoc;
        if (collection == null || collection.size() == 0) {
            overviewDoc = null;
        } else {
            overviewDoc = new OverviewDoc();
            try {
                for (ExternalLink externalLink : collection) {
                    overviewDoc.setDescriptions(UDDIBridgeMapperUtil.getDescriptions(externalLink.getDescription()));
                    overviewDoc.setOverviewURL(externalLink.getExternalURI());
                }
            }
            catch (UDDIException uDDIException) {
                UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return overviewDoc;
    }

    public static KeyedReference getKeyedReference(Concept concept) throws JAXRException {
        KeyedReference keyedReference;
        if (concept == null) {
            throw new JAXRException();
        }
        try {
            String string;
            ClassificationScheme classificationScheme = concept.getClassificationScheme();
            if (classificationScheme == null) {
                throw new JAXRException();
            }
            Key key = classificationScheme.getKey();
            if (key == null) {
                throw new JAXRException();
            }
            TModelKey tModelKey = new TModelKey(key.getId());
            String string2 = null;
            if (concept.getName() != null) {
                string2 = concept.getName().getValue();
            }
            if ((string = concept.getValue()) == null) {
                return null;
            }
            keyedReference = new KeyedReference(tModelKey, string2, string);
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
        return keyedReference;
    }

    public static KeyedReference getKeyedReference(Classification classification) throws JAXRException {
        KeyedReference keyedReference;
        if (classification == null) {
            throw new JAXRException();
        }
        try {
            String string;
            ClassificationScheme classificationScheme = classification.getClassificationScheme();
            if (classificationScheme == null) {
                throw new JAXRException();
            }
            Key key = classificationScheme.getKey();
            if (key == null) {
                throw new JAXRException();
            }
            TModelKey tModelKey = new TModelKey(key.getId());
            String string2 = null;
            if (classification.getName() != null) {
                string2 = classification.getName().getValue();
            }
            if ((string = classification.getValue()) == null) {
                return null;
            }
            keyedReference = new KeyedReference(tModelKey, string2, string);
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
        return keyedReference;
    }

    public static KeyedReference getKeyedReference(ExternalIdentifier externalIdentifier) throws JAXRException {
        KeyedReference keyedReference;
        if (externalIdentifier == null) {
            return null;
        }
        try {
            String string;
            ClassificationScheme classificationScheme = externalIdentifier.getIdentificationScheme();
            if (classificationScheme == null) {
                throw new JAXRException();
            }
            Key key = classificationScheme.getKey();
            if (key == null) {
                throw new JAXRException();
            }
            TModelKey tModelKey = new TModelKey(key.getId());
            String string2 = null;
            if (externalIdentifier.getName() != null) {
                string2 = externalIdentifier.getName().getValue();
            }
            if ((string = externalIdentifier.getValue()) == null) {
                return null;
            }
            keyedReference = new KeyedReference(tModelKey, string2, string);
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
        return keyedReference;
    }

    public static FindQualifiers getFindQualifiers(Collection collection) throws JAXRException {
        FindQualifiers findQualifiers = new FindQualifiers();
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                FindQualifier findQualifier = new FindQualifier((String)iterator.next());
                findQualifiers.add(findQualifier);
            }
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
        return findQualifiers;
    }

    public static TModelBag getTModelBagFromSpecifications(Collection collection) throws JAXRException {
        TModelBag tModelBag = new TModelBag();
        for (RegistryObject registryObject : collection) {
            tModelBag.add(UDDIBridgeMapperUtil.getTModelKey(registryObject.getKey()));
        }
        return tModelBag;
    }

    public static Collection getKeyedReferencesFromAssociationTypes(Collection collection, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        ArrayList<KeyedReference> arrayList = new ArrayList<KeyedReference>();
        if (collection != null) {
            for (Object e : collection) {
                KeyedReference keyedReference = e instanceof String ? UDDIBridgeMapperUtil.getKeyedReferenceFromAssociationType((String)e, registryServiceImpl) : UDDIBridgeMapperUtil.getKeyedReferenceFromAssociationType((Concept)e);
                if (keyedReference == null) continue;
                arrayList.add(keyedReference);
            }
        }
        return arrayList;
    }

    public static KeyedReference getKeyedReferenceFromAssociationType(String string, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        Concept concept = registryServiceImpl.getBusinessLifeCycleManager().createConcept(null, string, string);
        KeyedReference keyedReference = UDDIBridgeMapperUtil.getKeyedReferenceFromAssociationType(concept);
        return keyedReference;
    }

    public static KeyedReference getKeyedReferenceFromAssociationType(Concept concept) throws JAXRException {
        try {
            TModelKey tModelKey = new TModelKey("UUID:807A2C6A-EE22-470D-ADC7-E0424A337C03");
            String string = UDDIBridgeMapperUtil.mapAssertionTypeString(false, concept.getValue());
            String string2 = UDDIBridgeMapperUtil.mapAssertionTypeString(false, concept.getName().getValue());
            KeyedReference keyedReference = new KeyedReference(tModelKey, string2, string);
            return keyedReference;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public static PublisherAssertion getPublisherAssertionFromAssociationKey(Key key, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        String string;
        PublisherAssertion publisherAssertion = new PublisherAssertion();
        if (key != null && (string = key.getId()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":", false);
            if (stringTokenizer.countTokens() == 3) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                try {
                    publisherAssertion.setFromKey(new BusinessKey(string2));
                    publisherAssertion.setToKey(new BusinessKey(string3));
                }
                catch (InvalidKeyPassedException invalidKeyPassedException) {
                    throw new JAXRException((Throwable)invalidKeyPassedException);
                }
                KeyedReference keyedReference = UDDIBridgeMapperUtil.getKeyedReferenceFromAssociationType(string4, registryServiceImpl);
                if (keyedReference != null) {
                    publisherAssertion.setKeyedReference(keyedReference);
                }
            } else {
                String string5 = JAXRMessages.getMessage("jaxr.uddi.uddiBridgeMapperUtil.invalidFormatForAssociationKey");
                throw new JAXRException(string5);
            }
        }
        return publisherAssertion;
    }

    public static Collection getPublisherAssertionsFromAssociations(Collection collection) throws JAXRException {
        ArrayList<PublisherAssertion> arrayList = new ArrayList<PublisherAssertion>();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            try {
                while (iterator.hasNext()) {
                    Association association = (Association)iterator.next();
                    PublisherAssertion publisherAssertion = UDDIBridgeMapperUtil.getPublisherAssertionFromAssociation(association);
                    if (publisherAssertion == null) continue;
                    arrayList.add(publisherAssertion);
                }
            }
            catch (ClassCastException classCastException) {
                throw new JAXRException((Throwable)classCastException);
            }
        }
        return arrayList;
    }

    public static PublisherAssertion getPublisherAssertionFromAssociation(Association association) throws JAXRException {
        PublisherAssertion publisherAssertion;
        block11: {
            Concept concept = association.getAssociationType();
            Organization organization = null;
            Organization organization2 = null;
            try {
                Object object;
                String string;
                organization = (Organization)association.getSourceObject();
                organization2 = (Organization)association.getTargetObject();
                publisherAssertion = new PublisherAssertion();
                Key key = organization.getKey();
                if (key != null) {
                    string = key.getId();
                    if (string == null) {
                        String string2 = JAXRMessages.getMessage("jaxr.uddi.uddiBridgeMapperUtil.invalidId", new Object[]{"sourceKeyId"});
                        throw new JAXRException(string2);
                    }
                } else {
                    String string3 = JAXRMessages.getMessage("jaxr.uddi.uddiBridgeMapperUtil.invalidKey", new Object[]{"sourceKey"});
                    throw new JAXRException(string3);
                }
                publisherAssertion.setFromKey(new BusinessKey(string));
                string = organization2.getKey();
                if (string != null) {
                    object = string.getId();
                    if (object == null) {
                        String string4 = JAXRMessages.getMessage("jaxr.uddi.uddiBridgeMapperUtil.invalidId", new Object[]{"targetKeyId"});
                        throw new JAXRException(string4);
                    }
                } else {
                    String string5 = JAXRMessages.getMessage("jaxr.uddi.uddiBridgeMapperUtil.invalidKey", new Object[]{"targetKey"});
                    throw new JAXRException(string5);
                }
                publisherAssertion.setToKey(new BusinessKey((String)object));
                if (concept != null) {
                    object = UDDIBridgeMapperUtil.getKeyedReferenceFromAssociationType(concept);
                    if (object != null) {
                        publisherAssertion.setKeyedReference((KeyedReference)object);
                    }
                    break block11;
                }
                object = JAXRMessages.getMessage("jaxr.uddi.uddiBridgeMapperUtil.missingAssociationType");
                throw new JAXRException((String)object);
            }
            catch (ClassCastException classCastException) {
                throw new JAXRException((Throwable)classCastException);
            }
            catch (InvalidKeyPassedException invalidKeyPassedException) {
                throw new JAXRException((Throwable)invalidKeyPassedException);
            }
        }
        return publisherAssertion;
    }

    public static Concept getConceptByValue(Collection collection, String string) throws JAXRException {
        Concept concept = null;
        for (Concept concept2 : collection) {
            String string2 = concept2.getValue();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            concept = concept2;
        }
        return concept;
    }

    public static Collection getLocalizedStringsFromDescriptions(Descriptions descriptions, RegistryService registryService) throws JAXRException {
        ArrayList<LocalizedStringImpl> arrayList = new ArrayList<LocalizedStringImpl>();
        Description description = descriptions.getFirst();
        while (description != null) {
            LocalizedStringImpl localizedStringImpl = new LocalizedStringImpl((RegistryServiceImpl)registryService);
            String string = description.getText();
            String string2 = description.getLang().getLang();
            if (string != null) {
                localizedStringImpl.setValue(string);
            }
            if (string2 != null) {
                Locale locale = Locale.getDefault();
                String string3 = locale.getLanguage();
                if (string2.equalsIgnoreCase(string3)) {
                    localizedStringImpl.setLocale(locale);
                } else {
                    Locale locale2 = new Locale(string2, "");
                    localizedStringImpl.setLocale(locale2);
                }
            } else {
                localizedStringImpl.setLocale(Locale.getDefault());
            }
            arrayList.add(localizedStringImpl);
            description = descriptions.getNext();
        }
        return arrayList;
    }

    public static InternationalString getInternationalStringFromDescriptions(Descriptions descriptions, RegistryService registryService) throws JAXRException {
        InternationalString internationalString;
        if (descriptions == null) {
            internationalString = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            internationalString = businessLifeCycleManager.createInternationalString();
            internationalString.addLocalizedStrings(UDDIBridgeMapperUtil.getLocalizedStringsFromDescriptions(descriptions, registryService));
        }
        return internationalString;
    }

    public static AssertionStatusItems selectAssertionStatusItems(AssertionStatusItems assertionStatusItems, Boolean bl, Boolean bl2, Collection collection) throws JAXRException, UDDIException {
        AssertionStatusItems assertionStatusItems2 = new AssertionStatusItems();
        AssertionStatusItem assertionStatusItem = assertionStatusItems.getFirst();
        while (assertionStatusItem != null) {
            boolean bl3;
            boolean bl4 = true;
            if (bl != null) {
                bl3 = assertionStatusItem.getFromKeyOwnership() ? assertionStatusItem.isFromKeyAsserted() : assertionStatusItem.isToKeyAsserted();
                if (bl != bl3) {
                    bl4 = false;
                }
            }
            if (bl4 && bl2 != null) {
                bl3 = assertionStatusItem.getToKeyOwnership() ? assertionStatusItem.isFromKeyAsserted() : assertionStatusItem.isToKeyAsserted();
                if (bl2 != bl3) {
                    bl4 = false;
                }
            }
            if (bl4 && collection != null && collection.size() > 0) {
                bl4 = false;
                String string = assertionStatusItem.getKeyedReference().getValue();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && !bl4) {
                    Concept concept = (Concept)iterator.next();
                    if (!string.equals(concept.getValue())) continue;
                    bl4 = true;
                }
            }
            if (bl4) {
                assertionStatusItems2.add(assertionStatusItem);
            }
            assertionStatusItem = assertionStatusItems.getNext();
        }
        return assertionStatusItems2;
    }

    public static Concept getAssociationTypeFromAssertion(KeyedReference keyedReference, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        BusinessLifeCycleManager businessLifeCycleManager = registryServiceImpl.getBusinessLifeCycleManager();
        String string = UDDIBridgeMapperUtil.mapAssertionTypeString(true, keyedReference.getValue());
        String string2 = UDDIBridgeMapperUtil.mapAssertionTypeString(true, keyedReference.getName());
        Concept concept = businessLifeCycleManager.createConcept(null, string2, string);
        if (keyedReference.getTModelKey() != null) {
            Key key = businessLifeCycleManager.createKey(keyedReference.getTModelKey().getKey());
            concept.setKey(key);
        }
        return concept;
    }

    private static String mapAssertionTypeString(boolean bl, String string) {
        int n;
        int n2;
        String string2 = string;
        if (bl) {
            n2 = 1;
            n = 0;
        } else {
            n2 = 0;
            n = 1;
        }
        for (int i = 0; i < ASSOCIATION_TYPE_MAPPING.length; ++i) {
            String[] stringArray = ASSOCIATION_TYPE_MAPPING[i];
            if (!stringArray[n2].equals(string)) continue;
            string2 = stringArray[n];
        }
        return string2;
    }

    private static CategoryBag addCategorization(CategoryBag categoryBag, String string) throws JAXRException {
        KeyedReference keyedReference;
        boolean bl = false;
        if (categoryBag == null) {
            categoryBag = new CategoryBag();
        } else {
            keyedReference = categoryBag.getFirst();
            while (keyedReference != null) {
                if (keyedReference.getTModelKey().equals("uuid:c1acf26d-9672-4404-9d70-39b756e62ab4")) {
                    bl = true;
                    break;
                }
                keyedReference = categoryBag.getNext();
            }
        }
        if (!bl) {
            try {
                String string2 = "uddi-org:types";
                TModelKey tModelKey = new TModelKey("uuid:c1acf26d-9672-4404-9d70-39b756e62ab4");
                String string3 = string.equals("ClassificationScheme") ? "categorization" : "specification";
                keyedReference = new KeyedReference(tModelKey, string2, string3);
                categoryBag.add(keyedReference);
            }
            catch (UDDIException uDDIException) {
                throw UDDIBridgeMapperUtil.mapException(uDDIException);
            }
        }
        return categoryBag;
    }

    private static void updateStatus(BulkResponseImpl bulkResponseImpl, BulkResponse bulkResponse) throws JAXRException {
        int n = bulkResponseImpl.getStatus();
        int n2 = bulkResponse.getStatus();
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    bulkResponseImpl.setStatus(0);
                    break;
                }
                if (n2 == 2) {
                    bulkResponseImpl.setStatus(1);
                    break;
                }
                if (n2 == 1) {
                    bulkResponseImpl.setStatus(1);
                    break;
                }
                if (n2 != 3) break;
                bulkResponseImpl.setStatus(3);
                break;
            }
            case 2: {
                if (n2 == 0) {
                    bulkResponseImpl.setStatus(1);
                    break;
                }
                if (n2 == 2) {
                    bulkResponseImpl.setStatus(2);
                    break;
                }
                if (n2 == 1) {
                    bulkResponseImpl.setStatus(1);
                    break;
                }
                if (n2 != 3) break;
                bulkResponseImpl.setStatus(3);
                break;
            }
            case 1: {
                if (n2 == 0) {
                    bulkResponseImpl.setStatus(1);
                    break;
                }
                if (n2 == 2) {
                    bulkResponseImpl.setStatus(1);
                    break;
                }
                if (n2 == 1) {
                    bulkResponseImpl.setStatus(1);
                    break;
                }
                if (n2 != 3) break;
                bulkResponseImpl.setStatus(3);
                break;
            }
            case 3: {
                bulkResponseImpl.setStatus(3);
                break;
            }
            default: {
                String string = JAXRMessages.getMessage("jaxr.registry.bridge.uddi.UDDIBridgeMapperUtil.unknownStatus", new Object[]{new Integer(n).toString()});
                throw new JAXRException(string);
            }
        }
    }
}

