/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.bridge.uddi;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.Slot;
import weblogic.auddi.soap.SOAPWrapper;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.client.UDDIProxy;
import weblogic.auddi.uddi.datastructure.AssertionStatusItem;
import weblogic.auddi.uddi.datastructure.AssertionStatusItems;
import weblogic.auddi.uddi.datastructure.BindingKey;
import weblogic.auddi.uddi.datastructure.BindingTemplate;
import weblogic.auddi.uddi.datastructure.BindingTemplates;
import weblogic.auddi.uddi.datastructure.BusinessEntities;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.KeyedReference;
import weblogic.auddi.uddi.datastructure.ServiceKey;
import weblogic.auddi.uddi.datastructure.TModel;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.datastructure.TModels;
import weblogic.auddi.uddi.request.UDDIRequest;
import weblogic.auddi.uddi.request.inquiry.FindBindingRequest;
import weblogic.auddi.uddi.request.inquiry.FindBusinessRequest;
import weblogic.auddi.uddi.request.inquiry.FindRelatedBusinessesRequest;
import weblogic.auddi.uddi.request.inquiry.FindServiceRequest;
import weblogic.auddi.uddi.request.inquiry.FindTModelRequest;
import weblogic.auddi.uddi.request.inquiry.GetBindingDetailRequest;
import weblogic.auddi.uddi.request.inquiry.GetBusinessDetailRequest;
import weblogic.auddi.uddi.request.inquiry.GetServiceDetailRequest;
import weblogic.auddi.uddi.request.inquiry.GetTModelDetailRequest;
import weblogic.auddi.uddi.request.publish.DeleteBindingRequest;
import weblogic.auddi.uddi.request.publish.DeleteBusinessRequest;
import weblogic.auddi.uddi.request.publish.DeletePublisherAssertionsRequest;
import weblogic.auddi.uddi.request.publish.DeleteServiceRequest;
import weblogic.auddi.uddi.request.publish.DeleteTModelRequest;
import weblogic.auddi.uddi.request.publish.GetAssertionStatusReportRequest;
import weblogic.auddi.uddi.request.publish.GetRegisteredInfoRequest;
import weblogic.auddi.uddi.request.publish.SaveBindingRequest;
import weblogic.auddi.uddi.request.publish.SaveBusinessRequest;
import weblogic.auddi.uddi.request.publish.SaveServiceRequest;
import weblogic.auddi.uddi.request.publish.SaveTModelRequest;
import weblogic.auddi.uddi.request.publish.UDDIPublishRequest;
import weblogic.auddi.uddi.response.AssertionStatusReportResponse;
import weblogic.auddi.uddi.response.BindingDetailResponse;
import weblogic.auddi.uddi.response.BusinessDetailResponse;
import weblogic.auddi.uddi.response.BusinessInfo;
import weblogic.auddi.uddi.response.BusinessInfos;
import weblogic.auddi.uddi.response.BusinessListResponse;
import weblogic.auddi.uddi.response.RegisteredInfoResponse;
import weblogic.auddi.uddi.response.RelatedBusinessListResponse;
import weblogic.auddi.uddi.response.ServiceDetailResponse;
import weblogic.auddi.uddi.response.ServiceInfo;
import weblogic.auddi.uddi.response.ServiceInfos;
import weblogic.auddi.uddi.response.ServiceListResponse;
import weblogic.auddi.uddi.response.TModelDetailResponse;
import weblogic.auddi.uddi.response.TModelInfo;
import weblogic.auddi.uddi.response.TModelInfos;
import weblogic.auddi.uddi.response.TModelListResponse;
import weblogic.auddi.uddi.response.UDDIResponse;
import weblogic.auddi.util.Logger;
import weblogic.auddi.util.PropertyManager;
import weblogic.xml.jaxr.registry.BulkResponseImpl;
import weblogic.xml.jaxr.registry.BusinessLifeCycleManagerImpl;
import weblogic.xml.jaxr.registry.ConnectionImpl;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.bridge.uddi.PartialCommitHelper;
import weblogic.xml.jaxr.registry.bridge.uddi.UDDIBridgeMapperUtil;
import weblogic.xml.jaxr.registry.bridge.uddi.UDDIBridgeRequestMapper;
import weblogic.xml.jaxr.registry.bridge.uddi.UDDIBridgeResponseMapper;
import weblogic.xml.jaxr.registry.bridge.uddi.UDDITaxonomies;
import weblogic.xml.jaxr.registry.provider.BaseRegistryProxy;
import weblogic.xml.jaxr.registry.provider.InternalClassificationSchemes;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;
import weblogic.xml.jaxr.registry.util.ClassificationSchemeHelper;

public class UDDIBridgeProxy
extends BaseRegistryProxy {
    private UDDIProxy m_uddiProxy;
    private RegistryServiceImpl m_registryServiceImpl;
    private UDDITaxonomies m_helper;
    private int m_maxRows;

    public UDDIBridgeProxy(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        Logger.debug("+UDDIBridgeProxy.CTOR");
        this.m_registryServiceImpl = registryServiceImpl;
        this.m_helper = new UDDITaxonomies();
        ConnectionImpl connectionImpl = registryServiceImpl.getConnectionImpl();
        URL uRL = connectionImpl.getQueryURL();
        URL uRL2 = connectionImpl.getPublishURL();
        this.m_uddiProxy = new UDDIProxy();
        Integer n = connectionImpl.getMaxRows();
        this.m_maxRows = n != null ? n : Integer.MIN_VALUE;
        try {
            UDDIBridgeProxy.initializeAuddiClient();
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
        catch (IOException iOException) {
            throw new InvalidRequestException((Throwable)iOException);
        }
        try {
            this.m_uddiProxy.setInquiryURL(uRL.toExternalForm());
            this.m_uddiProxy.setPublishURL(uRL2.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidRequestException((Throwable)malformedURLException);
        }
        Logger.debug("-UDDIBridgeProxy.CTOR");
    }

    public void setCredentials(String string, String string2) throws JAXRException {
        this.m_uddiProxy.setCredential(string, string2);
    }

    public void closeConnection() throws JAXRException {
        this.m_uddiProxy = null;
    }

    public InternalClassificationSchemes getInternalClassificationSchemes() throws JAXRException {
        return this.m_helper;
    }

    public String getRegistryObjectOwner(RegistryObject registryObject) throws JAXRException {
        String string;
        if (registryObject == null) {
            string = null;
        } else {
            Slot slot = registryObject.getSlot("authorizedName");
            if (slot == null) {
                string = null;
            } else {
                Collection collection = slot.getValues();
                string = null;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && string == null) {
                    string = (String)iterator.next();
                }
            }
        }
        return string;
    }

    public void setRegistryObjectOwner(RegistryObject registryObject, String string) throws JAXRException {
        BusinessLifeCycleManagerImpl businessLifeCycleManagerImpl = (BusinessLifeCycleManagerImpl)this.m_registryServiceImpl.getBusinessLifeCycleManager();
        Slot slot = businessLifeCycleManagerImpl.createSlot("authorizedName", string, "authorizedName");
        registryObject.addSlot(slot);
    }

    public String makeRegistrySpecificRequest(String string) throws JAXRException {
        UDDIResponse uDDIResponse;
        try {
            String string2 = SOAPWrapper.makeSOAPString(string);
            uDDIResponse = this.m_uddiProxy.processRequestString(string2);
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
        return uDDIResponse.toXML();
    }

    public BulkResponse saveOrganizations(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                SaveBusinessRequest saveBusinessRequest = UDDIBridgeRequestMapper.getSaveBusinessRequest(collection, UDDIBridgeProxy.this.m_registryServiceImpl);
                return saveBusinessRequest;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BusinessDetailResponse businessDetailResponse = (BusinessDetailResponse)uDDIResponse;
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromBusinessDetailResponse(UDDIBridgeProxy.this.m_registryServiceImpl, businessDetailResponse);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public BulkResponse saveServices(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                SaveServiceRequest saveServiceRequest = UDDIBridgeRequestMapper.getSaveServiceRequest(collection);
                return saveServiceRequest;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                ServiceDetailResponse serviceDetailResponse = (ServiceDetailResponse)uDDIResponse;
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromServiceDetailResponse(UDDIBridgeProxy.this.m_registryServiceImpl, serviceDetailResponse);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public BulkResponse saveServiceBindings(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                SaveBindingRequest saveBindingRequest = UDDIBridgeRequestMapper.getSaveBindingsRequest(collection);
                return saveBindingRequest;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BindingDetailResponse bindingDetailResponse = (BindingDetailResponse)uDDIResponse;
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromBindingDetailResponse(UDDIBridgeProxy.this.m_registryServiceImpl, bindingDetailResponse);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public BulkResponse saveConcepts(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                SaveTModelRequest saveTModelRequest = UDDIBridgeRequestMapper.getSaveTModelFromConcepts(collection);
                return saveTModelRequest;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                TModelDetailResponse tModelDetailResponse = (TModelDetailResponse)uDDIResponse;
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromTModelDetailResponse(UDDIBridgeProxy.this.m_registryServiceImpl, tModelDetailResponse);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public BulkResponse saveClassificationSchemes(Collection collection) throws JAXRException {
        Logger.debug("+UDDIBridgeProxy.saveClassificationSchemes()");
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                SaveTModelRequest saveTModelRequest = UDDIBridgeRequestMapper.getSaveTModelFromClassificationSchemes(collection);
                return saveTModelRequest;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                TModelDetailResponse tModelDetailResponse = (TModelDetailResponse)uDDIResponse;
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromTModelDetailResponse(UDDIBridgeProxy.this.m_registryServiceImpl, tModelDetailResponse);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        Logger.debug("-UDDIBridgeProxy.saveClassificationSchemes()");
        return bulkResponse;
    }

    public BulkResponse saveAssociations(Collection collection, boolean bl) throws JAXRException {
        if (bl) {
            return this.setAssociations(collection);
        }
        return this.addAssociations(collection);
    }

    public BulkResponse deleteOrganizations(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){
            DeleteBusinessRequest request = null;

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                this.request = UDDIBridgeRequestMapper.getDeleteBusinessRequest(collection);
                return this.request;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromDeleteBusinessRequest(UDDIBridgeProxy.this.m_registryServiceImpl, this.request);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public BulkResponse deleteServices(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){
            DeleteServiceRequest request = null;

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                this.request = UDDIBridgeRequestMapper.getDeleteServiceRequest(collection);
                return this.request;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromDeleteServiceRequest(UDDIBridgeProxy.this.m_registryServiceImpl, this.request);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public BulkResponse deleteServiceBindings(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){
            DeleteBindingRequest request = null;

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                this.request = UDDIBridgeRequestMapper.getDeleteBindingRequest(collection);
                return this.request;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromDeleteBindingRequest(UDDIBridgeProxy.this.m_registryServiceImpl, this.request);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public BulkResponse deleteConcepts(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){
            DeleteTModelRequest request = null;

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                this.request = UDDIBridgeRequestMapper.getDeleteTModelRequest(collection);
                return this.request;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromDeleteTModelRequest(UDDIBridgeProxy.this.m_registryServiceImpl, this.request);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public BulkResponse deleteClassificationSchemes(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){
            DeleteTModelRequest request = null;

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                this.request = UDDIBridgeRequestMapper.getDeleteTModelRequest(collection);
                return this.request;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeysFromDeleteTModelRequest(UDDIBridgeProxy.this.m_registryServiceImpl, this.request);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public BulkResponse deleteAssociations(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){
            DeletePublisherAssertionsRequest request = null;
            Collection keysForReturn;

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                this.request = UDDIBridgeRequestMapper.getDeletePublisherAssertionsRequest(collection, UDDIBridgeProxy.this.m_registryServiceImpl);
                this.keysForReturn = collection;
                return this.request;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForKeys(UDDIBridgeProxy.this.m_registryServiceImpl, this.keysForReturn);
                return bulkResponse;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    public void confirmAssociation(Association association) throws JAXRException, InvalidRequestException {
        if (!this.isIntramural(association) && !association.isConfirmed()) {
            ArrayList<Association> arrayList = new ArrayList<Association>();
            arrayList.add(association);
            this.addAssociations(arrayList);
        }
    }

    public void unConfirmAssociation(Association association) throws JAXRException, InvalidRequestException {
        if (association.isExtramural() && association.isConfirmed()) {
            ArrayList<Key> arrayList = new ArrayList<Key>();
            arrayList.add(association.getKey());
            this.deleteAssociations(arrayList);
        }
    }

    public BulkResponse findAssociations(Collection collection, String string, String string2, Collection collection2) throws JAXRException {
        try {
            BulkResponseImpl bulkResponseImpl;
            if (!(collection != null && collection.size() != 0 || string != null || string2 != null || collection2 != null && collection2.size() != 0)) {
                bulkResponseImpl = new BulkResponseImpl(this.m_registryServiceImpl);
            } else {
                if (null == string && null == string2) {
                    String string3 = JAXRMessages.getMessage("jaxr.bridge.uddiBridgeProxy.findAssociations.invalidObjectId");
                    throw new JAXRException(string3);
                }
                boolean bl = string == null;
                if (null == collection2) {
                    FindRelatedBusinessesRequest findRelatedBusinessesRequest = UDDIBridgeRequestMapper.getFindRelatedBusinessesRequest(collection, string, string2, null);
                    this.setMaxRows(findRelatedBusinessesRequest);
                    RelatedBusinessListResponse relatedBusinessListResponse = (RelatedBusinessListResponse)this.m_uddiProxy.execute(findRelatedBusinessesRequest);
                    Organization organization = (Organization)this.getRegistryObject(relatedBusinessListResponse.getBusinessKey().getKey(), "Organization");
                    bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseForAssociations(this.m_registryServiceImpl, relatedBusinessListResponse, bl, organization);
                } else {
                    bulkResponseImpl = new BulkResponseImpl(this.m_registryServiceImpl);
                    Collection collection3 = UDDIBridgeMapperUtil.getKeyedReferencesFromAssociationTypes(collection2, this.m_registryServiceImpl);
                    Iterator iterator = collection3.iterator();
                    while (iterator.hasNext()) {
                        FindRelatedBusinessesRequest findRelatedBusinessesRequest = UDDIBridgeRequestMapper.getFindRelatedBusinessesRequest(collection, string, string2, (KeyedReference)iterator.next());
                        this.setMaxRows(findRelatedBusinessesRequest);
                        RelatedBusinessListResponse relatedBusinessListResponse = (RelatedBusinessListResponse)this.m_uddiProxy.execute(findRelatedBusinessesRequest);
                        Organization organization = (Organization)this.getRegistryObject(relatedBusinessListResponse.getBusinessKey().getKey(), "Organization");
                        BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForAssociations(this.m_registryServiceImpl, relatedBusinessListResponse, bl, organization);
                        UDDIBridgeMapperUtil.accumulateBulkResponses(bulkResponseImpl, bulkResponse);
                    }
                }
            }
            return bulkResponseImpl;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public BulkResponse findCallerAssociations(Collection collection, Boolean bl, Boolean bl2, Collection collection2) throws JAXRException {
        try {
            BulkResponseImpl bulkResponseImpl;
            if (!(collection != null && collection.size() != 0 || bl != null || bl2 != null || collection2 != null && collection2.size() != 0)) {
                bulkResponseImpl = new BulkResponseImpl(this.m_registryServiceImpl);
            } else {
                GetAssertionStatusReportRequest getAssertionStatusReportRequest = new GetAssertionStatusReportRequest();
                AssertionStatusReportResponse assertionStatusReportResponse = (AssertionStatusReportResponse)this.m_uddiProxy.execute(getAssertionStatusReportRequest);
                AssertionStatusItems assertionStatusItems = UDDIBridgeMapperUtil.selectAssertionStatusItems(assertionStatusReportResponse.getAssertionStatusItems(), bl, bl2, collection2);
                ArrayList<Association> arrayList = new ArrayList<Association>();
                AssertionStatusItem assertionStatusItem = assertionStatusItems.getFirst();
                while (assertionStatusItem != null) {
                    Association association = UDDIBridgeResponseMapper.getAssociation(this.m_registryServiceImpl, assertionStatusItem);
                    Organization organization = (Organization)this.getRegistryObject(assertionStatusItem.getFromKey().getKey(), "Organization");
                    Organization organization2 = (Organization)this.getRegistryObject(assertionStatusItem.getToKey().getKey(), "Organization");
                    association.setSourceObject((RegistryObject)organization);
                    association.setTargetObject((RegistryObject)organization2);
                    arrayList.add(association);
                    assertionStatusItem = assertionStatusItems.getNext();
                }
                bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(arrayList, this.m_registryServiceImpl);
            }
            return bulkResponseImpl;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public BulkResponse findOrganizations(Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, Collection collection6) throws JAXRException {
        try {
            FindBusinessRequest findBusinessRequest = UDDIBridgeRequestMapper.getFindBusinessRequest(collection, collection2, collection3, collection4, collection5, collection6);
            this.setMaxRows(findBusinessRequest);
            BusinessListResponse businessListResponse = (BusinessListResponse)this.m_uddiProxy.execute(findBusinessRequest);
            BusinessInfos businessInfos = businessListResponse.getBusinessInfos();
            BusinessEntities businessEntities = this.getBusinessEntitiesFromBusinessInfos(businessInfos);
            return UDDIBridgeResponseMapper.getBulkResponseForOrganizations(this.m_registryServiceImpl, businessEntities);
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public BulkResponse findServices(Key key, Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
        try {
            FindServiceRequest findServiceRequest = UDDIBridgeRequestMapper.getFindServiceRequest(key, collection, collection2, collection3, collection4);
            this.setMaxRows(findServiceRequest);
            ServiceListResponse serviceListResponse = (ServiceListResponse)this.m_uddiProxy.execute(findServiceRequest);
            ServiceInfos serviceInfos = serviceListResponse.getServiceInfos();
            return this.getServicesFromServiceInfos(serviceInfos);
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public BulkResponse findServiceBindings(Key key, Collection collection, Collection collection2, Collection collection3) throws JAXRException {
        try {
            Logger.debug("+UDDIBridgeProxy.findServiceBindings");
            FindBindingRequest findBindingRequest = UDDIBridgeRequestMapper.getFindBindingRequest(key, collection, collection3);
            this.setMaxRows(findBindingRequest);
            BindingDetailResponse bindingDetailResponse = (BindingDetailResponse)this.m_uddiProxy.execute(findBindingRequest);
            Collection collection4 = this.findServicesByBindingDetailResponse(bindingDetailResponse);
            BulkResponse bulkResponse = UDDIBridgeResponseMapper.getBulkResponseForServiceBindings(this.m_registryServiceImpl, bindingDetailResponse, collection4);
            return bulkResponse;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
        finally {
            Logger.debug("-UDDIBridgeProxy.findServiceBindings");
        }
    }

    private Collection findServicesByBindingDetailResponse(BindingDetailResponse bindingDetailResponse) throws JAXRException {
        try {
            ArrayList<ServiceKey> arrayList;
            Logger.debug("+UDDIBridgeProxy.findServicesByBindingDetailResponse");
            Collection<ServiceKey> collection = null;
            BindingTemplates bindingTemplates = bindingDetailResponse.getBindingTemplates();
            if (bindingTemplates != null) {
                arrayList = new ArrayList<ServiceKey>();
                Object object = bindingTemplates.getFirst();
                while (object != null) {
                    arrayList.add(((BindingTemplate)object).getServiceKey());
                    object = bindingTemplates.getNext();
                }
                object = UDDIBridgeRequestMapper.getServiceDetailRequest(arrayList);
                ServiceDetailResponse serviceDetailResponse = (ServiceDetailResponse)this.m_uddiProxy.execute((UDDIRequest)object);
                collection = UDDIBridgeResponseMapper.getServices(this.m_registryServiceImpl, serviceDetailResponse.getBusinessServices());
                UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, this.m_registryServiceImpl);
            }
            arrayList = collection;
            return arrayList;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
        finally {
            Logger.debug("-UDDIBridgeProxy.findServicesByBindingDetailResponse");
        }
    }

    public BulkResponse findClassificationSchemes(Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
        try {
            FindTModelRequest findTModelRequest = UDDIBridgeRequestMapper.getFindTModelRequest(collection, collection2, collection3, null);
            this.setMaxRows(findTModelRequest);
            TModelListResponse tModelListResponse = (TModelListResponse)this.m_uddiProxy.execute(findTModelRequest);
            TModelInfos tModelInfos = tModelListResponse.getTModelInfos();
            TModels tModels = this.getTModelsFromTModelInfos(tModelInfos);
            BulkResponseImpl bulkResponseImpl = (BulkResponseImpl)UDDIBridgeResponseMapper.getBulkResponseForClassificationSchemes(this.m_registryServiceImpl, tModels);
            if (collection2 != null && collection2.size() > 0) {
                for (Object e : collection2) {
                    ClassificationScheme classificationScheme;
                    String string = e instanceof String ? (String)e : (e instanceof LocalizedString ? ((LocalizedString)e).getValue() : null);
                    if (string == null || (classificationScheme = ClassificationSchemeHelper.getClassificationSchemeByName(string, this.m_registryServiceImpl)) == null) continue;
                    ArrayList<ClassificationScheme> arrayList = new ArrayList<ClassificationScheme>();
                    arrayList.add(classificationScheme);
                    BulkResponseImpl bulkResponseImpl2 = UDDIBridgeResponseMapper.getBulkResponseFromCollection(arrayList, this.m_registryServiceImpl);
                    UDDIBridgeMapperUtil.accumulateBulkResponses(bulkResponseImpl, bulkResponseImpl2);
                }
            }
            return bulkResponseImpl;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public ClassificationScheme findClassificationSchemeByName(Collection collection, String string) throws JAXRException {
        try {
            ClassificationScheme classificationScheme = ClassificationSchemeHelper.getClassificationSchemeByName(string, this.m_registryServiceImpl);
            if (classificationScheme == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                FindTModelRequest findTModelRequest = UDDIBridgeRequestMapper.getFindTModelRequest(collection, arrayList, null, null);
                this.setMaxRows(findTModelRequest);
                TModelListResponse tModelListResponse = (TModelListResponse)this.m_uddiProxy.execute(findTModelRequest);
                TModelInfos tModelInfos = tModelListResponse.getTModelInfos();
                TModels tModels = this.getTModelsFromTModelInfos(tModelInfos);
                TModel tModel = tModels.getFirst();
                TModel tModel2 = tModels.getNext();
                if (tModel2 != null) {
                    String string2 = JAXRMessages.getMessage("jaxr.registry.registryServiceImpl.MultipleMatchesFound");
                    throw new InvalidRequestException(string2);
                }
                classificationScheme = UDDIBridgeResponseMapper.getClassificationScheme(this.m_registryServiceImpl, tModel);
            }
            return classificationScheme;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public BulkResponse findConcepts(Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5) throws JAXRException {
        try {
            FindTModelRequest findTModelRequest = UDDIBridgeRequestMapper.getFindTModelRequest(collection, collection2, collection3, collection4);
            this.setMaxRows(findTModelRequest);
            TModelListResponse tModelListResponse = (TModelListResponse)this.m_uddiProxy.execute(findTModelRequest);
            TModelInfos tModelInfos = tModelListResponse.getTModelInfos();
            TModels tModels = this.getTModelsFromTModelInfos(tModelInfos);
            return UDDIBridgeResponseMapper.getBulkResponseForConcepts(this.m_registryServiceImpl, tModels);
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public Concept findConceptByPath(String string) throws JAXRException {
        String string2;
        ClassificationScheme classificationScheme;
        String string3;
        StringTokenizer stringTokenizer;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "/", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                arrayList.add(string4);
            }
        } else {
            String string5 = JAXRMessages.getMessage("jaxr.bridge.uddiBridgeProxy.findConceptByPath.invalidPath");
            throw new JAXRException(string5);
        }
        stringTokenizer = null;
        int n = arrayList.size();
        if (n > 2 && (string3 = (String)arrayList.get(0)).equals("/") && (classificationScheme = ClassificationSchemeHelper.getClassificationSchemeByName(string2 = (String)arrayList.get(1), this.m_registryServiceImpl)) != null) {
            Collection collection = classificationScheme.getChildrenConcepts();
            for (int i = 2; i < n; i += 2) {
                string3 = (String)arrayList.get(i);
                int n2 = i + 1;
                if (!string3.equals("/") || n2 >= n) continue;
                String string6 = (String)arrayList.get(n2);
                if (collection == null) continue;
                stringTokenizer = UDDIBridgeMapperUtil.getConceptByValue(collection, string6);
            }
        }
        return stringTokenizer;
    }

    public BulkResponse findRegistryPackages(Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
        this.checkCapability(this.m_registryServiceImpl, 1);
        return null;
    }

    public BulkResponse deprecateObjects(Collection collection) throws JAXRException {
        this.checkCapability(this.m_registryServiceImpl, 1);
        return null;
    }

    public BulkResponse unDeprecateObjects(Collection collection) throws JAXRException {
        this.checkCapability(this.m_registryServiceImpl, 1);
        return null;
    }

    public BulkResponse deleteObjects(Collection collection) throws JAXRException {
        this.checkCapability(this.m_registryServiceImpl, 1);
        return null;
    }

    public RegistryObject getRegistryObject(String string, String string2) throws JAXRException {
        BusinessLifeCycleManager businessLifeCycleManager = this.m_registryServiceImpl.getBusinessLifeCycleManager();
        Key key = businessLifeCycleManager.createKey(string);
        ArrayList<Key> arrayList = new ArrayList<Key>();
        arrayList.add(key);
        BulkResponse bulkResponse = this.getRegistryObjects(arrayList, string2);
        Collection collection = bulkResponse.getCollection();
        Iterator iterator = collection.iterator();
        RegistryObject registryObject = (RegistryObject)iterator.next();
        return registryObject;
    }

    public RegistryObject getRegistryObject(String string) throws JAXRException {
        this.checkCapability(this.m_registryServiceImpl, 1);
        return null;
    }

    public BulkResponse getRegistryObjects(Collection collection) throws JAXRException {
        this.checkCapability(this.m_registryServiceImpl, 1);
        return null;
    }

    public BulkResponse getRegistryObjects(Collection collection, String string) throws JAXRException {
        try {
            BulkResponseImpl bulkResponseImpl = new BulkResponseImpl(this.m_registryServiceImpl);
            if ("Organization".equals(string)) {
                GetBusinessDetailRequest getBusinessDetailRequest = new GetBusinessDetailRequest();
                for (Key key : collection) {
                    BusinessKey businessKey = new BusinessKey(key.getId());
                    getBusinessDetailRequest.addBusinessKey(businessKey);
                }
                BusinessDetailResponse businessDetailResponse = (BusinessDetailResponse)this.m_uddiProxy.execute(getBusinessDetailRequest);
                bulkResponseImpl = (BulkResponseImpl)UDDIBridgeResponseMapper.getBulkResponseForOrganizations(this.m_registryServiceImpl, businessDetailResponse.getBusinessEntities());
            } else if ("ClassificationScheme".equals(string) || "Concept".equals(string)) {
                GetTModelDetailRequest getTModelDetailRequest = new GetTModelDetailRequest();
                for (Key key : collection) {
                    TModelKey tModelKey = new TModelKey(key.getId());
                    getTModelDetailRequest.addTModelKey(tModelKey);
                }
                TModelDetailResponse tModelDetailResponse = (TModelDetailResponse)this.m_uddiProxy.execute(getTModelDetailRequest);
                bulkResponseImpl = (BulkResponseImpl)UDDIBridgeResponseMapper.getBulkResponseForConceptsOrClassificationSchemes(this.m_registryServiceImpl, tModelDetailResponse);
            } else if ("Service".equals(string)) {
                GetServiceDetailRequest getServiceDetailRequest = new GetServiceDetailRequest();
                for (Key key : collection) {
                    ServiceKey serviceKey = new ServiceKey(key.getId());
                    getServiceDetailRequest.addServiceKey(serviceKey);
                }
                ServiceDetailResponse serviceDetailResponse = (ServiceDetailResponse)this.m_uddiProxy.execute(getServiceDetailRequest);
                bulkResponseImpl = (BulkResponseImpl)UDDIBridgeResponseMapper.getBulkResponseForServicesFromServiceDetailResponse(this.m_registryServiceImpl, serviceDetailResponse);
            } else if ("ServiceBinding".equals(string)) {
                GetBindingDetailRequest getBindingDetailRequest = new GetBindingDetailRequest();
                for (Key key : collection) {
                    BindingKey bindingKey = new BindingKey(key.getId());
                    getBindingDetailRequest.addBindingKey(bindingKey);
                }
                BindingDetailResponse bindingDetailResponse = (BindingDetailResponse)this.m_uddiProxy.execute(getBindingDetailRequest);
                bulkResponseImpl = (BulkResponseImpl)UDDIBridgeResponseMapper.getBulkResponseForServiceBindings(this.m_registryServiceImpl, bindingDetailResponse);
            } else {
                String string2 = JAXRMessages.getMessage("jaxr.bridge.uddiBridgeProxy.getRegistryObjects.invalidObjectType");
                throw new JAXRException(string2);
            }
            return bulkResponseImpl;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public BulkResponse getRegistryObjects() throws JAXRException {
        return this.getRegistryObjectsOfCallers(null, null);
    }

    public BulkResponse getRegistryObjects(String string) throws JAXRException {
        return this.getRegistryObjectsOfCallers(null, string);
    }

    public BusinessEntities getBusinessEntitiesFromBusinessInfos(BusinessInfos businessInfos) throws JAXRException {
        try {
            BusinessEntities businessEntities;
            if (businessInfos != null && businessInfos.size() > 0) {
                ArrayList<BusinessKey> arrayList = new ArrayList<BusinessKey>();
                Object object = businessInfos.getFirst();
                while (object != null) {
                    arrayList.add(((BusinessInfo)object).getBusinessKey());
                    object = businessInfos.getNext();
                }
                object = UDDIBridgeRequestMapper.getBusinessDetailRequest(arrayList);
                BusinessDetailResponse businessDetailResponse = (BusinessDetailResponse)this.m_uddiProxy.execute((UDDIRequest)object);
                businessEntities = businessDetailResponse.getBusinessEntities();
            } else {
                businessEntities = new BusinessEntities();
            }
            return businessEntities;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public BulkResponse getServicesFromServiceInfos(ServiceInfos serviceInfos) throws JAXRException {
        try {
            BulkResponseImpl bulkResponseImpl;
            if (serviceInfos != null && serviceInfos.size() > 0) {
                ArrayList<ServiceKey> arrayList = new ArrayList<ServiceKey>();
                Object object = serviceInfos.getFirst();
                while (object != null) {
                    arrayList.add(((ServiceInfo)object).getServiceKey());
                    object = serviceInfos.getNext();
                }
                object = UDDIBridgeRequestMapper.getServiceDetailRequest(arrayList);
                ServiceDetailResponse serviceDetailResponse = (ServiceDetailResponse)this.m_uddiProxy.execute((UDDIRequest)object);
                bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseForServicesFromServiceDetailResponse(this.m_registryServiceImpl, serviceDetailResponse);
            } else {
                BulkResponseImpl bulkResponseImpl2 = new BulkResponseImpl(this.m_registryServiceImpl);
                bulkResponseImpl2.setResponse(Collections.EMPTY_LIST, null, false);
                bulkResponseImpl = bulkResponseImpl2;
            }
            return bulkResponseImpl;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public TModels getTModelsFromTModelInfos(TModelInfos tModelInfos) throws JAXRException {
        try {
            TModels tModels;
            ArrayList<TModelKey> arrayList = new ArrayList<TModelKey>();
            Object object = tModelInfos.getFirst();
            while (object != null) {
                arrayList.add(((TModelInfo)object).getKey());
                object = tModelInfos.getNext();
            }
            if (arrayList.size() > 0) {
                object = UDDIBridgeRequestMapper.getTModelDetailRequest(arrayList);
                TModelDetailResponse tModelDetailResponse = (TModelDetailResponse)this.m_uddiProxy.execute((UDDIRequest)object);
                tModels = tModelDetailResponse.getTModels();
            } else {
                tModels = new TModels();
            }
            return tModels;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BulkResponse getRegistryObjectsOfCallers(Collection collection, String string) throws JAXRException {
        try {
            Collection collection2;
            block17: {
                Object object;
                TModels tModels;
                TModels tModels2;
                TModels tModels3;
                block22: {
                    Object object2;
                    TModels tModels4;
                    TModels tModels5;
                    TModels tModels6;
                    block21: {
                        TModelInfos tModelInfos;
                        BusinessInfos businessInfos;
                        block18: {
                            block20: {
                                block19: {
                                    GetRegisteredInfoRequest getRegisteredInfoRequest = UDDIBridgeRequestMapper.getRegisteredInfoRequest();
                                    RegisteredInfoResponse registeredInfoResponse = (RegisteredInfoResponse)this.m_uddiProxy.execute(getRegisteredInfoRequest);
                                    collection2 = new ArrayList();
                                    businessInfos = registeredInfoResponse.getBusinessInfos();
                                    tModelInfos = registeredInfoResponse.getTModelInfos();
                                    if (null == string) break block18;
                                    if (!string.equals("Organization")) break block19;
                                    BusinessEntities businessEntities = this.getBusinessEntitiesFromBusinessInfos(businessInfos);
                                    collection2 = UDDIBridgeResponseMapper.getOrganizationsFromBusinessEntities(this.m_registryServiceImpl, businessEntities);
                                    break block17;
                                }
                                if (!string.equals("Concept") && !string.equals("ClassificationScheme")) break block20;
                                tModels6 = this.getTModelsFromTModelInfos(tModelInfos);
                                tModels5 = new TModels();
                                tModels4 = new TModels();
                                object2 = tModels6.getFirst();
                                break block21;
                            }
                            if (string.equals("Service")) {
                                BusinessEntities businessEntities = this.getBusinessEntitiesFromBusinessInfos(businessInfos);
                                Collection collection3 = UDDIBridgeResponseMapper.getOrganizationsFromBusinessEntities(this.m_registryServiceImpl, businessEntities);
                                for (Organization organization : collection3) {
                                    collection2.addAll(organization.getServices());
                                }
                                break block17;
                            } else {
                                if (!string.equals("ServiceBinding")) {
                                    String string2 = JAXRMessages.getMessage("jaxr.bridge.uddiBridgeProxy.getRegistryObjects.invalidObjectType");
                                    throw new JAXRException(string2);
                                }
                                BusinessEntities businessEntities = this.getBusinessEntitiesFromBusinessInfos(businessInfos);
                                Collection collection4 = UDDIBridgeResponseMapper.getOrganizationsFromBusinessEntities(this.m_registryServiceImpl, businessEntities);
                                Iterator iterator = collection4.iterator();
                                while (iterator.hasNext()) {
                                    Organization organization = (Organization)iterator.next();
                                    Collection collection5 = organization.getServices();
                                    Iterator iterator2 = collection5.iterator();
                                    while (iterator.hasNext()) {
                                        Service service2 = (Service)iterator2.next();
                                        collection2.addAll(service2.getServiceBindings());
                                    }
                                }
                            }
                            break block17;
                        }
                        BusinessEntities businessEntities = this.getBusinessEntitiesFromBusinessInfos(businessInfos);
                        collection2 = UDDIBridgeResponseMapper.getOrganizationsFromBusinessEntities(this.m_registryServiceImpl, businessEntities);
                        tModels3 = this.getTModelsFromTModelInfos(tModelInfos);
                        tModels2 = new TModels();
                        tModels = new TModels();
                        object = tModels3.getFirst();
                        break block22;
                    }
                    while (object2 != null) {
                        if (UDDIBridgeMapperUtil.isConcept((TModel)object2)) {
                            tModels5.add((TModel)object2);
                        } else {
                            tModels4.add((TModel)object2);
                        }
                        object2 = tModels6.getNext();
                    }
                    if (string.equals("ClassificationScheme")) {
                        collection2 = UDDIBridgeResponseMapper.getClassificationSchemes(this.m_registryServiceImpl, tModels4);
                        break block17;
                    } else {
                        if (!string.equals("Concept")) {
                            object2 = JAXRMessages.getMessage("jaxr.bridge.uddiBridgeProxy.getRegistryObjects.invalidObjectType");
                            throw new JAXRException((String)object2);
                        }
                        collection2 = UDDIBridgeResponseMapper.getConcepts(this.m_registryServiceImpl, tModels5);
                    }
                    break block17;
                }
                while (object != null) {
                    if (UDDIBridgeMapperUtil.isConcept((TModel)object)) {
                        tModels2.add((TModel)object);
                    } else {
                        tModels.add((TModel)object);
                    }
                    object = tModels3.getNext();
                }
                object = UDDIBridgeResponseMapper.getClassificationSchemes(this.m_registryServiceImpl, tModels);
                collection2.addAll(object);
                object = UDDIBridgeResponseMapper.getConcepts(this.m_registryServiceImpl, tModels2);
                collection2.addAll(object);
            }
            if (null == collection) return UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection2, this.m_registryServiceImpl);
            collection2 = UDDIBridgeProxy.selectWantedRegistryObjects(collection2, collection);
            return UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection2, this.m_registryServiceImpl);
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    private BulkResponse setAssociations(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){
            UDDIPublishRequest request = null;
            Collection keysForReturn = null;

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                this.request = UDDIBridgeRequestMapper.getSetPublisherAssertions(collection);
                ArrayList<Key> arrayList = new ArrayList<Key>();
                for (Association association : collection) {
                    arrayList.add(association.getKey());
                }
                this.keysForReturn = arrayList;
                return this.request;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(this.keysForReturn, UDDIBridgeProxy.this.m_registryServiceImpl);
                return bulkResponseImpl;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    private BulkResponse addAssociations(Collection collection) throws JAXRException {
        PartialCommitHelper.JaxrAPIMapper jaxrAPIMapper = new PartialCommitHelper.JaxrAPIMapper(){
            UDDIPublishRequest request = null;
            Collection keysForReturn = null;

            public UDDIRequest getUDDIRequest(Collection collection) throws JAXRException {
                this.request = UDDIBridgeRequestMapper.getAddPublisherAssertions(collection);
                ArrayList<Key> arrayList = new ArrayList<Key>();
                for (Association association : collection) {
                    arrayList.add(association.getKey());
                }
                this.keysForReturn = arrayList;
                return this.request;
            }

            public BulkResponse getBulkResponse(RegistryServiceImpl registryServiceImpl, UDDIResponse uDDIResponse) throws JAXRException {
                BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(this.keysForReturn, UDDIBridgeProxy.this.m_registryServiceImpl);
                return bulkResponseImpl;
            }
        };
        BulkResponse bulkResponse = PartialCommitHelper.handlePartialCommit(jaxrAPIMapper, collection, this.m_uddiProxy, this.m_registryServiceImpl);
        return bulkResponse;
    }

    private static Collection selectWantedRegistryObjects(Collection collection, Collection collection2) throws JAXRException {
        ArrayList<RegistryObject> arrayList = new ArrayList<RegistryObject>();
        block0: for (RegistryObject registryObject : collection) {
            String string = registryObject.getKey().getId();
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                String string2 = ((Key)iterator.next()).getId();
                if (!string.equals(string2)) continue;
                arrayList.add(registryObject);
                continue block0;
            }
        }
        return arrayList;
    }

    private void setMaxRows(UDDIRequest uDDIRequest) {
        if (this.m_maxRows != Integer.MIN_VALUE) {
            uDDIRequest.setMaxRows(this.m_maxRows);
        }
    }

    private static void initializeAuddiClient() throws IOException, UDDIException {
        PropertyManager.setRuntimeProperty("uddi.schema.resource", "/weblogic/auddi/uddi/resources/uddi_v2.xsd");
        PropertyManager.setRuntimeProperty("soap.schema.resource", "/weblogic/auddi/uddi/resources/soap-envelope.xml");
        PropertyManager.setRuntimeProperty("xml.schema.resource", "/weblogic/auddi/uddi/resources/xml.xml");
    }

    private boolean isIntramural(Association association) throws JAXRException {
        RegistryObject registryObject = association.getSourceObject();
        RegistryObject registryObject2 = association.getTargetObject();
        if (registryObject == null || registryObject2 == null) {
            String string = JAXRMessages.getMessage("jaxr.registry.registryServiceImpl.invalidSourceORTarget");
            throw new InvalidRequestException(string);
        }
        String string = this.getRegistryObjectOwner(registryObject);
        String string2 = this.getRegistryObjectOwner(registryObject2);
        String string3 = this.getRegistryObjectOwner((RegistryObject)association);
        boolean bl = string3 == null ? string == null && string2 == null : (string != null ? string.equals(string2) && string.equals(string3) : false);
        return bl;
    }
}

