/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.bridge.uddi;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import weblogic.auddi.uddi.InvalidKeyPassedException;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.datastructure.BusinessKey;
import weblogic.auddi.uddi.datastructure.KeyedReference;
import weblogic.auddi.uddi.datastructure.ServiceKey;
import weblogic.auddi.uddi.datastructure.TModel;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.request.inquiry.FindBindingRequest;
import weblogic.auddi.uddi.request.inquiry.FindBusinessRequest;
import weblogic.auddi.uddi.request.inquiry.FindRelatedBusinessesRequest;
import weblogic.auddi.uddi.request.inquiry.FindServiceRequest;
import weblogic.auddi.uddi.request.inquiry.FindTModelRequest;
import weblogic.auddi.uddi.request.inquiry.GetBusinessDetailRequest;
import weblogic.auddi.uddi.request.inquiry.GetServiceDetailRequest;
import weblogic.auddi.uddi.request.inquiry.GetTModelDetailRequest;
import weblogic.auddi.uddi.request.publish.AddPublisherAssertionsRequest;
import weblogic.auddi.uddi.request.publish.DeleteBindingRequest;
import weblogic.auddi.uddi.request.publish.DeleteBusinessRequest;
import weblogic.auddi.uddi.request.publish.DeletePublisherAssertionsRequest;
import weblogic.auddi.uddi.request.publish.DeleteServiceRequest;
import weblogic.auddi.uddi.request.publish.DeleteTModelRequest;
import weblogic.auddi.uddi.request.publish.GetRegisteredInfoRequest;
import weblogic.auddi.uddi.request.publish.SaveBindingRequest;
import weblogic.auddi.uddi.request.publish.SaveBusinessRequest;
import weblogic.auddi.uddi.request.publish.SaveServiceRequest;
import weblogic.auddi.uddi.request.publish.SaveTModelRequest;
import weblogic.auddi.uddi.request.publish.SetPublisherAssertionsRequest;
import weblogic.xml.jaxr.registry.BaseJAXRObject;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.bridge.uddi.UDDIBridgeMapperUtil;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;

public class UDDIBridgeRequestMapper
extends BaseJAXRObject {
    private UDDIBridgeRequestMapper() {
    }

    public static FindBusinessRequest getFindBusinessRequest(Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, Collection collection6) throws JAXRException {
        FindBusinessRequest findBusinessRequest = new FindBusinessRequest();
        if (null != collection) {
            findBusinessRequest.setFindQualifiers(UDDIBridgeMapperUtil.getFindQualifiers(collection));
        }
        if (null != collection2) {
            findBusinessRequest.setNames(UDDIBridgeMapperUtil.getSearchNames(collection2));
        }
        if (null != collection3) {
            findBusinessRequest.setCategoryBag(UDDIBridgeMapperUtil.getCategoryBagFromClassifications(collection3));
        }
        if (null != collection4) {
            findBusinessRequest.setTModelBag(UDDIBridgeMapperUtil.getTModelBagFromSpecifications(collection4));
        }
        if (null != collection5) {
            findBusinessRequest.setIdentifierBag(UDDIBridgeMapperUtil.getIdentifierBag(collection5));
        }
        if (null != collection6) {
            findBusinessRequest.setDiscoveryURLs(UDDIBridgeMapperUtil.getDiscoveryURLs(collection6));
        }
        return findBusinessRequest;
    }

    public static FindTModelRequest getFindTModelRequest(Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
        FindTModelRequest findTModelRequest = new FindTModelRequest();
        if (null != collection) {
            findTModelRequest.setFindQualifiers(UDDIBridgeMapperUtil.getFindQualifiers(collection));
        }
        if (null != collection2) {
            findTModelRequest.setNames(UDDIBridgeMapperUtil.getSearchNames(collection2));
        }
        if (null != collection3) {
            findTModelRequest.setCategoryBag(UDDIBridgeMapperUtil.getCategoryBagFromClassifications(collection3));
        }
        if (null != collection4) {
            findTModelRequest.setIdentifierBag(UDDIBridgeMapperUtil.getIdentifierBag(collection4));
        }
        return findTModelRequest;
    }

    public static FindRelatedBusinessesRequest getFindRelatedBusinessesRequest(Collection collection, String string, String string2, KeyedReference keyedReference) throws JAXRException {
        FindRelatedBusinessesRequest findRelatedBusinessesRequest = new FindRelatedBusinessesRequest();
        if (null != collection) {
            findRelatedBusinessesRequest.setFindQualifiers(UDDIBridgeMapperUtil.getFindQualifiers(collection));
        }
        try {
            if (null != string) {
                findRelatedBusinessesRequest.setBusinessKey(new BusinessKey(string));
            } else if (null != string2) {
                findRelatedBusinessesRequest.setBusinessKey(new BusinessKey(string2));
            }
        }
        catch (InvalidKeyPassedException invalidKeyPassedException) {
            throw new JAXRException((Throwable)invalidKeyPassedException);
        }
        if (null != keyedReference) {
            findRelatedBusinessesRequest.setKeyedReference(keyedReference);
        }
        return findRelatedBusinessesRequest;
    }

    public static FindServiceRequest getFindServiceRequest(Key key, Collection collection, Collection collection2, Collection collection3, Collection collection4) throws JAXRException {
        FindServiceRequest findServiceRequest = new FindServiceRequest();
        if (null != collection) {
            findServiceRequest.setFindQualifiers(UDDIBridgeMapperUtil.getFindQualifiers(collection));
        }
        if (null != collection2) {
            findServiceRequest.setNames(UDDIBridgeMapperUtil.getSearchNames(collection2));
        }
        if (null != collection3) {
            findServiceRequest.setCategoryBag(UDDIBridgeMapperUtil.getCategoryBagFromClassifications(collection3));
        }
        if (null != collection4) {
            findServiceRequest.setTModelBag(UDDIBridgeMapperUtil.getTModelBagFromSpecifications(collection4));
        }
        if (null != key) {
            findServiceRequest.setBusinessKey(UDDIBridgeMapperUtil.getBusinessKey(key));
        }
        return findServiceRequest;
    }

    public static FindBindingRequest getFindBindingRequest(Key key, Collection collection, Collection collection2) throws JAXRException {
        FindBindingRequest findBindingRequest = new FindBindingRequest();
        if (null != collection) {
            findBindingRequest.setFindQualifiers(UDDIBridgeMapperUtil.getFindQualifiers(collection));
        }
        if (null != collection2) {
            findBindingRequest.setTModelBag(UDDIBridgeMapperUtil.getTModelBagFromSpecifications(collection2));
        }
        if (null != key) {
            findBindingRequest.setServiceKey(UDDIBridgeMapperUtil.getServiceKey(key));
        }
        return findBindingRequest;
    }

    public static SaveBusinessRequest getSaveBusinessRequest(Collection collection, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        try {
            SaveBusinessRequest saveBusinessRequest = new SaveBusinessRequest();
            if (collection != null) {
                for (Organization organization : collection) {
                    saveBusinessRequest.addBusinessEntity(UDDIBridgeMapperUtil.getBusinessEntity(organization, registryServiceImpl));
                }
            }
            return saveBusinessRequest;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public static SaveServiceRequest getSaveServiceRequest(Collection collection) throws JAXRException {
        try {
            SaveServiceRequest saveServiceRequest = new SaveServiceRequest();
            if (collection != null) {
                for (Service service2 : collection) {
                    saveServiceRequest.addBusinessService(UDDIBridgeMapperUtil.getBusinessService(service2));
                }
            }
            return saveServiceRequest;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public static GetRegisteredInfoRequest getRegisteredInfoRequest() throws JAXRException {
        return new GetRegisteredInfoRequest();
    }

    public static SaveBindingRequest getSaveBindingsRequest(Collection collection) throws JAXRException {
        try {
            SaveBindingRequest saveBindingRequest = new SaveBindingRequest();
            if (collection != null) {
                for (ServiceBinding serviceBinding : collection) {
                    saveBindingRequest.addBindingTemplate(UDDIBridgeMapperUtil.getBindingTemplate(serviceBinding));
                }
            }
            return saveBindingRequest;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public static SaveTModelRequest getSaveTModelFromConcepts(Collection collection) throws JAXRException {
        try {
            SaveTModelRequest saveTModelRequest = new SaveTModelRequest();
            if (collection != null) {
                for (Concept concept : collection) {
                    saveTModelRequest.addTModel(UDDIBridgeMapperUtil.getTModelFromConcept(concept));
                }
            }
            return saveTModelRequest;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public static SaveTModelRequest getSaveTModelFromClassificationSchemes(Collection collection) throws JAXRException {
        try {
            SaveTModelRequest saveTModelRequest = new SaveTModelRequest();
            if (collection != null) {
                for (ClassificationScheme classificationScheme : collection) {
                    TModel tModel = UDDIBridgeMapperUtil.getTModelFromClassificationScheme(classificationScheme);
                    if (tModel.getOverviewDoc() != null && tModel.getOverviewDoc().getOverviewURL() != null) {
                        UDDIBridgeRequestMapper.validateURI(tModel.getOverviewDoc().getOverviewURL().toString());
                    }
                    saveTModelRequest.addTModel(tModel);
                }
            }
            return saveTModelRequest;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public static void validateURI(String string) throws JAXRException {
        block9: {
            try {
                URL uRL = new URL(string);
                if (!uRL.getProtocol().equalsIgnoreCase("http")) break block9;
                try {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    int n = httpURLConnection.getResponseCode();
                    int n2 = n / 100;
                    if (n2 != 1 && n2 != 2 && n2 != 3) {
                        if (n2 == 4) {
                            String string2 = "jaxr.validation.uri.clientError";
                            Object[] objectArray = new String[]{string};
                            String string3 = JAXRMessages.getMessage(string2, objectArray);
                            throw new InvalidRequestException(string3);
                        }
                        if (n2 == 5) {
                            String string4 = "jaxr.validation.uri.serverError";
                            Object[] objectArray = new String[]{string};
                            String string5 = JAXRMessages.getMessage(string4, objectArray);
                            throw new InvalidRequestException(string5);
                        }
                        String string6 = "jaxr.validation.uri.unknownResponse";
                        Object[] objectArray = new String[]{string};
                        String string7 = JAXRMessages.getMessage(string6, objectArray);
                        throw new InvalidRequestException(string7);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    String string8 = "jaxr.validation.uri.unknownHostException";
                    Object[] objectArray = new String[]{string};
                    String string9 = JAXRMessages.getMessage(string8, objectArray);
                    throw new InvalidRequestException(string9, (Throwable)unknownHostException);
                }
                catch (ConnectException connectException) {
                    String string10 = "jaxr.validation.uri.connectException";
                    Object[] objectArray = new String[]{string};
                    String string11 = JAXRMessages.getMessage(string10, objectArray);
                    throw new InvalidRequestException(string11, (Throwable)connectException);
                }
                catch (IOException iOException) {
                    String string12 = "jaxr.validation.uri.ioException";
                    Object[] objectArray = new String[]{string};
                    String string13 = JAXRMessages.getMessage(string12, objectArray);
                    throw new InvalidRequestException(string13, (Throwable)iOException);
                }
            }
            catch (MalformedURLException malformedURLException) {
                String string14 = "jaxr.validation.uri.malformed";
                Object[] objectArray = new String[]{string};
                String string15 = JAXRMessages.getMessage(string14, objectArray);
                throw new InvalidRequestException(string15, (Throwable)malformedURLException);
            }
        }
    }

    public static SetPublisherAssertionsRequest getSetPublisherAssertions(Collection collection) throws JAXRException {
        SetPublisherAssertionsRequest setPublisherAssertionsRequest = new SetPublisherAssertionsRequest();
        if (collection != null) {
            for (Association association : collection) {
                setPublisherAssertionsRequest.addPublisherAssertion(UDDIBridgeMapperUtil.getPublisherAssertionFromAssociation(association));
            }
        }
        return setPublisherAssertionsRequest;
    }

    public static AddPublisherAssertionsRequest getAddPublisherAssertions(Collection collection) throws JAXRException {
        AddPublisherAssertionsRequest addPublisherAssertionsRequest = new AddPublisherAssertionsRequest();
        if (collection != null) {
            for (Association association : collection) {
                addPublisherAssertionsRequest.addPublisherAssertion(UDDIBridgeMapperUtil.getPublisherAssertionFromAssociation(association));
            }
        }
        return addPublisherAssertionsRequest;
    }

    public static DeleteBusinessRequest getDeleteBusinessRequest(Collection collection) throws JAXRException {
        DeleteBusinessRequest deleteBusinessRequest = new DeleteBusinessRequest();
        if (collection != null) {
            for (Key key : collection) {
                deleteBusinessRequest.addBusinessKey(UDDIBridgeMapperUtil.getBusinessKey(key));
            }
        }
        return deleteBusinessRequest;
    }

    public static DeleteBindingRequest getDeleteBindingRequest(Collection collection) throws JAXRException {
        DeleteBindingRequest deleteBindingRequest = new DeleteBindingRequest();
        if (collection != null) {
            for (Key key : collection) {
                deleteBindingRequest.addBindingKey(UDDIBridgeMapperUtil.getBindingKey(key));
            }
        }
        return deleteBindingRequest;
    }

    public static DeleteServiceRequest getDeleteServiceRequest(Collection collection) throws JAXRException {
        DeleteServiceRequest deleteServiceRequest = new DeleteServiceRequest();
        if (collection != null) {
            for (Key key : collection) {
                deleteServiceRequest.addServiceKey(UDDIBridgeMapperUtil.getServiceKey(key));
            }
        }
        return deleteServiceRequest;
    }

    public static DeleteTModelRequest getDeleteTModelRequest(Collection collection) throws JAXRException {
        DeleteTModelRequest deleteTModelRequest = new DeleteTModelRequest();
        if (collection != null) {
            for (Key key : collection) {
                deleteTModelRequest.addTModelKey(UDDIBridgeMapperUtil.getTModelKey(key));
            }
        }
        return deleteTModelRequest;
    }

    public static DeletePublisherAssertionsRequest getDeletePublisherAssertionsRequest(Collection collection, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        DeletePublisherAssertionsRequest deletePublisherAssertionsRequest = new DeletePublisherAssertionsRequest();
        if (collection != null) {
            for (Key key : collection) {
                try {
                    deletePublisherAssertionsRequest.addPublisherAssertion(UDDIBridgeMapperUtil.getPublisherAssertionFromAssociationKey(key, registryServiceImpl));
                }
                catch (UDDIException uDDIException) {
                    throw new JAXRException((Throwable)uDDIException);
                }
            }
        }
        return deletePublisherAssertionsRequest;
    }

    public static GetBusinessDetailRequest getBusinessDetailRequest(Collection collection) throws JAXRException {
        GetBusinessDetailRequest getBusinessDetailRequest = new GetBusinessDetailRequest();
        if (collection != null) {
            for (BusinessKey businessKey : collection) {
                getBusinessDetailRequest.addBusinessKey(businessKey);
            }
        }
        return getBusinessDetailRequest;
    }

    public static GetServiceDetailRequest getServiceDetailRequest(Collection collection) throws JAXRException {
        GetServiceDetailRequest getServiceDetailRequest = new GetServiceDetailRequest();
        if (collection != null) {
            for (ServiceKey serviceKey : collection) {
                getServiceDetailRequest.addServiceKey(serviceKey);
            }
        }
        return getServiceDetailRequest;
    }

    public static GetTModelDetailRequest getTModelDetailRequest(Collection collection) throws JAXRException {
        GetTModelDetailRequest getTModelDetailRequest = new GetTModelDetailRequest();
        if (collection != null) {
            for (TModelKey tModelKey : collection) {
                getTModelDetailRequest.addTModelKey(tModelKey);
            }
        }
        return getTModelDetailRequest;
    }
}

