/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.bridge.uddi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.datastructure.Address;
import weblogic.auddi.uddi.datastructure.AddressLine;
import weblogic.auddi.uddi.datastructure.AddressLines;
import weblogic.auddi.uddi.datastructure.Addresses;
import weblogic.auddi.uddi.datastructure.AssertionStatusItem;
import weblogic.auddi.uddi.datastructure.AssertionStatusItems;
import weblogic.auddi.uddi.datastructure.BindingTemplate;
import weblogic.auddi.uddi.datastructure.BindingTemplates;
import weblogic.auddi.uddi.datastructure.BusinessEntities;
import weblogic.auddi.uddi.datastructure.BusinessEntity;
import weblogic.auddi.uddi.datastructure.BusinessService;
import weblogic.auddi.uddi.datastructure.BusinessServices;
import weblogic.auddi.uddi.datastructure.CategoryBag;
import weblogic.auddi.uddi.datastructure.Contact;
import weblogic.auddi.uddi.datastructure.Contacts;
import weblogic.auddi.uddi.datastructure.DiscoveryURL;
import weblogic.auddi.uddi.datastructure.DiscoveryURLs;
import weblogic.auddi.uddi.datastructure.Email;
import weblogic.auddi.uddi.datastructure.Emails;
import weblogic.auddi.uddi.datastructure.HostingRedirector;
import weblogic.auddi.uddi.datastructure.IdentifierBag;
import weblogic.auddi.uddi.datastructure.InstanceDetails;
import weblogic.auddi.uddi.datastructure.InstanceParms;
import weblogic.auddi.uddi.datastructure.KeyedReference;
import weblogic.auddi.uddi.datastructure.Name;
import weblogic.auddi.uddi.datastructure.Names;
import weblogic.auddi.uddi.datastructure.OverviewDoc;
import weblogic.auddi.uddi.datastructure.Phone;
import weblogic.auddi.uddi.datastructure.Phones;
import weblogic.auddi.uddi.datastructure.ServiceKey;
import weblogic.auddi.uddi.datastructure.TModel;
import weblogic.auddi.uddi.datastructure.TModelInstanceDetails;
import weblogic.auddi.uddi.datastructure.TModelInstanceInfo;
import weblogic.auddi.uddi.datastructure.TModels;
import weblogic.auddi.uddi.datastructure.UDDIKey;
import weblogic.auddi.uddi.request.publish.DeleteBindingRequest;
import weblogic.auddi.uddi.request.publish.DeleteBusinessRequest;
import weblogic.auddi.uddi.request.publish.DeleteServiceRequest;
import weblogic.auddi.uddi.request.publish.DeleteTModelRequest;
import weblogic.auddi.uddi.response.BindingDetailResponse;
import weblogic.auddi.uddi.response.BusinessDetailResponse;
import weblogic.auddi.uddi.response.BusinessInfo;
import weblogic.auddi.uddi.response.BusinessInfos;
import weblogic.auddi.uddi.response.RelatedBusinessInfo;
import weblogic.auddi.uddi.response.RelatedBusinessInfos;
import weblogic.auddi.uddi.response.RelatedBusinessListResponse;
import weblogic.auddi.uddi.response.ServiceDetailResponse;
import weblogic.auddi.uddi.response.SharedRelationships;
import weblogic.auddi.uddi.response.TModelDetailResponse;
import weblogic.xml.jaxr.registry.BaseJAXRObject;
import weblogic.xml.jaxr.registry.BulkResponseImpl;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.bridge.uddi.UDDIBridgeMapperUtil;
import weblogic.xml.jaxr.registry.infomodel.AssociationImpl;
import weblogic.xml.jaxr.registry.infomodel.ExternalIdentifierImpl;
import weblogic.xml.jaxr.registry.infomodel.ExternalLinkImpl;
import weblogic.xml.jaxr.registry.infomodel.InternationalStringImpl;
import weblogic.xml.jaxr.registry.infomodel.KeyImpl;
import weblogic.xml.jaxr.registry.infomodel.UserImpl;
import weblogic.xml.jaxr.registry.provider.InternalClassificationSchemes;
import weblogic.xml.jaxr.registry.util.ClassificationSchemeHelper;

public class UDDIBridgeResponseMapper
extends BaseJAXRObject {
    public static final String SLOT_TYPE_STRING = "String";

    private UDDIBridgeResponseMapper() {
    }

    public static BulkResponse getBulkResponseForOrganizations(RegistryServiceImpl registryServiceImpl, BusinessEntities businessEntities) throws JAXRException {
        Collection collection = UDDIBridgeResponseMapper.getOrganizationsFromBusinessEntities(registryServiceImpl, businessEntities);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForAssociations(RegistryServiceImpl registryServiceImpl, RelatedBusinessListResponse relatedBusinessListResponse, boolean bl, Organization organization) throws JAXRException, UDDIException {
        Serializable serializable;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        RelatedBusinessInfos relatedBusinessInfos = relatedBusinessListResponse.getRelatedBusinessInfos();
        if (relatedBusinessInfos.size() > 0) {
            serializable = relatedBusinessInfos.getFirst();
            while (serializable != null) {
                Organization organization2;
                Object object;
                Object object2;
                SharedRelationships sharedRelationships2;
                BusinessEntity businessEntity = new BusinessEntity(((RelatedBusinessInfo)serializable).getBusinessKey());
                Names names = ((RelatedBusinessInfo)serializable).getNames();
                Serializable serializable2 = names.getFirst();
                while (serializable2 != null) {
                    businessEntity.addName((Name)serializable2);
                    serializable2 = names.getNext();
                }
                businessEntity.setDescriptions(((RelatedBusinessInfo)serializable).getDescriptions());
                serializable2 = new ArrayList();
                List list = ((RelatedBusinessInfo)serializable).getSharedRelationships();
                for (SharedRelationships sharedRelationships2 : list) {
                    object2 = sharedRelationships2.getFirst();
                    while (object2 != null) {
                        object = UDDIBridgeMapperUtil.getAssociationTypeFromAssertion((KeyedReference)object2, registryServiceImpl);
                        serializable2.add(object);
                        object2 = sharedRelationships2.getNext();
                    }
                }
                if (bl) {
                    organization2 = UDDIBridgeResponseMapper.getOrganization(registryServiceImpl, businessEntity);
                    sharedRelationships2 = organization;
                } else {
                    organization2 = organization;
                    sharedRelationships2 = UDDIBridgeResponseMapper.getOrganization(registryServiceImpl, businessEntity);
                }
                if (serializable2.size() == 0) {
                    object2 = (AssociationImpl)registryServiceImpl.getBusinessLifeCycleManager().createAssociation((RegistryObject)sharedRelationships2, null);
                    ((AssociationImpl)object2).setSourceObject((RegistryObject)organization2);
                    ((AssociationImpl)object2).setConfirmedBySourceOwner(true);
                    ((AssociationImpl)object2).setConfirmedByTargetOwner(true);
                    arrayList.add(object2);
                } else {
                    object2 = serializable2.iterator();
                    while (object2.hasNext()) {
                        object = (AssociationImpl)registryServiceImpl.getBusinessLifeCycleManager().createAssociation((RegistryObject)sharedRelationships2, null);
                        ((AssociationImpl)object).setSourceObject((RegistryObject)organization2);
                        ((AssociationImpl)object).setConfirmedBySourceOwner(true);
                        ((AssociationImpl)object).setConfirmedByTargetOwner(true);
                        Concept concept = (Concept)object2.next();
                        ((AssociationImpl)object).setAssociationType(concept);
                        arrayList.add(object);
                    }
                }
                serializable = relatedBusinessInfos.getNext();
            }
        }
        serializable = UDDIBridgeResponseMapper.getBulkResponseFromCollection(arrayList, registryServiceImpl);
        return serializable;
    }

    public static BulkResponse getBulkResponseForClassificationSchemes(RegistryServiceImpl registryServiceImpl, TModels tModels) throws JAXRException {
        Collection collection = UDDIBridgeResponseMapper.getClassificationSchemes(registryServiceImpl, tModels);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForConcepts(RegistryServiceImpl registryServiceImpl, TModels tModels) throws JAXRException {
        Collection collection = UDDIBridgeResponseMapper.getConcepts(registryServiceImpl, tModels);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForConceptsOrClassificationSchemes(RegistryServiceImpl registryServiceImpl, TModelDetailResponse tModelDetailResponse) throws JAXRException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TModels tModels = tModelDetailResponse.getTModels();
        Serializable serializable = tModels.getFirst();
        while (serializable != null) {
            if (UDDIBridgeMapperUtil.isConcept(serializable)) {
                arrayList.add(UDDIBridgeResponseMapper.getConcept(registryServiceImpl, serializable));
            } else {
                arrayList.add(UDDIBridgeResponseMapper.getClassificationScheme(registryServiceImpl, serializable));
            }
            serializable = tModels.getNext();
        }
        serializable = UDDIBridgeResponseMapper.getBulkResponseFromCollection(arrayList, registryServiceImpl);
        return serializable;
    }

    public static BulkResponse getBulkResponseForServiceBindings(RegistryServiceImpl registryServiceImpl, BindingDetailResponse bindingDetailResponse) throws JAXRException {
        BindingTemplates bindingTemplates = bindingDetailResponse.getBindingTemplates();
        Collection collection = UDDIBridgeResponseMapper.getServiceBindings(registryServiceImpl, bindingTemplates);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForServiceBindings(RegistryServiceImpl registryServiceImpl, BindingDetailResponse bindingDetailResponse, Collection collection) throws JAXRException {
        BindingTemplates bindingTemplates = bindingDetailResponse.getBindingTemplates();
        Collection collection2 = UDDIBridgeResponseMapper.getServiceBindings(registryServiceImpl, bindingTemplates, collection);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection2, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForServicesFromServiceDetailResponse(RegistryServiceImpl registryServiceImpl, ServiceDetailResponse serviceDetailResponse) throws JAXRException {
        BusinessServices businessServices = serviceDetailResponse.getBusinessServices();
        Collection collection = UDDIBridgeResponseMapper.getServices(registryServiceImpl, businessServices);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForKeysFromServiceDetailResponse(RegistryServiceImpl registryServiceImpl, ServiceDetailResponse serviceDetailResponse) throws JAXRException {
        BusinessServices businessServices = serviceDetailResponse.getBusinessServices();
        Collection collection = UDDIBridgeResponseMapper.getKeys((RegistryService)registryServiceImpl, businessServices);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForKeysFromDeleteBusinessRequest(RegistryServiceImpl registryServiceImpl, DeleteBusinessRequest deleteBusinessRequest) throws JAXRException {
        Collection collection = UDDIBridgeResponseMapper.getKeys((RegistryService)registryServiceImpl, deleteBusinessRequest.getBusinessKeys());
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForKeys(RegistryServiceImpl registryServiceImpl, Collection collection) throws JAXRException {
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForKeysFromDeleteServiceRequest(RegistryServiceImpl registryServiceImpl, DeleteServiceRequest deleteServiceRequest) throws JAXRException {
        ArrayList<ServiceKey> arrayList = new ArrayList<ServiceKey>();
        ServiceKey serviceKey = deleteServiceRequest.getFirst();
        while (null != serviceKey) {
            arrayList.add(serviceKey);
            serviceKey = deleteServiceRequest.getNext();
        }
        Collection collection = UDDIBridgeResponseMapper.getKeys((RegistryService)registryServiceImpl, arrayList);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForKeysFromDeleteBindingRequest(RegistryServiceImpl registryServiceImpl, DeleteBindingRequest deleteBindingRequest) throws JAXRException {
        Collection collection = UDDIBridgeResponseMapper.getKeys((RegistryService)registryServiceImpl, deleteBindingRequest.getBindingKeys());
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForKeysFromDeleteTModelRequest(RegistryServiceImpl registryServiceImpl, DeleteTModelRequest deleteTModelRequest) throws JAXRException {
        Collection collection = UDDIBridgeResponseMapper.getKeys((RegistryService)registryServiceImpl, deleteTModelRequest.getTModelKeys());
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForKeysFromBusinessDetailResponse(RegistryServiceImpl registryServiceImpl, BusinessDetailResponse businessDetailResponse) throws JAXRException {
        BusinessEntities businessEntities = businessDetailResponse.getBusinessEntities();
        Collection collection = UDDIBridgeResponseMapper.getKeys((RegistryService)registryServiceImpl, businessEntities);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForKeysFromBindingDetailResponse(RegistryServiceImpl registryServiceImpl, BindingDetailResponse bindingDetailResponse) throws JAXRException {
        BindingTemplates bindingTemplates = bindingDetailResponse.getBindingTemplates();
        Collection collection = UDDIBridgeResponseMapper.getKeys((RegistryService)registryServiceImpl, bindingTemplates);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static BulkResponse getBulkResponseForKeysFromTModelDetailResponse(RegistryServiceImpl registryServiceImpl, TModelDetailResponse tModelDetailResponse) throws JAXRException {
        TModels tModels = tModelDetailResponse.getTModels();
        Collection collection = UDDIBridgeResponseMapper.getKeys((RegistryService)registryServiceImpl, tModels);
        BulkResponseImpl bulkResponseImpl = UDDIBridgeResponseMapper.getBulkResponseFromCollection(collection, registryServiceImpl);
        return bulkResponseImpl;
    }

    public static Collection getKeys(RegistryService registryService, BusinessServices businessServices) throws JAXRException {
        ArrayList<Key> arrayList;
        if (businessServices == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Key>();
            BusinessService businessService = businessServices.getFirst();
            while (businessService != null) {
                arrayList.add(UDDIBridgeResponseMapper.getKey(registryService, businessService.getServiceKey()));
                businessService = businessServices.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getKeys(RegistryService registryService, BusinessInfos businessInfos) throws JAXRException {
        ArrayList<Key> arrayList;
        if (businessInfos == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Key>();
            BusinessInfo businessInfo = businessInfos.getFirst();
            while (businessInfo != null) {
                arrayList.add(UDDIBridgeResponseMapper.getKey(registryService, businessInfo.getBusinessKey()));
                businessInfo = businessInfos.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getKeys(RegistryService registryService, BusinessEntities businessEntities) throws JAXRException {
        ArrayList<Key> arrayList;
        if (businessEntities == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Key>();
            BusinessEntity businessEntity = businessEntities.getFirst();
            while (businessEntity != null) {
                arrayList.add(UDDIBridgeResponseMapper.getKey(registryService, businessEntity.getBusinessKey()));
                businessEntity = businessEntities.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getKeys(RegistryService registryService, ArrayList arrayList) throws JAXRException {
        ArrayList<Key> arrayList2;
        if (arrayList == null) {
            arrayList2 = Collections.EMPTY_LIST;
        } else {
            arrayList2 = new ArrayList<Key>();
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(UDDIBridgeResponseMapper.getKey(registryService, (UDDIKey)arrayList.get(i)));
            }
        }
        return arrayList2;
    }

    public static Collection getKeys(RegistryService registryService, BindingTemplates bindingTemplates) throws JAXRException {
        ArrayList<Key> arrayList;
        if (bindingTemplates == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Key>();
            BindingTemplate bindingTemplate = bindingTemplates.getFirst();
            while (bindingTemplate != null) {
                arrayList.add(UDDIBridgeResponseMapper.getKey(registryService, bindingTemplate.getBindingKey()));
                bindingTemplate = bindingTemplates.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getKeys(RegistryService registryService, TModels tModels) throws JAXRException {
        ArrayList<Key> arrayList;
        if (tModels == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Key>();
            TModel tModel = tModels.getFirst();
            while (tModel != null) {
                arrayList.add(UDDIBridgeResponseMapper.getKey(registryService, tModel.getTModelKey()));
                tModel = tModels.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getKeys(RegistryService registryService, DeleteServiceRequest deleteServiceRequest) throws JAXRException {
        ArrayList<Key> arrayList;
        if (deleteServiceRequest == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Key>();
            ServiceKey serviceKey = deleteServiceRequest.getFirst();
            while (serviceKey != null) {
                arrayList.add(UDDIBridgeResponseMapper.getKey(registryService, serviceKey));
                serviceKey = deleteServiceRequest.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getOrganizationsFromBusinessEntities(RegistryServiceImpl registryServiceImpl, BusinessEntities businessEntities) throws JAXRException {
        ArrayList<Organization> arrayList;
        if (businessEntities == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Organization>();
            BusinessEntity businessEntity = businessEntities.getFirst();
            while (businessEntity != null) {
                arrayList.add(UDDIBridgeResponseMapper.getOrganization(registryServiceImpl, businessEntity));
                businessEntity = businessEntities.getNext();
            }
        }
        return arrayList;
    }

    public static Organization getOrganization(RegistryServiceImpl registryServiceImpl, BusinessEntity businessEntity) throws JAXRException {
        Organization organization;
        if (businessEntity == null) {
            organization = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryServiceImpl.getBusinessLifeCycleManager();
            organization = businessLifeCycleManager.createOrganization(UDDIBridgeResponseMapper.getInternationalString(registryServiceImpl, businessEntity.getNames()));
            if (businessEntity.getBusinessKey() != null) {
                organization.setKey(UDDIBridgeResponseMapper.getKey(registryServiceImpl, businessEntity.getBusinessKey()));
            }
            if (businessEntity.getAuthorizedName() != null) {
                organization.addSlot(UDDIBridgeResponseMapper.getSlot(registryServiceImpl, "authorizedName", businessEntity.getAuthorizedName().getName(), SLOT_TYPE_STRING));
            }
            if (businessEntity.getOperator() != null) {
                organization.addSlot(UDDIBridgeResponseMapper.getSlot(registryServiceImpl, "operator", businessEntity.getOperator(), SLOT_TYPE_STRING));
            }
            if (businessEntity.getDiscoveryURLs() != null) {
                organization.setExternalLinks(UDDIBridgeResponseMapper.getExternalLinksFromDiscoveryURLs(registryServiceImpl, businessEntity.getDiscoveryURLs()));
            }
            if (businessEntity.getDescriptions() != null) {
                organization.setDescription(UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(businessEntity.getDescriptions(), registryServiceImpl));
            }
            if (businessEntity.getContacts() != null) {
                UDDIBridgeResponseMapper.setUsers(registryServiceImpl, businessEntity.getContacts(), organization);
            }
            if (businessEntity.getBusinessServices() != null) {
                organization.addServices(UDDIBridgeResponseMapper.getServices(registryServiceImpl, businessEntity.getBusinessServices()));
            }
            if (businessEntity.getIdentifierBag() != null) {
                organization.addExternalIdentifiers(UDDIBridgeResponseMapper.getExtenalIdentifiersFromIdentifierBag(registryServiceImpl, businessEntity.getIdentifierBag()));
            }
            if (businessEntity.getCategoryBag() != null) {
                Key key = organization.getKey();
                organization.addClassifications(UDDIBridgeResponseMapper.getClassificationsFromCategoryBag(registryServiceImpl, businessEntity.getCategoryBag(), key));
            }
        }
        return organization;
    }

    public static Key getKey(RegistryService registryService, UDDIKey uDDIKey) throws JAXRException {
        Key key;
        if (uDDIKey == null) {
            key = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            key = businessLifeCycleManager.createKey(uDDIKey.getKey());
        }
        return key;
    }

    public static User getPrimaryContact(RegistryServiceImpl registryServiceImpl, Contacts contacts, Organization organization) throws JAXRException {
        User user;
        if (contacts == null) {
            user = null;
        } else {
            user = UDDIBridgeResponseMapper.getUser(registryServiceImpl, contacts.getFirst());
            ((UserImpl)user).setSubmittingOrganization(organization);
        }
        return user;
    }

    public static void setUsers(RegistryServiceImpl registryServiceImpl, Contacts contacts, Organization organization) throws JAXRException {
        if (contacts != null) {
            Contact contact = contacts.getFirst();
            UserImpl userImpl = (UserImpl)UDDIBridgeResponseMapper.getUser(registryServiceImpl, contact);
            userImpl.setSubmittingOrganization(organization);
            organization.setPrimaryContact((User)userImpl);
            contact = contacts.getNext();
            while (contact != null) {
                UserImpl userImpl2 = (UserImpl)UDDIBridgeResponseMapper.getUser(registryServiceImpl, contact);
                userImpl2.setSubmittingOrganization(organization);
                organization.addUser((User)userImpl2);
                contact = contacts.getNext();
            }
        }
    }

    public static Collection getServices(RegistryService registryService, BusinessServices businessServices) throws JAXRException {
        ArrayList<Service> arrayList;
        if (businessServices == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Service>();
            BusinessService businessService = businessServices.getFirst();
            while (businessService != null) {
                arrayList.add(UDDIBridgeResponseMapper.getServiceFromBusinessService(registryService, businessService));
                businessService = businessServices.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getExtenalIdentifiersFromIdentifierBag(RegistryService registryService, IdentifierBag identifierBag) throws JAXRException {
        ArrayList<ExternalIdentifier> arrayList;
        if (identifierBag == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<ExternalIdentifier>();
            KeyedReference keyedReference = identifierBag.getFirst();
            while (keyedReference != null) {
                arrayList.add(UDDIBridgeResponseMapper.getExtenalIdentifierFromKeyedReference(registryService, keyedReference));
                keyedReference = identifierBag.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getClassificationsFromCategoryBag(RegistryService registryService, CategoryBag categoryBag, Key key) throws JAXRException {
        ArrayList<Classification> arrayList;
        if (categoryBag == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Classification>();
            KeyedReference keyedReference = categoryBag.getFirst();
            while (keyedReference != null) {
                arrayList.add(UDDIBridgeResponseMapper.getClassificationFromKeyedReference(registryService, keyedReference, key));
                keyedReference = categoryBag.getNext();
            }
        }
        return arrayList;
    }

    public static User getUser(RegistryServiceImpl registryServiceImpl, Contact contact) throws JAXRException {
        User user;
        if (contact == null) {
            user = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryServiceImpl.getBusinessLifeCycleManager();
            user = businessLifeCycleManager.createUser();
            if (null != contact.getUseType()) {
                user.setType(contact.getUseType());
            }
            if (null != contact.getDescriptions()) {
                user.setDescription(UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(contact.getDescriptions(), registryServiceImpl));
            }
            if (null != contact.getPersonName()) {
                user.setPersonName(UDDIBridgeResponseMapper.getPersonName(registryServiceImpl, contact.getPersonName()));
            }
            if (null != contact.getPhones()) {
                user.setTelephoneNumbers(UDDIBridgeResponseMapper.getTelephoneNumbers(registryServiceImpl, contact.getPhones()));
            }
            if (null != contact.getEmails()) {
                user.setEmailAddresses(UDDIBridgeResponseMapper.getEmailAddresses(registryServiceImpl, contact.getEmails()));
            }
            if (null != contact.getAddresses()) {
                user.setPostalAddresses(UDDIBridgeResponseMapper.getPostalAddresses(registryServiceImpl, contact.getAddresses()));
            }
        }
        return user;
    }

    public static PersonName getPersonName(RegistryService registryService, String string) throws JAXRException {
        PersonName personName;
        if (string == null) {
            personName = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            personName = businessLifeCycleManager.createPersonName(string);
        }
        return personName;
    }

    public static Collection getEmailAddresses(RegistryService registryService, Emails emails) throws JAXRException {
        ArrayList<EmailAddress> arrayList;
        if (emails == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<EmailAddress>();
            Email email = emails.getFirst();
            while (email != null) {
                arrayList.add(UDDIBridgeResponseMapper.getEmailAddress(registryService, email));
                email = emails.getNext();
            }
        }
        return arrayList;
    }

    public static EmailAddress getEmailAddress(RegistryService registryService, Email email) throws JAXRException {
        EmailAddress emailAddress;
        if (email == null) {
            emailAddress = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            emailAddress = businessLifeCycleManager.createEmailAddress(email.getEmail(), email.getUseType());
        }
        return emailAddress;
    }

    public static Collection getTelephoneNumbers(RegistryService registryService, Phones phones) throws JAXRException {
        ArrayList<TelephoneNumber> arrayList;
        if (phones == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<TelephoneNumber>();
            Phone phone = phones.getFirst();
            while (phone != null) {
                arrayList.add(UDDIBridgeResponseMapper.getTelephoneNumber(registryService, phone));
                phone = phones.getNext();
            }
        }
        return arrayList;
    }

    public static TelephoneNumber getTelephoneNumber(RegistryService registryService, Phone phone) throws JAXRException {
        TelephoneNumber telephoneNumber;
        if (phone == null) {
            telephoneNumber = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            telephoneNumber = businessLifeCycleManager.createTelephoneNumber();
            if (null != phone.getPhoneNumber()) {
                telephoneNumber.setNumber(phone.getPhoneNumber());
            }
            if (null != phone.getUseType()) {
                telephoneNumber.setType(phone.getUseType());
            }
        }
        return telephoneNumber;
    }

    public static Collection getPostalAddresses(RegistryServiceImpl registryServiceImpl, Addresses addresses) throws JAXRException {
        ArrayList<PostalAddress> arrayList;
        if (addresses == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<PostalAddress>();
            Address address = addresses.getFirst();
            while (address != null) {
                arrayList.add(UDDIBridgeResponseMapper.getPostalAddress(registryServiceImpl, address));
                address = addresses.getNext();
            }
        }
        return arrayList;
    }

    public static PostalAddress getPostalAddress(RegistryServiceImpl registryServiceImpl, Address address) throws JAXRException {
        PostalAddress postalAddress;
        if (address == null) {
            postalAddress = null;
        } else {
            Object object;
            Object object2;
            AddressLines addressLines;
            Object object3;
            BusinessLifeCycleManager businessLifeCycleManager = registryServiceImpl.getBusinessLifeCycleManager();
            postalAddress = (PostalAddress)businessLifeCycleManager.createObject("PostalAddress");
            if (address.getTModelKey() != null) {
                object3 = address.getTModelKey().getKey();
                addressLines = (ClassificationScheme)registryServiceImpl.getBusinessQueryManager().getRegistryObject((String)object3, "ClassificationScheme");
                if (addressLines != null) {
                    postalAddress.setPostalScheme((ClassificationScheme)addressLines);
                }
            }
            object3 = new ArrayList();
            addressLines = address.getAddressLines();
            ClassificationScheme classificationScheme = ClassificationSchemeHelper.getClassificationSchemeByName("PostalAddressAttributes", registryServiceImpl);
            AddressLine addressLine = addressLines.getFirst();
            while (addressLine != null) {
                boolean bl = false;
                object2 = postalAddress.getPostalScheme();
                object = addressLine.getKeyValue();
                if (object2 != null && object != null) {
                    for (Concept concept : object2.getChildrenConcepts()) {
                        Key key = concept.getKey();
                        if (!((String)object).equals(concept.getValue()) || key == null) continue;
                        Iterator iterator = classificationScheme.getChildrenConcepts().iterator();
                        if (UDDIBridgeResponseMapper.isSemanticMatch((Concept)iterator.next(), key.getId(), registryServiceImpl)) {
                            postalAddress.setStreetNumber(addressLine.getLine());
                            bl = true;
                            continue;
                        }
                        if (UDDIBridgeResponseMapper.isSemanticMatch((Concept)iterator.next(), key.getId(), registryServiceImpl)) {
                            postalAddress.setStreet(addressLine.getLine());
                            bl = true;
                            continue;
                        }
                        if (UDDIBridgeResponseMapper.isSemanticMatch((Concept)iterator.next(), key.getId(), registryServiceImpl)) {
                            postalAddress.setCity(addressLine.getLine());
                            bl = true;
                            continue;
                        }
                        if (UDDIBridgeResponseMapper.isSemanticMatch((Concept)iterator.next(), key.getId(), registryServiceImpl)) {
                            postalAddress.setStateOrProvince(addressLine.getLine());
                            bl = true;
                            continue;
                        }
                        if (UDDIBridgeResponseMapper.isSemanticMatch((Concept)iterator.next(), key.getId(), registryServiceImpl)) {
                            postalAddress.setPostalCode(addressLine.getLine());
                            bl = true;
                            continue;
                        }
                        if (UDDIBridgeResponseMapper.isSemanticMatch((Concept)iterator.next(), key.getId(), registryServiceImpl)) {
                            postalAddress.setCountry(addressLine.getLine());
                            bl = true;
                            continue;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    object3.add(addressLine);
                }
                addressLine = addressLines.getNext();
            }
            addressLine = registryServiceImpl.getBusinessLifeCycleManager();
            Slot slot = (Slot)addressLine.createObject("Slot");
            slot.setName("addressLines");
            slot.setSlotType(null);
            object2 = new ArrayList();
            object = object3.iterator();
            while (object.hasNext()) {
                AddressLine addressLine2 = (AddressLine)object.next();
                object2.add(addressLine2);
            }
            slot.setValues((Collection)object2);
            if (null != address.getSortCode()) {
                postalAddress.addSlot(UDDIBridgeResponseMapper.getSlot(registryServiceImpl, "sortCode", address.getSortCode(), null));
            }
            if (null != address.getUseType()) {
                postalAddress.setType(address.getUseType());
            }
        }
        return postalAddress;
    }

    public static Slot getSlot(RegistryService registryService, String string, String string2, String string3) throws JAXRException {
        BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
        Slot slot = businessLifeCycleManager.createSlot(string, string2, string3);
        return slot;
    }

    public static Service getServiceFromBusinessService(RegistryService registryService, BusinessService businessService) throws JAXRException {
        Service service2;
        if (businessService == null) {
            service2 = null;
        } else {
            Organization organization;
            Key key;
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            service2 = (Service)businessLifeCycleManager.createObject("Service");
            if (businessService.getBusinessKey() != null) {
                key = businessLifeCycleManager.createKey(businessService.getBusinessKey().getKey());
                organization = (Organization)businessLifeCycleManager.createObject("Organization");
                service2.setProvidingOrganization(organization);
                service2.getProvidingOrganization().setKey(key);
            }
            key = null;
            if (businessService.getServiceKey() != null) {
                key = businessLifeCycleManager.createKey(businessService.getServiceKey().getKey());
            }
            service2.setKey(key);
            if (null != businessService.getNames()) {
                service2.setName(UDDIBridgeResponseMapper.getInternationalString(registryService, businessService.getNames()));
            }
            if (null != businessService.getDescriptions()) {
                service2.setDescription(UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(businessService.getDescriptions(), registryService));
            }
            if (null != businessService.getBindingTemplates()) {
                service2.addServiceBindings(UDDIBridgeResponseMapper.getServiceBindings(registryService, businessService.getBindingTemplates()));
            }
            if (null != businessService.getCategoryBag()) {
                organization = service2.getKey();
                service2.addClassifications(UDDIBridgeResponseMapper.getClassificationsFromCategoryBag(registryService, businessService.getCategoryBag(), (Key)organization));
            }
        }
        return service2;
    }

    public static Collection getServiceBindings(RegistryService registryService, BindingTemplates bindingTemplates) throws JAXRException {
        ArrayList<ServiceBinding> arrayList;
        if (bindingTemplates == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<ServiceBinding>();
            BindingTemplate bindingTemplate = bindingTemplates.getFirst();
            while (bindingTemplate != null) {
                arrayList.add(UDDIBridgeResponseMapper.getServiceBinding(registryService, bindingTemplate));
                bindingTemplate = bindingTemplates.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getServiceBindings(RegistryService registryService, BindingTemplates bindingTemplates, Collection collection) throws JAXRException {
        ArrayList<ServiceBinding> arrayList;
        if (bindingTemplates == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<ServiceBinding>();
            BindingTemplate bindingTemplate = bindingTemplates.getFirst();
            while (bindingTemplate != null) {
                arrayList.add(UDDIBridgeResponseMapper.getServiceBinding(registryService, bindingTemplate, collection));
                bindingTemplate = bindingTemplates.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getConcepts(RegistryService registryService, TModels tModels) throws JAXRException {
        ArrayList<Concept> arrayList;
        if (tModels == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<Concept>();
            TModel tModel = tModels.getFirst();
            while (tModel != null) {
                arrayList.add(UDDIBridgeResponseMapper.getConcept(registryService, tModel));
                tModel = tModels.getNext();
            }
        }
        return arrayList;
    }

    public static Collection getClassificationSchemes(RegistryService registryService, TModels tModels) throws JAXRException {
        ArrayList<ClassificationScheme> arrayList;
        if (tModels == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<ClassificationScheme>();
            TModel tModel = tModels.getFirst();
            while (tModel != null) {
                arrayList.add(UDDIBridgeResponseMapper.getClassificationScheme(registryService, tModel));
                tModel = tModels.getNext();
            }
        }
        return arrayList;
    }

    public static Concept getConcept(RegistryService registryService, TModel tModel) throws JAXRException {
        Concept concept;
        if (tModel == null) {
            concept = null;
        } else {
            Slot slot;
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            concept = businessLifeCycleManager.createConcept(null, tModel.getName().getName(), null);
            if (null != tModel.getTModelKey()) {
                concept.setKey(businessLifeCycleManager.createKey(tModel.getTModelKey().getKey()));
            }
            if (null != tModel.getAuthorizedName()) {
                slot = businessLifeCycleManager.createSlot("authorizedName", tModel.getAuthorizedName().getName(), "authorizedName");
                concept.addSlot(slot);
            }
            if (null != tModel.getOperator()) {
                slot = businessLifeCycleManager.createSlot("operator", tModel.getOperator().getName(), "operator");
                concept.addSlot(slot);
            }
            if (null != tModel.getDescriptions()) {
                concept.setDescription(UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(tModel.getDescriptions(), registryService));
            }
            if (null != tModel.getOverviewDoc()) {
                concept.addExternalLink(UDDIBridgeResponseMapper.getExternalLinkFromOverviewDoc(registryService, tModel.getOverviewDoc()));
            }
            if (null != tModel.getCategoryBag()) {
                slot = concept.getKey();
                concept.setClassifications(UDDIBridgeResponseMapper.getClassificationsFromCategoryBag(registryService, tModel.getCategoryBag(), (Key)slot));
            }
            if (null != tModel.getIdentifierBag()) {
                concept.setExternalIdentifiers(UDDIBridgeResponseMapper.getExtenalIdentifiersFromIdentifierBag(registryService, tModel.getIdentifierBag()));
            }
        }
        return concept;
    }

    public static ClassificationScheme getClassificationScheme(RegistryService registryService, TModel tModel) throws JAXRException {
        ClassificationScheme classificationScheme;
        if (tModel == null) {
            classificationScheme = null;
        } else {
            Slot slot;
            RegistryServiceImpl registryServiceImpl = (RegistryServiceImpl)registryService;
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            KeyImpl keyImpl = (KeyImpl)businessLifeCycleManager.createKey(tModel.getTModelKey().getKey());
            InternalClassificationSchemes internalClassificationSchemes = registryServiceImpl.getRegistryProxy().getInternalClassificationSchemes();
            classificationScheme = internalClassificationSchemes.getClassificationSchemeByKey(keyImpl, registryServiceImpl);
            if (classificationScheme == null) {
                classificationScheme = businessLifeCycleManager.createClassificationScheme(tModel.getName().getName(), "");
                classificationScheme.setKey((Key)keyImpl);
            }
            if (null != tModel.getAuthorizedName()) {
                slot = businessLifeCycleManager.createSlot("authorizedName", tModel.getAuthorizedName().getName(), "authorizedName");
                classificationScheme.addSlot(slot);
            }
            if (null != tModel.getOperator()) {
                slot = businessLifeCycleManager.createSlot("operator", tModel.getOperator().getName(), "operator");
                classificationScheme.addSlot(slot);
            }
            if (null != tModel.getDescriptions()) {
                classificationScheme.setDescription(UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(tModel.getDescriptions(), registryService));
            }
            if (null != tModel.getOverviewDoc()) {
                classificationScheme.addExternalLink(UDDIBridgeResponseMapper.getExternalLinkFromOverviewDoc(registryService, tModel.getOverviewDoc()));
            }
            if (null != tModel.getCategoryBag()) {
                slot = classificationScheme.getKey();
                classificationScheme.setClassifications(UDDIBridgeResponseMapper.getClassificationsFromCategoryBag(registryService, tModel.getCategoryBag(), (Key)slot));
            }
            if (null != tModel.getIdentifierBag()) {
                classificationScheme.setExternalIdentifiers(UDDIBridgeResponseMapper.getExtenalIdentifiersFromIdentifierBag(registryService, tModel.getIdentifierBag()));
            }
        }
        return classificationScheme;
    }

    public static ServiceBinding getServiceBinding(RegistryService registryService, BindingTemplate bindingTemplate) throws JAXRException {
        ServiceBinding serviceBinding;
        if (bindingTemplate == null) {
            serviceBinding = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            serviceBinding = businessLifeCycleManager.createServiceBinding();
            serviceBinding.setKey(UDDIBridgeResponseMapper.getKey(registryService, bindingTemplate.getBindingKey()));
            serviceBinding.getService().setKey(UDDIBridgeResponseMapper.getKey(registryService, bindingTemplate.getServiceKey()));
            if (null != bindingTemplate.getDescriptions()) {
                serviceBinding.setDescription(UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(bindingTemplate.getDescriptions(), registryService));
            }
            if (null != bindingTemplate.getAccessPoint()) {
                serviceBinding.setAccessURI(bindingTemplate.getAccessPoint().getURL());
            }
            if (null != bindingTemplate.getHostingRedirector()) {
                serviceBinding.setTargetBinding(UDDIBridgeResponseMapper.getTargetBinding(registryService, bindingTemplate.getHostingRedirector()));
            }
            if (null != bindingTemplate.getTModelInstanceDetails()) {
                serviceBinding.addSpecificationLinks(UDDIBridgeResponseMapper.getSpecificationLinks(registryService, bindingTemplate.getTModelInstanceDetails()));
            }
            serviceBinding.setValidateURI(false);
        }
        return serviceBinding;
    }

    public static ServiceBinding getServiceBinding(RegistryService registryService, BindingTemplate bindingTemplate, Collection collection) throws JAXRException {
        ServiceBinding serviceBinding;
        if (bindingTemplate == null) {
            serviceBinding = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            serviceBinding = businessLifeCycleManager.createServiceBinding();
            serviceBinding.setKey(UDDIBridgeResponseMapper.getKey(registryService, bindingTemplate.getBindingKey()));
            serviceBinding.getService().setKey(UDDIBridgeResponseMapper.getKey(registryService, bindingTemplate.getServiceKey()));
            if (collection != null) {
                for (Service service2 : collection) {
                    if (!service2.getKey().equals(serviceBinding.getService().getKey())) continue;
                    service2.addServiceBinding(serviceBinding);
                    break;
                }
            }
            if (null != bindingTemplate.getDescriptions()) {
                serviceBinding.setDescription(UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(bindingTemplate.getDescriptions(), registryService));
            }
            if (null != bindingTemplate.getAccessPoint()) {
                serviceBinding.setAccessURI(bindingTemplate.getAccessPoint().getURL());
            }
            if (null != bindingTemplate.getHostingRedirector()) {
                serviceBinding.setTargetBinding(UDDIBridgeResponseMapper.getTargetBinding(registryService, bindingTemplate.getHostingRedirector()));
            }
            if (null != bindingTemplate.getTModelInstanceDetails()) {
                serviceBinding.addSpecificationLinks(UDDIBridgeResponseMapper.getSpecificationLinks(registryService, bindingTemplate.getTModelInstanceDetails()));
            }
            serviceBinding.setValidateURI(false);
        }
        return serviceBinding;
    }

    public static ServiceBinding getTargetBinding(RegistryService registryService, HostingRedirector hostingRedirector) throws JAXRException {
        ServiceBinding serviceBinding;
        if (hostingRedirector == null) {
            serviceBinding = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            serviceBinding = businessLifeCycleManager.createServiceBinding();
            if (null != hostingRedirector.getBindingKey()) {
                serviceBinding.setKey(UDDIBridgeResponseMapper.getKey(registryService, hostingRedirector.getBindingKey()));
            }
        }
        return serviceBinding;
    }

    public static Collection getSpecificationLinks(RegistryService registryService, TModelInstanceDetails tModelInstanceDetails) throws JAXRException {
        ArrayList<SpecificationLink> arrayList;
        if (tModelInstanceDetails == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<SpecificationLink>();
            TModelInstanceInfo tModelInstanceInfo = tModelInstanceDetails.getFirst();
            while (tModelInstanceInfo != null) {
                arrayList.add(UDDIBridgeResponseMapper.getSpecificationLink(registryService, tModelInstanceInfo));
                tModelInstanceInfo = tModelInstanceDetails.getNext();
            }
        }
        return arrayList;
    }

    public static SpecificationLink getSpecificationLink(RegistryService registryService, TModelInstanceInfo tModelInstanceInfo) throws JAXRException {
        SpecificationLink specificationLink;
        if (tModelInstanceInfo == null) {
            specificationLink = null;
        } else {
            Object object;
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            specificationLink = businessLifeCycleManager.createSpecificationLink();
            Concept concept = (Concept)businessLifeCycleManager.createObject("Concept");
            if (null != tModelInstanceInfo.getTModelKey()) {
                object = businessLifeCycleManager.createKey(tModelInstanceInfo.getTModelKey().getKey());
                concept.setKey((Key)object);
            }
            if (null != tModelInstanceInfo.getDescriptions()) {
                concept.setDescription(UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(tModelInstanceInfo.getDescriptions(), registryService));
            }
            specificationLink.setSpecificationObject((RegistryObject)concept);
            object = tModelInstanceInfo.getInstanceDetails();
            if (object != null) {
                if (null != ((InstanceDetails)object).getDescriptions()) {
                    specificationLink.setUsageDescription(UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(((InstanceDetails)object).getDescriptions(), registryService));
                }
                if (null != ((InstanceDetails)object).getInstanceParms()) {
                    specificationLink.setUsageParameters(UDDIBridgeResponseMapper.getUsageParameters(((InstanceDetails)object).getInstanceParms()));
                }
                if (null != ((InstanceDetails)object).getOverviewDoc()) {
                    specificationLink.addExternalLink(UDDIBridgeResponseMapper.getExternalLinkFromOverviewDoc(registryService, ((InstanceDetails)object).getOverviewDoc()));
                }
            }
        }
        return specificationLink;
    }

    public static Collection getUsageParameters(InstanceParms instanceParms) throws JAXRException {
        ArrayList<String> arrayList;
        if (instanceParms == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<String>();
            arrayList.add(instanceParms.toString());
        }
        return arrayList;
    }

    public static ExternalLink getExternalLinkFromOverviewDoc(RegistryService registryService, OverviewDoc overviewDoc) throws JAXRException {
        ExternalLink externalLink = null;
        if (overviewDoc == null) {
            externalLink = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            if (overviewDoc.getOverviewURL() != null) {
                String string = overviewDoc.getOverviewURL().toString();
                InternationalString internationalString = UDDIBridgeMapperUtil.getInternationalStringFromDescriptions(overviewDoc.getDescriptions(), registryService);
                externalLink = businessLifeCycleManager.createExternalLink(string, internationalString);
                String string2 = string + ":" + ((RegistryServiceImpl)registryService).getSequenceId();
                externalLink.setKey((Key)new KeyImpl(string2, (RegistryServiceImpl)registryService));
                externalLink.setValidateURI(false);
            }
        }
        return externalLink;
    }

    public static Collection getExternalLinksFromDiscoveryURLs(RegistryService registryService, DiscoveryURLs discoveryURLs) throws JAXRException {
        ArrayList<ExternalLink> arrayList;
        if (discoveryURLs == null) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            arrayList = new ArrayList<ExternalLink>();
            DiscoveryURL discoveryURL = discoveryURLs.getFirst();
            while (discoveryURL != null) {
                arrayList.add(UDDIBridgeResponseMapper.getExternalLink(registryService, discoveryURL));
                discoveryURL = discoveryURLs.getNext();
            }
        }
        return arrayList;
    }

    public static ExternalLink getExternalLink(RegistryService registryService, DiscoveryURL discoveryURL) throws JAXRException {
        ExternalLinkImpl externalLinkImpl;
        if (discoveryURL == null) {
            externalLinkImpl = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            externalLinkImpl = (ExternalLinkImpl)businessLifeCycleManager.createObject("ExternalLink");
            if (null != discoveryURL.getUrl()) {
                externalLinkImpl.setExternalURI(discoveryURL.getUrl(), false);
            }
            if (null != discoveryURL.getUseType()) {
                externalLinkImpl.setName(businessLifeCycleManager.createInternationalString(discoveryURL.getUseType()));
            }
        }
        return externalLinkImpl;
    }

    public static InternationalString getInternationalString(RegistryService registryService, Names names) throws JAXRException {
        InternationalString internationalString;
        if (names == null) {
            internationalString = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            internationalString = businessLifeCycleManager.createInternationalString();
            Name name = names.getFirst();
            while (name != null) {
                Locale locale = null;
                Locale locale2 = Locale.getDefault();
                locale = null == name.getLang() ? locale2 : (locale2.getLanguage().equals(name.getLang().toString()) ? locale2 : new Locale(name.getLang().toString(), ""));
                LocalizedString localizedString = businessLifeCycleManager.createLocalizedString(locale, name.getName());
                internationalString.addLocalizedString(localizedString);
                name = names.getNext();
            }
        }
        return internationalString;
    }

    public static ExternalIdentifier getExtenalIdentifierFromKeyedReference(RegistryService registryService, KeyedReference keyedReference) throws JAXRException {
        ExternalIdentifierImpl externalIdentifierImpl;
        if (keyedReference == null) {
            externalIdentifierImpl = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            ClassificationScheme classificationScheme = (ClassificationScheme)businessLifeCycleManager.createObject("ClassificationScheme");
            if (null != keyedReference.getTModelKey()) {
                classificationScheme.setKey(businessLifeCycleManager.createKey(keyedReference.getTModelKey().getKey()));
            }
            if (null != keyedReference.getName()) {
                classificationScheme.setName((InternationalString)new InternationalStringImpl(keyedReference.getName(), (RegistryServiceImpl)registryService));
            }
            externalIdentifierImpl = (ExternalIdentifierImpl)businessLifeCycleManager.createExternalIdentifier(classificationScheme, keyedReference.getName(), keyedReference.getValue());
            externalIdentifierImpl.createAndSetKey((RegistryServiceImpl)registryService);
        }
        return externalIdentifierImpl;
    }

    public static Classification getClassificationFromKeyedReference(RegistryService registryService, KeyedReference keyedReference, Key key) throws JAXRException {
        Classification classification;
        if (keyedReference == null) {
            classification = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            ClassificationScheme classificationScheme = (ClassificationScheme)businessLifeCycleManager.createObject("ClassificationScheme");
            if (null != keyedReference.getTModelKey()) {
                classificationScheme.setKey(businessLifeCycleManager.createKey(keyedReference.getTModelKey().getKey()));
            }
            classification = businessLifeCycleManager.createClassification(classificationScheme, keyedReference.getName(), keyedReference.getValue());
            String string = key.getId() + ":" + keyedReference.getTModelKey().getKey();
            if (classification.isExternal()) {
                string = string + ":" + classification.getValue();
            }
            classification.setKey((Key)new KeyImpl(string, (RegistryServiceImpl)registryService));
        }
        return classification;
    }

    public static BulkResponse getBulkResponseForAssociations(RegistryServiceImpl registryServiceImpl, AssertionStatusItems assertionStatusItems) throws JAXRException {
        ArrayList<Association> arrayList = new ArrayList<Association>();
        Serializable serializable = assertionStatusItems.getFirst();
        while (serializable != null) {
            Association association = UDDIBridgeResponseMapper.getAssociation(registryServiceImpl, serializable);
            arrayList.add(association);
            serializable = assertionStatusItems.getNext();
        }
        serializable = UDDIBridgeResponseMapper.getBulkResponseFromCollection(arrayList, registryServiceImpl);
        return serializable;
    }

    public static Association getAssociation(RegistryServiceImpl registryServiceImpl, AssertionStatusItem assertionStatusItem) throws JAXRException {
        Concept concept = UDDIBridgeMapperUtil.getAssociationTypeFromAssertion(assertionStatusItem.getKeyedReference(), registryServiceImpl);
        AssociationImpl associationImpl = (AssociationImpl)registryServiceImpl.getBusinessLifeCycleManager().createAssociation(null, concept);
        String string = null;
        if (assertionStatusItem.getCompletionStatus() != null) {
            string = assertionStatusItem.getCompletionStatus().getCompletionStatus();
        }
        if ("status:complete".equals(string)) {
            associationImpl.setConfirmedBySourceOwner(true);
            associationImpl.setConfirmedByTargetOwner(true);
        } else if ("status:fromKey_incomplete".equals(string)) {
            associationImpl.setConfirmedBySourceOwner(false);
            associationImpl.setConfirmedByTargetOwner(true);
        } else if ("status:toKey_incomplete".equals(string)) {
            associationImpl.setConfirmedBySourceOwner(true);
            associationImpl.setConfirmedByTargetOwner(false);
        } else {
            associationImpl.setConfirmedBySourceOwner(false);
            associationImpl.setConfirmedByTargetOwner(false);
        }
        return associationImpl;
    }

    static BulkResponseImpl getBulkResponseFromCollection(Collection collection, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        BulkResponseImpl bulkResponseImpl = new BulkResponseImpl(registryServiceImpl);
        bulkResponseImpl.setResponse(collection, null, false);
        return bulkResponseImpl;
    }

    static BulkResponseImpl getBulkResponseFromExceptions(JAXRException jAXRException, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        BulkResponseImpl bulkResponseImpl = new BulkResponseImpl(registryServiceImpl);
        ArrayList<JAXRException> arrayList = new ArrayList<JAXRException>();
        arrayList.add(jAXRException);
        bulkResponseImpl.setResponse(Collections.EMPTY_LIST, arrayList, false);
        return bulkResponseImpl;
    }

    private static boolean isSemanticMatch(Concept concept, String string, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        String string2 = registryServiceImpl.getSemanticEquivalent(concept.getKey().getId());
        return string2 != null && string2.equals(string);
    }
}

