/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.bridge.uddi;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import weblogic.auddi.uddi.UDDIException;
import weblogic.auddi.uddi.datastructure.CategoryBag;
import weblogic.auddi.uddi.datastructure.KeyedReference;
import weblogic.auddi.uddi.datastructure.TModel;
import weblogic.auddi.uddi.datastructure.TModelKey;
import weblogic.auddi.uddi.util.NodeItem;
import weblogic.auddi.uddi.util.StandardCategories;
import weblogic.auddi.uddi.util.XMLToTree;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.bridge.uddi.UDDIBridgeMapperUtil;
import weblogic.xml.jaxr.registry.infomodel.KeyImpl;
import weblogic.xml.jaxr.registry.provider.InternalClassificationSchemes;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;

public class UDDITaxonomies
implements InternalClassificationSchemes {
    public static final String ISO3166_ID = "uuid:4e49a8d6-d5a2-4fc2-93a0-0411d8d19e88";
    public static final String NAICS_ID = "uuid:c0b9fe13-179f-413d-8a5b-5004db8e5bb2";
    public static final String UNSPC_ID = "uuid:db77450d-9fa8-45d4-a7bc-04411d14e384";
    public static final String UDDI_ORG_TYPES_ID = "uuid:c1acf26d-9672-4404-9d70-39b756e62ab4";
    private static Map s_xmlToTreeMap;
    private static Map s_classificationSchemeMap;

    UDDITaxonomies() {
    }

    public ClassificationScheme getClassificationSchemeByKey(KeyImpl keyImpl, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        try {
            XMLToTree xMLToTree;
            ClassificationScheme classificationScheme = UDDITaxonomies.getCachedClassificationScheme(keyImpl);
            if (classificationScheme == null && (xMLToTree = UDDITaxonomies.getXMLToTree(keyImpl)) != null) {
                classificationScheme = UDDITaxonomies.getClassificationScheme(xMLToTree, registryServiceImpl);
                UDDITaxonomies.cacheClassificationScheme(classificationScheme);
            }
            return classificationScheme;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public ClassificationScheme getClassificationSchemeByName(String string, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        try {
            ClassificationScheme classificationScheme = null;
            XMLToTree[] xMLToTreeArray = UDDITaxonomies.getAllXMLToTrees();
            for (int i = 0; i < xMLToTreeArray.length && classificationScheme == null; ++i) {
                XMLToTree xMLToTree = xMLToTreeArray[i];
                String string2 = xMLToTree.getRoot().getUserObject().toString();
                if (!string2.equalsIgnoreCase(string)) continue;
                String string3 = xMLToTree.getKey();
                KeyImpl keyImpl = (KeyImpl)registryServiceImpl.getBusinessLifeCycleManager().createKey(string3);
                classificationScheme = this.getClassificationSchemeByKey(keyImpl, registryServiceImpl);
            }
            return classificationScheme;
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public void validateConcept(Concept concept, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        try {
            XMLToTree xMLToTree;
            KeyImpl keyImpl;
            if (concept != null && concept.getClassificationScheme() != null && (keyImpl = (KeyImpl)concept.getClassificationScheme().getKey()) != null && (xMLToTree = UDDITaxonomies.getXMLToTree(keyImpl)) != null && !xMLToTree.hasValue(concept.getValue())) {
                Object[] objectArray = new Object[]{concept.getValue(), keyImpl};
                String string = "jaxr.validation.taxonomy.category.invalidValue";
                String string2 = JAXRMessages.getMessage(string, objectArray);
                throw new InvalidRequestException(string2);
            }
        }
        catch (UDDIException uDDIException) {
            throw UDDIBridgeMapperUtil.mapException(uDDIException);
        }
    }

    public static boolean isClassificationScheme(TModel tModel) {
        boolean bl = false;
        if (tModel != null && tModel.getCategoryBag() != null) {
            CategoryBag categoryBag = tModel.getCategoryBag();
            KeyedReference keyedReference = categoryBag.getFirst();
            while (keyedReference != null && !bl) {
                TModelKey tModelKey = keyedReference.getTModelKey();
                if (tModelKey != null && tModelKey.getKey().equalsIgnoreCase(UDDI_ORG_TYPES_ID)) {
                    bl = bl || "identifier".equalsIgnoreCase(keyedReference.getValue());
                    bl = bl || "namespace".equalsIgnoreCase(keyedReference.getValue());
                    bl = bl || "categorization".equalsIgnoreCase(keyedReference.getValue());
                    bl = bl || "postalAddress".equalsIgnoreCase(keyedReference.getValue());
                }
                keyedReference = categoryBag.getNext();
            }
        }
        return bl;
    }

    private static void cacheClassificationScheme(ClassificationScheme classificationScheme) throws JAXRException {
        if (s_classificationSchemeMap == null) {
            s_classificationSchemeMap = new HashMap();
        }
        s_classificationSchemeMap.put(classificationScheme.getKey(), classificationScheme);
    }

    private static ClassificationScheme getCachedClassificationScheme(KeyImpl keyImpl) {
        ClassificationScheme classificationScheme = s_classificationSchemeMap == null ? null : (ClassificationScheme)s_classificationSchemeMap.get(keyImpl);
        return classificationScheme;
    }

    private static XMLToTree[] getAllXMLToTrees() throws UDDIException, JAXRException {
        if (s_xmlToTreeMap == null) {
            UDDITaxonomies.loadTaxonomies();
        }
        XMLToTree[] xMLToTreeArray = s_xmlToTreeMap.values().toArray(new XMLToTree[0]);
        return xMLToTreeArray;
    }

    private static XMLToTree getXMLToTree(KeyImpl keyImpl) throws UDDIException, JAXRException {
        if (s_xmlToTreeMap == null) {
            UDDITaxonomies.loadTaxonomies();
        }
        XMLToTree xMLToTree = (XMLToTree)s_xmlToTreeMap.get(keyImpl.getId().toLowerCase());
        return xMLToTree;
    }

    private static void loadTaxonomies() throws UDDIException, JAXRException {
        s_xmlToTreeMap = new HashMap();
        StandardCategories standardCategories = StandardCategories.getInstance();
        Map map = standardCategories.getItems();
        s_xmlToTreeMap.putAll(map);
    }

    private static ClassificationScheme getClassificationScheme(XMLToTree xMLToTree, RegistryService registryService) throws JAXRException {
        String string = xMLToTree.getRoot().getUserObject().toString();
        ClassificationScheme classificationScheme = registryService.getBusinessLifeCycleManager().createClassificationScheme(string, null);
        Key key = UDDITaxonomies.getKey(registryService, xMLToTree.getKey());
        classificationScheme.setKey(key);
        Enumeration<TreeNode> enumeration = xMLToTree.getRoot().children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Concept concept = UDDITaxonomies.getConcept(defaultMutableTreeNode, classificationScheme, (RegistryObject)classificationScheme, registryService);
            classificationScheme.addChildConcept(concept);
        }
        return classificationScheme;
    }

    private static Concept getConcept(DefaultMutableTreeNode defaultMutableTreeNode, ClassificationScheme classificationScheme, RegistryObject registryObject, RegistryService registryService) throws JAXRException {
        NodeItem nodeItem = (NodeItem)defaultMutableTreeNode.getUserObject();
        String string = nodeItem.getName();
        String string2 = nodeItem.getValue();
        Concept concept = registryService.getBusinessLifeCycleManager().createConcept(registryObject, string, string2);
        Key key = registryService.getBusinessLifeCycleManager().createKey(nodeItem.getKey());
        concept.setKey(key);
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Concept concept2 = UDDITaxonomies.getConcept(defaultMutableTreeNode2, classificationScheme, (RegistryObject)concept, registryService);
            concept.addChildConcept(concept2);
        }
        return concept;
    }

    private static Key getKey(RegistryService registryService, String string) throws JAXRException {
        Key key;
        if (string == null) {
            key = null;
        } else {
            BusinessLifeCycleManager businessLifeCycleManager = registryService.getBusinessLifeCycleManager();
            key = businessLifeCycleManager.createKey(string);
        }
        return key;
    }
}

