/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.command;

import java.util.ArrayList;
import java.util.Collections;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import weblogic.auddi.util.uuid.UUIDException;
import weblogic.auddi.util.uuid.UUIDGeneratorFactory;
import weblogic.xml.jaxr.registry.BulkResponseImpl;
import weblogic.xml.jaxr.registry.command.BulkQueryCommand;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class CommandHandler {
    public static BulkResponse runBulkQueryCommand(BulkQueryCommand bulkQueryCommand) throws JAXRException {
        try {
            BulkResponse bulkResponse;
            if (bulkQueryCommand.getRegistryServiceImpl().getConnectionImpl().isSynchronous()) {
                bulkResponse = bulkQueryCommand.execute();
            } else {
                bulkResponse = new BulkResponseImpl(bulkQueryCommand.getRegistryServiceImpl());
                String string = UUIDGeneratorFactory.getGenerator().uuidGen();
                ((BulkResponseImpl)bulkResponse).setRequestId(string);
                ((BulkResponseImpl)bulkResponse).setStatus(3);
                AsynchronousRequest asynchronousRequest = new AsynchronousRequest(bulkQueryCommand, (BulkResponseImpl)bulkResponse);
                asynchronousRequest.start();
                bulkQueryCommand.getRegistryServiceImpl().addBulkResponse(string, bulkResponse);
            }
            return bulkResponse;
        }
        catch (UUIDException uUIDException) {
            throw JAXRUtil.mapException(uUIDException);
        }
    }

    private static class AsynchronousRequest
    extends Thread {
        private BulkQueryCommand m_bulkQueryCommand;
        private BulkResponseImpl m_bulkResponseImpl;

        public AsynchronousRequest(BulkQueryCommand bulkQueryCommand, BulkResponseImpl bulkResponseImpl) {
            this.m_bulkQueryCommand = bulkQueryCommand;
            this.m_bulkResponseImpl = bulkResponseImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BulkResponse bulkResponse;
            try {
                bulkResponse = this.m_bulkQueryCommand.execute();
            }
            catch (JAXRException jAXRException) {
                ArrayList<JAXRException> arrayList = new ArrayList<JAXRException>();
                arrayList.add(jAXRException);
                bulkResponse = new BulkResponseImpl(this.m_bulkQueryCommand.getRegistryServiceImpl());
                ((BulkResponseImpl)bulkResponse).setResponse(Collections.EMPTY_LIST, arrayList, false);
            }
            try {
                this.m_bulkResponseImpl.setResponse(bulkResponse.getCollection(), bulkResponse.getExceptions(), bulkResponse.isPartialResponse());
                BulkResponseImpl bulkResponseImpl = this.m_bulkResponseImpl;
                synchronized (bulkResponseImpl) {
                    this.m_bulkResponseImpl.notify();
                }
            }
            catch (JAXRException jAXRException) {
                System.out.println("Log: could not complete asynchronous query of " + this.m_bulkQueryCommand);
            }
        }
    }
}

