/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryObject;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.ConceptImpl;
import weblogic.xml.jaxr.registry.infomodel.KeyImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryObjectImpl;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;

public class AssociationImpl
extends RegistryObjectImpl
implements Association {
    private RegistryObject m_sourceObject;
    private RegistryObject m_targetObject;
    private ConceptImpl m_associationType;
    private boolean m_confirmedBySourceOwner;
    private boolean m_confirmedByTargetOwner;
    private static final long serialVersionUID = -1L;

    public AssociationImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
    }

    public AssociationImpl(Association association, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryObject)association, registryServiceImpl);
        if (association != null) {
            this.m_sourceObject = new RegistryObjectImpl(association.getSourceObject(), registryServiceImpl);
            this.m_targetObject = new RegistryObjectImpl(association.getTargetObject(), registryServiceImpl);
            this.m_associationType = new ConceptImpl(association.getAssociationType(), registryServiceImpl);
            this.m_confirmedBySourceOwner = association.isConfirmedBySourceOwner();
            this.m_confirmedByTargetOwner = association.isConfirmedByTargetOwner();
        }
    }

    public RegistryObject getSourceObject() throws JAXRException {
        return this.m_sourceObject;
    }

    public void setSourceObject(RegistryObject registryObject) throws JAXRException {
        this.m_sourceObject = registryObject;
        this.createAndSetKey();
    }

    public RegistryObject getTargetObject() throws JAXRException {
        return this.m_targetObject;
    }

    public void setTargetObject(RegistryObject registryObject) throws JAXRException {
        this.m_targetObject = registryObject;
        this.createAndSetKey();
    }

    public Concept getAssociationType() throws JAXRException {
        return this.m_associationType;
    }

    public void setAssociationType(Concept concept) throws JAXRException {
        this.m_associationType = (ConceptImpl)concept;
        this.createAndSetKey();
    }

    public boolean isExtramural() throws JAXRException {
        if (this.m_sourceObject == null || this.m_targetObject == null) {
            String string = JAXRMessages.getMessage("jaxr.registry.registryServiceImpl.invalidSourceORTarget");
            throw new InvalidRequestException(string);
        }
        String string = this.getRegistryObjectOwner(this.m_sourceObject);
        String string2 = this.getRegistryObjectOwner(this.m_targetObject);
        boolean bl = string == null && string2 == null ? false : (string != null ? !string.equals(string2) : true);
        return bl;
    }

    public boolean isIntramural() throws JAXRException {
        if (this.m_sourceObject == null || this.m_targetObject == null) {
            String string = JAXRMessages.getMessage("jaxr.registry.registryServiceImpl.invalidSourceORTarget");
            throw new InvalidRequestException(string);
        }
        String string = this.getRegistryObjectOwner(this.m_sourceObject);
        String string2 = this.getRegistryObjectOwner(this.m_targetObject);
        String string3 = this.getRegistryObjectOwner(this);
        boolean bl = string3 == null ? string == null && string2 == null : (string != null ? string.equals(string2) && string.equals(string3) : false);
        return bl;
    }

    public boolean isConfirmedBySourceOwner() throws JAXRException {
        if (this.m_sourceObject == null || this.m_targetObject == null) {
            String string = JAXRMessages.getMessage("jaxr.registry.registryServiceImpl.invalidSourceORTarget");
            throw new InvalidRequestException(string);
        }
        if (this.haveSameOwner(this.m_sourceObject, this.m_targetObject)) {
            this.m_confirmedBySourceOwner = true;
        }
        return this.m_confirmedBySourceOwner;
    }

    public void setConfirmedBySourceOwner(boolean bl) throws JAXRException {
        this.m_confirmedBySourceOwner = bl;
    }

    public boolean isConfirmedByTargetOwner() throws JAXRException {
        if (this.m_sourceObject == null || this.m_targetObject == null) {
            String string = JAXRMessages.getMessage("jaxr.registry.registryServiceImpl.invalidSourceORTarget");
            throw new InvalidRequestException(string);
        }
        if (this.haveSameOwner(this.m_sourceObject, this.m_targetObject)) {
            this.m_confirmedByTargetOwner = true;
        }
        return this.m_confirmedByTargetOwner;
    }

    public void setConfirmedByTargetOwner(boolean bl) throws JAXRException {
        this.m_confirmedByTargetOwner = bl;
    }

    public boolean isConfirmed() throws JAXRException {
        boolean bl = this.isIntramural() ? true : this.isConfirmedBySourceOwner() && this.isConfirmedByTargetOwner();
        return bl;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_sourceObject, this.m_targetObject, this.m_associationType, new Boolean(this.m_confirmedBySourceOwner), new Boolean(this.m_confirmedByTargetOwner)};
        Object[] objectArray2 = AssociationImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_sourceObject", "m_targetObject", "m_associationType", "m_confirmedBySourceOwner", "m_confirmedByTargetOwner"};
        String[] stringArray2 = AssociationImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    private String getRegistryObjectOwner(RegistryObject registryObject) throws JAXRException {
        return this.getRegistryService().getRegistryProxy().getRegistryObjectOwner(registryObject);
    }

    private boolean haveSameOwner(RegistryObject registryObject, RegistryObject registryObject2) throws JAXRException {
        String string;
        boolean bl = false;
        String string2 = this.getRegistryObjectOwner(registryObject);
        if (string2 == null) {
            string2 = this.getRegistryService().getCurrentUser();
        }
        if ((string = this.getRegistryObjectOwner(registryObject2)) == null) {
            string = this.getRegistryService().getCurrentUser();
        }
        if (string2 == null) {
            if (string == null) {
                bl = true;
            }
        } else if (string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private void createAndSetKey() throws JAXRException {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.m_sourceObject != null && this.m_sourceObject.getKey() != null) {
            string = this.m_sourceObject.getKey().getId();
        }
        if (this.m_targetObject != null && this.m_targetObject.getKey() != null) {
            string2 = this.m_targetObject.getKey().getId();
        }
        if (this.m_associationType != null) {
            string3 = this.m_associationType.getValue();
        }
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append(string);
        stringBuffer.append(":");
        stringBuffer.append(string2);
        stringBuffer.append(":");
        stringBuffer.append(string3);
        KeyImpl keyImpl = new KeyImpl(stringBuffer.toString(), this.getRegistryService());
        this.setKey(keyImpl);
    }
}

