/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.RegistryObject;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.ClassificationSchemeImpl;
import weblogic.xml.jaxr.registry.infomodel.ConceptImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryObjectImpl;
import weblogic.xml.jaxr.registry.util.ClassificationSchemeHelper;

public class ClassificationImpl
extends RegistryObjectImpl
implements Classification {
    private static final long serialVersionUID = -1L;
    private ConceptImpl m_concept;
    private ClassificationSchemeImpl m_classificationScheme;
    private String m_value;
    private RegistryObjectImpl m_classifiedObject;

    public ClassificationImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
    }

    public ClassificationImpl(Classification classification, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryObject)classification, registryServiceImpl);
        if (classification != null) {
            this.m_concept = new ConceptImpl(classification.getConcept(), registryServiceImpl);
            this.m_value = classification.getValue();
        }
    }

    public Concept getConcept() throws JAXRException {
        return this.m_concept;
    }

    public void setConcept(Concept concept) throws JAXRException {
        ClassificationSchemeHelper.validateConcept(concept, this.getRegistryService());
        this.m_concept = (ConceptImpl)concept;
    }

    public ClassificationScheme getClassificationScheme() throws JAXRException {
        if (this.isExternal()) {
            return this.m_classificationScheme;
        }
        return this.getConcept().getClassificationScheme();
    }

    public void setClassificationScheme(ClassificationScheme classificationScheme) throws JAXRException {
        this.m_classificationScheme = (ClassificationSchemeImpl)classificationScheme;
    }

    public String getValue() throws JAXRException {
        if (this.isExternal()) {
            return this.m_value;
        }
        return this.getConcept().getValue();
    }

    public void setValue(String string) throws JAXRException {
        this.m_value = string;
    }

    public RegistryObject getClassifiedObject() throws JAXRException {
        return this.m_classifiedObject;
    }

    public void setClassifiedObject(RegistryObject registryObject) throws JAXRException {
        this.m_classifiedObject = (RegistryObjectImpl)registryObject;
    }

    public boolean isExternal() {
        return this.m_concept == null;
    }

    public InternationalString getName() {
        if (this.isExternal()) {
            return super.getName();
        }
        return this.m_concept.getName();
    }

    protected Object[] getDefiningElements() {
        String string = this.m_classificationScheme == null ? "null" : this.m_classificationScheme.getName().toString();
        String string2 = this.m_classifiedObject == null ? "null" : this.m_classifiedObject.getName().toString();
        Object[] objectArray = new Object[]{this.m_concept, string, this.m_value, string2};
        Object[] objectArray2 = ClassificationImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_concept", "m_classificationScheme.Name", "m_value", "m_classifiedObject.Name"};
        String[] stringArray2 = ClassificationImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }
}

