/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.RegistryEntry;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.ConceptImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryEntryImpl;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class ClassificationSchemeImpl
extends RegistryEntryImpl
implements ClassificationScheme {
    private static final long serialVersionUID = -1L;
    private ArrayList m_children = new ArrayList();

    public ClassificationSchemeImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        registryServiceImpl.getRegistryProxy().setRegistryObjectOwner(this, registryServiceImpl.getCurrentUser());
    }

    public ClassificationSchemeImpl(ClassificationScheme classificationScheme, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryEntry)classificationScheme, registryServiceImpl);
        registryServiceImpl.getRegistryProxy().setRegistryObjectOwner(this, registryServiceImpl.getCurrentUser());
        JAXRUtil.verifyNotNull(classificationScheme, ClassificationScheme.class);
        Collection collection = classificationScheme.getChildrenConcepts();
        this.addChildConcepts(collection);
    }

    public ClassificationSchemeImpl(Concept concept, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        registryServiceImpl.getRegistryProxy().setRegistryObjectOwner(this, registryServiceImpl.getCurrentUser());
        this.setKey(concept.getKey());
        this.setName(concept.getName());
        this.setDescription(concept.getDescription());
        this.addChildConcepts(concept.getChildrenConcepts());
    }

    public void addChildConcept(Concept concept) throws JAXRException {
        if (concept != null && !this.m_children.contains(concept)) {
            ((ConceptImpl)concept).setClassificationScheme(this);
            this.m_children.add(concept);
        }
    }

    public void addChildConcepts(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Concept.class);
        for (Concept concept : collection) {
            this.addChildConcept(concept);
        }
    }

    public void removeChildConcept(Concept concept) throws JAXRException {
        if (concept != null) {
            this.m_children.remove(concept);
        }
    }

    public void removeChildConcepts(Collection collection) throws JAXRException {
        if (collection != null) {
            this.m_children.removeAll(collection);
        }
    }

    public int getChildConceptCount() throws JAXRException {
        return this.m_children.size();
    }

    public Collection getChildrenConcepts() throws JAXRException {
        return this.m_children;
    }

    public Collection getDescendantConcepts() throws JAXRException {
        ArrayList arrayList = new ArrayList(this.m_children);
        for (Concept concept : this.m_children) {
            if (concept.getChildConceptCount() <= 0) continue;
            arrayList.addAll(concept.getDescendantConcepts());
        }
        return arrayList;
    }

    public boolean isExternal() throws JAXRException {
        return this.m_children.size() == 0;
    }

    public int getValueType() throws JAXRException {
        this.checkCapability(1);
        return 0;
    }

    public void setValueType(int n) throws JAXRException {
        this.checkCapability(1);
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_children};
        Object[] objectArray2 = ClassificationSchemeImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_children"};
        String[] stringArray2 = ClassificationSchemeImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }
}

