/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.RegistryObject;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.ClassificationSchemeImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryObjectImpl;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class ConceptImpl
extends RegistryObjectImpl
implements Concept {
    private static final long serialVersionUID = -1L;
    private String m_value;
    private ArrayList m_children = new ArrayList();
    private ConceptImpl m_parentConcept;
    private ClassificationSchemeImpl m_classificationScheme;

    public ConceptImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        registryServiceImpl.getRegistryProxy().setRegistryObjectOwner(this, registryServiceImpl.getCurrentUser());
    }

    public ConceptImpl(Concept concept, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryObject)concept, registryServiceImpl);
        registryServiceImpl.getRegistryProxy().setRegistryObjectOwner(this, registryServiceImpl.getCurrentUser());
        if (concept != null) {
            this.m_value = concept.getValue();
            Collection collection = concept.getChildrenConcepts();
            this.addChildConcepts(collection);
        }
    }

    public ConceptImpl(RegistryObject registryObject, InternationalString internationalString, String string, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        registryServiceImpl.getRegistryProxy().setRegistryObjectOwner(this, registryServiceImpl.getCurrentUser());
        this.setName(internationalString);
        this.setValue(string);
        if (registryObject instanceof ClassificationScheme) {
            ((ClassificationScheme)registryObject).addChildConcept((Concept)this);
        } else if (registryObject instanceof Concept) {
            ((Concept)registryObject).addChildConcept((Concept)this);
        }
    }

    public String getValue() throws JAXRException {
        return this.m_value;
    }

    public void setValue(String string) throws JAXRException {
        this.m_value = string;
    }

    public void addChildConcept(Concept concept) throws JAXRException {
        if (concept != null && !this.m_children.contains(concept)) {
            ((ConceptImpl)concept).setParentConcept(this);
            this.m_children.add(concept);
        }
    }

    public void addChildConcepts(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Concept.class);
        for (Concept concept : collection) {
            this.addChildConcept(concept);
        }
    }

    public void removeChildConcept(Concept concept) throws JAXRException {
        if (concept != null) {
            this.m_children.remove(concept);
        }
    }

    public void removeChildConcepts(Collection collection) throws JAXRException {
        if (collection != null) {
            this.m_children.removeAll(collection);
        }
    }

    public int getChildConceptCount() throws JAXRException {
        return this.m_children.size();
    }

    public Collection getChildrenConcepts() throws JAXRException {
        return this.m_children;
    }

    public Collection getDescendantConcepts() throws JAXRException {
        ArrayList arrayList = new ArrayList(this.m_children);
        for (Concept concept : this.m_children) {
            if (concept.getChildConceptCount() <= 0) continue;
            arrayList.addAll(concept.getDescendantConcepts());
        }
        return arrayList;
    }

    public Concept getParentConcept() throws JAXRException {
        return this.m_parentConcept;
    }

    public ClassificationScheme getClassificationScheme() throws JAXRException {
        return this.m_classificationScheme;
    }

    public String getPath() throws JAXRException {
        if (this.m_parentConcept == null) {
            return "/" + this.m_classificationScheme.getKey().getId() + "/" + this.m_value;
        }
        return this.m_parentConcept.getPath() + "/" + this.m_value;
    }

    public RegistryObject getParent() throws JAXRException {
        if (this.m_parentConcept != null) {
            return this.m_parentConcept;
        }
        return this.m_classificationScheme;
    }

    public void setClassificationScheme(ClassificationSchemeImpl classificationSchemeImpl) {
        this.m_classificationScheme = classificationSchemeImpl;
    }

    private void setParentConcept(ConceptImpl conceptImpl) {
        this.m_parentConcept = conceptImpl;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_value, this.getName(this.m_children), this.getName(this.m_parentConcept), this.getName(this.m_classificationScheme)};
        Object[] objectArray2 = ConceptImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_value", "m_children.Name", "m_parentConcept.Name", "m_classificationScheme.Name"};
        String[] stringArray2 = ConceptImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }
}

