/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ExtensibleObject;
import javax.xml.registry.infomodel.Slot;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.BaseInfoModelObject;
import weblogic.xml.jaxr.registry.infomodel.SlotImpl;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public abstract class ExtensibleObjectImpl
extends BaseInfoModelObject
implements ExtensibleObject {
    private Map m_slots = new HashMap();
    private static final long serialVersionUID = -1L;

    protected ExtensibleObjectImpl(RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
    }

    protected ExtensibleObjectImpl(ExtensibleObject extensibleObject, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        this(registryServiceImpl);
        if (extensibleObject != null) {
            Iterator iterator = extensibleObject.getSlots().iterator();
            this.m_slots = new HashMap();
            while (iterator.hasNext()) {
                Slot slot = (Slot)iterator.next();
                SlotImpl slotImpl = new SlotImpl(slot, registryServiceImpl);
                this.m_slots.put(slotImpl.getName(), slotImpl);
            }
        }
    }

    public void addSlot(Slot slot) throws JAXRException {
        if (this.isInvalidSlot(slot)) {
            String string = JAXRMessages.getMessage("jaxr.extensibleObject.invalidSlot", new Object[]{slot});
            throw new InvalidRequestException(string);
        }
        this.m_slots.put(slot.getName(), slot);
    }

    public void addSlots(Collection collection) throws JAXRException {
        if (collection == null) {
            String string = JAXRMessages.getMessage("jaxr.extensibleObject.invalidSlot", new Object[]{collection});
            throw new InvalidRequestException(string);
        }
        for (Slot slot : collection) {
            this.addSlot(slot);
        }
    }

    public void removeSlot(String string) throws JAXRException {
        if (string == null) {
            String string2 = JAXRMessages.getMessage("jaxr.extensibleObject.invalidSlot", new Object[]{string});
            throw new InvalidRequestException(string2);
        }
        this.m_slots.remove(string);
    }

    public void removeSlots(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, String.class);
        for (String string : collection) {
            this.removeSlot(string);
        }
    }

    public Slot getSlot(String string) throws JAXRException {
        if (string == null || string.length() == 0) {
            String string2 = JAXRMessages.getMessage("jaxr.extensibleObject.invalidSlot", new Object[]{string});
            throw new InvalidRequestException(string2);
        }
        return (Slot)this.m_slots.get(string);
    }

    public Collection getSlots() throws JAXRException {
        ArrayList arrayList = new ArrayList(this.m_slots.values());
        return arrayList;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_slots};
        Object[] objectArray2 = ExtensibleObjectImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_slots"};
        String[] stringArray2 = ExtensibleObjectImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    private boolean isInvalidSlot(Slot slot) throws JAXRException {
        return slot == null || slot.getName() == null || slot.getName().length() == 0;
    }
}

