/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.RegistryObject;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.KeyImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryObjectImpl;
import weblogic.xml.jaxr.registry.infomodel.URIValidatorImpl;

public class ExternalLinkImpl
extends RegistryObjectImpl
implements ExternalLink {
    private static final long serialVersionUID = -1L;
    private URIValidatorImpl m_validator;
    private ArrayList m_registryObjects = new ArrayList();
    private String m_externalURI;

    public ExternalLinkImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        this.m_validator = new URIValidatorImpl(registryServiceImpl);
    }

    public ExternalLinkImpl(ExternalLink externalLink, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryObject)externalLink, registryServiceImpl);
        if (externalLink != null) {
            this.m_validator = new URIValidatorImpl(registryServiceImpl);
            this.setValidateURI(externalLink.getValidateURI());
            this.duplicateParentKeys(externalLink, registryServiceImpl);
            this.setExternalURI(externalLink.getExternalURI());
        }
    }

    public void setValidateURI(boolean bl) throws JAXRException {
        this.m_validator.setValidateURI(bl);
    }

    public boolean getValidateURI() throws JAXRException {
        return this.m_validator.getValidateURI();
    }

    public Collection getLinkedObjects() throws JAXRException {
        return this.m_registryObjects;
    }

    public void addLinkedObject(RegistryObject registryObject) throws JAXRException {
        this.m_registryObjects.add(registryObject);
    }

    public String getExternalURI() throws JAXRException {
        return this.m_externalURI;
    }

    public void setExternalURI(String string) throws JAXRException {
        this.setExternalURI(string, false);
    }

    public void setExternalURI(String string, boolean bl) throws JAXRException {
        if (bl) {
            this.m_validator.validate(string);
        }
        this.m_externalURI = string;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_validator, this.getNames(this.m_registryObjects), this.m_externalURI};
        Object[] objectArray2 = ExternalLinkImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_validator", "m_registryObjects.Names", "m_externalURI"};
        String[] stringArray2 = ExternalLinkImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    private void duplicateParentKeys(ExternalLink externalLink, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        Collection collection = externalLink.getLinkedObjects();
        for (RegistryObject registryObject : collection) {
            if (registryObject == null) continue;
            RegistryObjectImpl registryObjectImpl = new RegistryObjectImpl(registryServiceImpl);
            if (registryObject.getKey() != null) {
                KeyImpl keyImpl = new KeyImpl(registryObject.getKey(), registryServiceImpl);
                registryObjectImpl.setKey(keyImpl);
            }
            this.m_registryObjects.add(registryObjectImpl);
        }
    }
}

