/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.LocalizedString;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.BaseInfoModelObject;
import weblogic.xml.jaxr.registry.infomodel.LocalizedStringImpl;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class InternationalStringImpl
extends BaseInfoModelObject
implements InternationalString {
    private static final long serialVersionUID = -1L;
    static final String DEFAULT_CHARSET = "UTF-8";
    private Map m_strings;

    public InternationalStringImpl(RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
        this.m_strings = new HashMap();
    }

    public InternationalStringImpl(InternationalString internationalString, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        Collection collection;
        if (internationalString != null && (collection = internationalString.getLocalizedStrings()) != null) {
            Iterator iterator = collection.iterator();
            this.m_strings = new HashMap();
            while (iterator.hasNext()) {
                LocalizedString localizedString = (LocalizedString)iterator.next();
                LocalizedStringImpl localizedStringImpl = new LocalizedStringImpl(localizedString, registryServiceImpl);
                String string = this.makeKey(localizedString.getCharsetName(), localizedString.getLocale());
                this.m_strings.put(string, localizedStringImpl);
            }
        }
    }

    public InternationalStringImpl(LocalizedString localizedString, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        this(registryServiceImpl);
        String string = this.makeKey(localizedString.getCharsetName(), localizedString.getLocale());
        this.m_strings.put(string, localizedString);
    }

    public InternationalStringImpl(Locale locale, String string, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        this(registryServiceImpl);
        String string2 = this.makeKey(DEFAULT_CHARSET, locale);
        this.m_strings.put(string2, new LocalizedStringImpl(locale, string, registryServiceImpl));
    }

    public InternationalStringImpl(String string, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        this(Locale.getDefault(), string, registryServiceImpl);
    }

    public String getValue() throws JAXRException {
        return this.getValue(Locale.getDefault());
    }

    public String getValue(Locale locale) throws JAXRException {
        if (locale == null) {
            return null;
        }
        String string = this.makeKey(DEFAULT_CHARSET, locale);
        LocalizedString localizedString = (LocalizedString)this.m_strings.get(string);
        return localizedString != null ? localizedString.getValue() : null;
    }

    public void setValue(String string) throws JAXRException {
        this.setValue(Locale.getDefault(), string);
    }

    public void setValue(Locale locale, String string) throws JAXRException {
        String string2 = this.makeKey(DEFAULT_CHARSET, locale);
        this.m_strings.put(string2, new LocalizedStringImpl(locale, string, this.getRegistryService()));
    }

    public void addLocalizedString(LocalizedString localizedString) throws JAXRException {
        if (localizedString == null) {
            throw new JAXRException();
        }
        String string = this.makeKey(localizedString.getCharsetName(), localizedString.getLocale());
        this.m_strings.put(string, localizedString);
    }

    public void addLocalizedStrings(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, LocalizedString.class);
        for (LocalizedString localizedString : collection) {
            this.addLocalizedString(localizedString);
        }
    }

    public void removeLocalizedString(LocalizedString localizedString) throws JAXRException {
        if (localizedString == null) {
            return;
        }
        String string = this.makeKey(localizedString.getCharsetName(), localizedString.getLocale());
        this.m_strings.remove(string);
    }

    public void removeLocalizedStrings(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, LocalizedString.class);
        for (LocalizedString localizedString : collection) {
            this.removeLocalizedString(localizedString);
        }
    }

    public LocalizedString getLocalizedString(Locale locale, String string) throws JAXRException {
        String string2 = this.makeKey(string, locale);
        return (LocalizedString)this.m_strings.get(string2);
    }

    public Collection getLocalizedStrings() throws JAXRException {
        return new ArrayList(this.m_strings.values());
    }

    private String makeKey(String string, Locale locale) {
        return new String(string + locale.toString());
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_strings};
        Object[] objectArray2 = InternationalStringImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_strings"};
        String[] stringArray2 = InternationalStringImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }
}

