/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.Locale;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.LocalizedString;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.BaseInfoModelObject;

public class LocalizedStringImpl
extends BaseInfoModelObject
implements LocalizedString {
    private static final long serialVersionUID = -1L;
    private String m_charsetName;
    private Locale m_locale;
    private String m_value;

    public LocalizedStringImpl(RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
        this.m_charsetName = "UTF-8";
        this.m_locale = Locale.getDefault();
    }

    public LocalizedStringImpl(LocalizedString localizedString, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        if (localizedString != null) {
            this.m_charsetName = localizedString.getCharsetName();
            this.m_locale = localizedString.getLocale();
            this.m_value = localizedString.getValue();
        }
    }

    public LocalizedStringImpl(Locale locale, String string, String string2, RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
        this.m_charsetName = string2;
        this.m_locale = locale;
        this.m_value = string;
    }

    public LocalizedStringImpl(Locale locale, String string, RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
        this.m_charsetName = "UTF-8";
        this.m_locale = locale;
        this.m_value = string;
    }

    public String getCharsetName() throws JAXRException {
        return this.m_charsetName;
    }

    public Locale getLocale() throws JAXRException {
        return this.m_locale == null ? Locale.getDefault() : this.m_locale;
    }

    public String getValue() throws JAXRException {
        return this.m_value;
    }

    public void setCharsetName(String string) throws JAXRException {
        this.m_charsetName = string;
    }

    public void setLocale(Locale locale) throws JAXRException {
        this.m_locale = locale;
    }

    public void setValue(String string) throws JAXRException {
        this.m_value = string;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_charsetName, this.m_locale, this.m_value};
        Object[] objectArray2 = LocalizedStringImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_charsetName", "m_locale", "m_value"};
        String[] stringArray2 = LocalizedStringImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }
}

