/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryObjectImpl;
import weblogic.xml.jaxr.registry.infomodel.ServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.TelephoneNumberImpl;
import weblogic.xml.jaxr.registry.infomodel.UserImpl;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class OrganizationImpl
extends RegistryObjectImpl
implements Organization {
    private static final long serialVersionUID = -1L;
    private User m_primaryContact;
    private ArrayList m_services = new ArrayList();
    private ArrayList m_telephoneNumbers = new ArrayList();
    private ArrayList m_users = new ArrayList();

    public OrganizationImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        registryServiceImpl.getRegistryProxy().setRegistryObjectOwner(this, registryServiceImpl.getCurrentUser());
    }

    public OrganizationImpl(Organization organization, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryObject)organization, registryServiceImpl);
        registryServiceImpl.getRegistryProxy().setRegistryObjectOwner(this, registryServiceImpl.getCurrentUser());
        if (organization != null) {
            if (organization.getPrimaryContact() != null) {
                this.m_primaryContact = new UserImpl(organization.getPrimaryContact(), registryServiceImpl);
            }
            this.duplicateServices(organization.getServices());
            this.duplcateTelephoneNumbers(organization.getTelephoneNumbers(null));
            this.duplcateUsers(organization.getUsers());
        }
    }

    public OrganizationImpl(InternationalString internationalString, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(internationalString, registryServiceImpl);
        registryServiceImpl.getRegistryProxy().setRegistryObjectOwner(this, registryServiceImpl.getCurrentUser());
    }

    public PostalAddress getPostalAddress() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public void setPostalAddress(PostalAddress postalAddress) throws JAXRException {
        this.checkCapability(1);
    }

    public User getPrimaryContact() throws JAXRException {
        if (null == this.m_primaryContact) {
            return this.getRegistryService().getBusinessLifeCycleManager().createUser();
        }
        return this.m_primaryContact;
    }

    public void setPrimaryContact(User user) throws JAXRException {
        this.m_primaryContact = user;
        if (!this.m_users.contains(user)) {
            this.addUser(this.m_primaryContact);
        }
    }

    public void addUser(User user) throws JAXRException {
        if (user != null) {
            this.m_users.add(user);
            ((UserImpl)user).setOrganization(this);
        }
    }

    public void addUsers(Collection collection) throws JAXRException {
        if (collection != null) {
            for (UserImpl userImpl : collection) {
                this.addUser(userImpl);
            }
        }
    }

    public void removeUser(User user) throws JAXRException {
        if (user != null) {
            this.m_users.remove(user);
        }
    }

    public void removeUsers(Collection collection) throws JAXRException {
        if (collection != null) {
            this.m_users.removeAll(collection);
        }
    }

    public Collection getUsers() throws JAXRException {
        return this.m_users;
    }

    public Collection getTelephoneNumbers(String string) throws JAXRException {
        if (null == string) {
            return this.m_telephoneNumbers;
        }
        ArrayList<TelephoneNumber> arrayList = new ArrayList<TelephoneNumber>();
        for (int i = 0; i < this.m_telephoneNumbers.size(); ++i) {
            TelephoneNumber telephoneNumber = (TelephoneNumber)this.m_telephoneNumbers.get(i);
            if (!string.equals(telephoneNumber.getType())) continue;
            arrayList.add(telephoneNumber);
        }
        return arrayList;
    }

    public void setTelephoneNumbers(Collection collection) throws JAXRException {
        if (collection != null) {
            this.m_telephoneNumbers.addAll(collection);
        }
    }

    public void addService(Service service2) throws JAXRException {
        if (null != service2) {
            if (service2.getProvidingOrganization() == null) {
                ((ServiceImpl)service2).setProvidingOrganization(this);
            }
            this.m_services.add(service2);
        }
    }

    public void addServices(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Service.class);
        for (Service service2 : collection) {
            this.addService(service2);
        }
    }

    public void removeService(Service service2) throws JAXRException {
        this.m_services.remove(service2);
    }

    public void removeServices(Collection collection) throws JAXRException {
        this.m_services.removeAll(collection);
    }

    public Collection getServices() throws JAXRException {
        return this.m_services;
    }

    public void addChildOrganization(Organization organization) throws JAXRException {
        this.checkCapability(1);
    }

    public void addChildOrganizations(Collection collection) throws JAXRException {
        this.checkCapability(1);
    }

    public void removeChildOrganization(Organization organization) throws JAXRException {
        this.checkCapability(1);
    }

    public void removeChildOrganizations(Collection collection) throws JAXRException {
        this.checkCapability(1);
    }

    public int getChildOrganizationCount() throws JAXRException {
        this.checkCapability(1);
        return 0;
    }

    public Collection getChildOrganizations() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public Collection getDescendantOrganizations() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public Organization getParentOrganization() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public Organization getRootOrganization() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_primaryContact, this.m_services, this.m_telephoneNumbers, this.m_users};
        Object[] objectArray2 = OrganizationImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_primaryContact", "m_services", "m_telephoneNumbers", "m_users"};
        String[] stringArray2 = OrganizationImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    private void duplicateServices(Collection collection) throws JAXRException {
        if (collection != null) {
            for (Service service2 : collection) {
                ServiceImpl serviceImpl = new ServiceImpl(service2, this.getRegistryService());
                this.m_services.add(serviceImpl);
            }
        }
    }

    private void duplcateTelephoneNumbers(Collection collection) throws JAXRException {
        if (collection != null) {
            for (TelephoneNumber telephoneNumber : collection) {
                TelephoneNumberImpl telephoneNumberImpl = new TelephoneNumberImpl(telephoneNumber, this.getRegistryService());
                this.m_telephoneNumbers.add(telephoneNumberImpl);
            }
        }
    }

    private void duplcateUsers(Collection collection) throws JAXRException {
        if (collection != null) {
            for (User user : collection) {
                UserImpl userImpl = new UserImpl(user, this.getRegistryService());
                this.m_telephoneNumbers.add(userImpl);
            }
        }
    }
}

