/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.ExtensibleObject;
import javax.xml.registry.infomodel.PostalAddress;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.ClassificationSchemeImpl;
import weblogic.xml.jaxr.registry.infomodel.ExtensibleObjectImpl;

public class PostalAddressImpl
extends ExtensibleObjectImpl
implements PostalAddress {
    private static final long serialVersionUID = -1L;
    private ClassificationScheme m_postalScheme;
    private String m_city;
    private String m_country;
    private String m_postalCode;
    private String m_stateOrProvince;
    private String m_street;
    private String m_streetNumber;
    private String m_addressType;

    public PostalAddressImpl(RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
    }

    public PostalAddressImpl(PostalAddress postalAddress, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((ExtensibleObject)postalAddress, registryServiceImpl);
        if (postalAddress != null) {
            this.m_postalScheme = new ClassificationSchemeImpl(postalAddress.getPostalScheme(), registryServiceImpl);
            this.m_city = postalAddress.getCity();
            this.m_country = postalAddress.getCountry();
            this.m_postalCode = postalAddress.getPostalCode();
            this.m_stateOrProvince = postalAddress.getStateOrProvince();
            this.m_street = postalAddress.getStreet();
            this.m_streetNumber = postalAddress.getStreetNumber();
            this.m_addressType = postalAddress.getType();
        }
    }

    public String getStreet() throws JAXRException {
        return this.m_street == null ? "" : this.m_street;
    }

    public void setStreet(String string) throws JAXRException {
        this.m_street = string;
    }

    public String getStreetNumber() throws JAXRException {
        return this.m_streetNumber == null ? "" : this.m_streetNumber;
    }

    public void setStreetNumber(String string) throws JAXRException {
        this.m_streetNumber = string;
    }

    public String getCity() throws JAXRException {
        return this.m_city == null ? "" : this.m_city;
    }

    public void setCity(String string) throws JAXRException {
        this.m_city = string;
    }

    public String getStateOrProvince() throws JAXRException {
        return this.m_stateOrProvince == null ? "" : this.m_stateOrProvince;
    }

    public void setStateOrProvince(String string) throws JAXRException {
        this.m_stateOrProvince = string;
    }

    public String getPostalCode() throws JAXRException {
        return this.m_postalCode == null ? "" : this.m_postalCode;
    }

    public void setPostalCode(String string) throws JAXRException {
        this.m_postalCode = string;
    }

    public String getCountry() throws JAXRException {
        return this.m_country == null ? "" : this.m_country;
    }

    public void setCountry(String string) throws JAXRException {
        this.m_country = string;
    }

    public String getType() throws JAXRException {
        return this.m_addressType;
    }

    public void setType(String string) throws JAXRException {
        this.m_addressType = string;
    }

    public void setPostalScheme(ClassificationScheme classificationScheme) throws JAXRException {
        this.m_postalScheme = classificationScheme;
    }

    public ClassificationScheme getPostalScheme() throws JAXRException {
        return this.m_postalScheme;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_postalScheme, this.m_city, this.m_country, this.m_postalCode, this.m_stateOrProvince, this.m_street, this.m_streetNumber, this.m_addressType};
        Object[] objectArray2 = PostalAddressImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_postalScheme", "m_city", "m_country", "m_postalCode", "m_stateOrProvince", "m_street", "m_streetNumber", "m_addressType"};
        String[] stringArray2 = PostalAddressImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }
}

