/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExtensibleObject;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.AssociationImpl;
import weblogic.xml.jaxr.registry.infomodel.ClassificationImpl;
import weblogic.xml.jaxr.registry.infomodel.ExtensibleObjectImpl;
import weblogic.xml.jaxr.registry.infomodel.ExternalIdentifierImpl;
import weblogic.xml.jaxr.registry.infomodel.ExternalLinkImpl;
import weblogic.xml.jaxr.registry.infomodel.InternationalStringImpl;
import weblogic.xml.jaxr.registry.infomodel.KeyImpl;
import weblogic.xml.jaxr.registry.infomodel.OrganizationImpl;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class RegistryObjectImpl
extends ExtensibleObjectImpl
implements RegistryObject {
    private static final long serialVersionUID = -1L;
    private InternationalString m_name;
    private InternationalString m_description;
    private Key m_key;
    private OrganizationImpl m_submittingOrganization;
    private ArrayList m_classifications = new ArrayList();
    private ArrayList m_associations = new ArrayList();
    private ArrayList m_externalIdentifiers = new ArrayList();
    private ArrayList m_externalLinks = new ArrayList();

    public RegistryObjectImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
    }

    public RegistryObjectImpl(RegistryObject registryObject, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((ExtensibleObject)registryObject, registryServiceImpl);
        if (registryObject != null) {
            this.m_name = new InternationalStringImpl(registryObject.getName(), registryServiceImpl);
            this.m_description = new InternationalStringImpl(registryObject.getDescription(), registryServiceImpl);
            this.m_key = registryObject.getKey() == null ? new KeyImpl(registryServiceImpl) : new KeyImpl(registryObject.getKey(), registryServiceImpl);
            this.m_submittingOrganization = new OrganizationImpl(registryObject.getSubmittingOrganization(), registryServiceImpl);
            this.duplicateClassifications(registryObject.getClassifications());
            this.duplicateAssociations(registryObject.getAssociations());
            this.duplicateExternalIdentifiers(registryObject.getExternalIdentifiers());
            this.duplicateExternalLinks(registryObject.getExternalLinks());
        }
    }

    public RegistryObjectImpl(InternationalString internationalString, RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
        this.m_name = internationalString;
    }

    public Key getKey() throws JAXRException {
        return this.m_key;
    }

    public InternationalString getDescription() throws JAXRException {
        if (this.m_description != null) {
            return this.m_description;
        }
        return this.getEmptyInternationalString();
    }

    public void setDescription(InternationalString internationalString) throws JAXRException {
        this.m_description = internationalString;
    }

    public InternationalString getName() {
        return this.m_name == null ? this.getEmptyInternationalString() : this.m_name;
    }

    public void setName(InternationalString internationalString) throws JAXRException {
        this.m_name = internationalString;
    }

    public void setKey(Key key) throws JAXRException {
        this.m_key = key;
    }

    public String toXML() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public void addClassification(Classification classification) throws JAXRException {
        if (null != classification) {
            classification.setClassifiedObject((RegistryObject)this);
            this.m_classifications.add(classification);
        }
    }

    public void addClassifications(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Classification.class);
        for (Classification classification : collection) {
            this.addClassification(classification);
        }
    }

    public void removeClassification(Classification classification) throws JAXRException {
        if (null != classification) {
            this.m_classifications.remove(classification);
        }
    }

    public void removeClassifications(Collection collection) throws JAXRException {
        if (null != collection) {
            this.m_classifications.removeAll(collection);
        }
    }

    public void setClassifications(Collection collection) throws JAXRException {
        if (null != collection) {
            this.m_classifications.clear();
            this.addClassifications(collection);
        }
    }

    public Collection getClassifications() throws JAXRException {
        return this.m_classifications;
    }

    public Collection getAuditTrail() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public void addAssociation(Association association) throws JAXRException {
        if (null != association) {
            association.setSourceObject((RegistryObject)this);
            this.m_associations.add(association);
        }
    }

    public void addAssociations(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, Association.class);
        for (Association association : collection) {
            this.addAssociation(association);
        }
    }

    public void removeAssociation(Association association) throws JAXRException {
        if (null != association) {
            this.m_associations.remove(association);
        }
    }

    public void removeAssociations(Collection collection) throws JAXRException {
        if (null != collection) {
            this.m_associations.removeAll(collection);
        }
    }

    public void setAssociations(Collection collection) throws JAXRException {
        if (null != collection) {
            this.m_associations.clear();
            this.addAssociations(collection);
        }
    }

    public Collection getAssociations() throws JAXRException {
        return this.m_associations;
    }

    public Collection getAssociatedObjects() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public void addExternalIdentifier(ExternalIdentifier externalIdentifier) throws JAXRException {
        if (null != externalIdentifier) {
            ((ExternalIdentifierImpl)externalIdentifier).setRegistryObject(this);
            this.m_externalIdentifiers.add(externalIdentifier);
        }
    }

    public void addExternalIdentifiers(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, ExternalIdentifier.class);
        for (ExternalIdentifier externalIdentifier : collection) {
            this.addExternalIdentifier(externalIdentifier);
        }
    }

    public void removeExternalIdentifier(ExternalIdentifier externalIdentifier) throws JAXRException {
        if (null != externalIdentifier) {
            this.m_externalIdentifiers.remove(externalIdentifier);
        }
    }

    public void removeExternalIdentifiers(Collection collection) throws JAXRException {
        if (null != collection) {
            this.m_externalIdentifiers.removeAll(collection);
        }
    }

    public void setExternalIdentifiers(Collection collection) throws JAXRException {
        if (null != collection) {
            this.m_externalIdentifiers.clear();
            this.addExternalIdentifiers(collection);
        }
    }

    public Collection getExternalIdentifiers() throws JAXRException {
        return this.m_externalIdentifiers;
    }

    public void addExternalLink(ExternalLink externalLink) throws JAXRException {
        if (null != externalLink) {
            externalLink.setName((InternationalString)new InternationalStringImpl("businessEntityExt", this.getRegistryService()));
            this.m_externalLinks.add(externalLink);
            ((ExternalLinkImpl)externalLink).addLinkedObject(this);
        }
    }

    public void addExternalLinks(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, ExternalLink.class);
        for (ExternalLink externalLink : collection) {
            this.addExternalLink(externalLink);
        }
    }

    public void removeExternalLink(ExternalLink externalLink) throws JAXRException {
        if (null != externalLink) {
            this.m_externalLinks.remove(externalLink);
        }
    }

    public void removeExternalLinks(Collection collection) throws JAXRException {
        if (null != collection) {
            this.m_externalLinks.removeAll(collection);
        }
    }

    public void setExternalLinks(Collection collection) throws JAXRException {
        if (null != collection) {
            this.m_externalLinks.clear();
            this.addExternalLinks(collection);
        }
    }

    public Collection getExternalLinks() throws JAXRException {
        return this.m_externalLinks;
    }

    public Concept getObjectType() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public Organization getSubmittingOrganization() throws JAXRException {
        return this.m_submittingOrganization;
    }

    public void setSubmittingOrganization(Organization organization) throws JAXRException {
        this.m_submittingOrganization = (OrganizationImpl)organization;
    }

    public Collection getRegistryPackages() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public LifeCycleManager getLifeCycleManager() throws JAXRException {
        return this.getRegistryService().getBusinessLifeCycleManager();
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_name, this.m_description, this.m_key, this.getName(this.m_submittingOrganization), this.m_classifications, this.m_associations, this.m_externalIdentifiers, this.m_externalLinks};
        Object[] objectArray2 = RegistryObjectImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_name", "m_description", "m_key", "m_submittingOrganization.Name", "m_classifications", "m_associations", "m_externalIdentifiers", "m_externalLinks"};
        String[] stringArray2 = RegistryObjectImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    private void duplicateClassifications(Collection collection) throws JAXRException {
        if (collection != null) {
            for (Classification classification : collection) {
                ClassificationImpl classificationImpl = new ClassificationImpl(classification, this.getRegistryService());
                this.m_classifications.add(classificationImpl);
            }
        }
    }

    private void duplicateAssociations(Collection collection) throws JAXRException {
        if (collection != null) {
            for (Association association : collection) {
                AssociationImpl associationImpl = new AssociationImpl(association, this.getRegistryService());
                this.m_associations.add(associationImpl);
            }
        }
    }

    private void duplicateExternalIdentifiers(Collection collection) throws JAXRException {
        if (collection != null) {
            for (ExternalIdentifier externalIdentifier : collection) {
                ExternalIdentifierImpl externalIdentifierImpl = new ExternalIdentifierImpl(externalIdentifier, this.getRegistryService());
                this.m_externalIdentifiers.add(externalIdentifierImpl);
            }
        }
    }

    private void duplicateExternalLinks(Collection collection) throws JAXRException {
        if (collection != null) {
            for (ExternalLink externalLink : collection) {
                ExternalLinkImpl externalLinkImpl = new ExternalLinkImpl(externalLink, this.getRegistryService());
                this.m_externalIdentifiers.add(externalLinkImpl);
            }
        }
    }
}

