/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.URIValidator;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.KeyImpl;
import weblogic.xml.jaxr.registry.infomodel.OrganizationImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryObjectImpl;
import weblogic.xml.jaxr.registry.infomodel.ServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.SpecificationLinkImpl;
import weblogic.xml.jaxr.registry.infomodel.URIValidatorImpl;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class ServiceBindingImpl
extends RegistryObjectImpl
implements ServiceBinding {
    private static final long serialVersionUID = -1L;
    private URIValidator m_validator;
    private String m_accessURI;
    private ServiceBinding m_targetBinding;
    private Service m_parentService;
    private ArrayList m_specificationLinks = new ArrayList();

    public ServiceBindingImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        this.m_validator = new URIValidatorImpl(registryServiceImpl);
        this.m_parentService = new ServiceImpl(registryServiceImpl);
    }

    public ServiceBindingImpl(ServiceBinding serviceBinding, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryObject)serviceBinding, registryServiceImpl);
        if (serviceBinding != null) {
            this.m_validator = new URIValidatorImpl(registryServiceImpl);
            this.setValidateURI(serviceBinding.getValidateURI());
            this.m_accessURI = serviceBinding.getAccessURI();
            this.m_targetBinding = new ServiceBindingImpl(serviceBinding.getTargetBinding(), registryServiceImpl);
            this.duplicateAncestorKeys(serviceBinding, registryServiceImpl);
            this.duplicateSpecificationLinks(serviceBinding.getSpecificationLinks());
        }
    }

    public void setValidateURI(boolean bl) throws JAXRException {
        this.m_validator.setValidateURI(bl);
    }

    public boolean getValidateURI() throws JAXRException {
        return this.m_validator.getValidateURI();
    }

    public String getAccessURI() throws JAXRException {
        return this.m_accessURI;
    }

    public void setAccessURI(String string) throws JAXRException {
        if (this.m_targetBinding != null) {
            String string2 = JAXRMessages.getMessage("jaxr.infomodel.ServiceBindingImpl.InvalidRequest", new Object[]{"targetBinding"});
            throw new InvalidRequestException(string2);
        }
        this.m_accessURI = string;
    }

    public ServiceBinding getTargetBinding() throws JAXRException {
        return this.m_targetBinding;
    }

    public void setTargetBinding(ServiceBinding serviceBinding) throws JAXRException {
        if (this.m_accessURI != null) {
            String string = JAXRMessages.getMessage("jaxr.infomodel.ServiceBindingImpl.InvalidRequest", new Object[]{"accessURI"});
            throw new InvalidRequestException(string);
        }
        this.m_targetBinding = serviceBinding;
    }

    public Service getService() throws JAXRException {
        return this.m_parentService;
    }

    void setService(Service service2) throws JAXRException {
        this.m_parentService = service2;
    }

    public void addSpecificationLink(SpecificationLink specificationLink) throws JAXRException {
        if (specificationLink != null) {
            ((SpecificationLinkImpl)specificationLink).setServiceBinding(this);
            this.m_specificationLinks.add(specificationLink);
        }
    }

    public void addSpecificationLinks(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, SpecificationLink.class);
        for (SpecificationLink specificationLink : collection) {
            this.addSpecificationLink(specificationLink);
        }
    }

    public void removeSpecificationLink(SpecificationLink specificationLink) throws JAXRException {
        if (specificationLink != null) {
            this.m_specificationLinks.remove(specificationLink);
        }
    }

    public void removeSpecificationLinks(Collection collection) throws JAXRException {
        if (collection != null) {
            this.m_specificationLinks.removeAll(collection);
        }
    }

    public Collection getSpecificationLinks() throws JAXRException {
        return this.m_specificationLinks;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_validator, this.m_accessURI, this.m_targetBinding, this.getName(this.m_parentService), this.m_specificationLinks};
        Object[] objectArray2 = ServiceBindingImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_validator", "m_accessURI", "m_targetBinding", "m_parentService.Name", "m_specificationLinks"};
        String[] stringArray2 = ServiceBindingImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    private void duplicateSpecificationLinks(Collection collection) throws JAXRException {
        if (collection != null) {
            for (SpecificationLink specificationLink : collection) {
                SpecificationLinkImpl specificationLinkImpl = new SpecificationLinkImpl(specificationLink, this.getRegistryService());
                this.m_specificationLinks.add(specificationLinkImpl);
            }
        }
    }

    private void duplicateAncestorKeys(ServiceBinding serviceBinding, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        Service service2 = serviceBinding.getService();
        if (service2 != null) {
            this.m_parentService = new ServiceImpl(registryServiceImpl);
            if (service2.getKey() != null) {
                KeyImpl keyImpl = new KeyImpl(service2.getKey(), registryServiceImpl);
                this.m_parentService.setKey((Key)keyImpl);
                Organization organization = service2.getProvidingOrganization();
                if (organization != null) {
                    OrganizationImpl organizationImpl = new OrganizationImpl(registryServiceImpl);
                    if (organization.getKey() != null) {
                        keyImpl = new KeyImpl(organization.getKey(), registryServiceImpl);
                        organizationImpl.setKey(keyImpl);
                    }
                    this.m_parentService.setProvidingOrganization((Organization)organizationImpl);
                }
            }
        }
    }
}

