/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryEntry;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.OrganizationImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryEntryImpl;
import weblogic.xml.jaxr.registry.infomodel.ServiceBindingImpl;
import weblogic.xml.jaxr.registry.util.JAXRUtil;

public class ServiceImpl
extends RegistryEntryImpl
implements Service {
    private static final long serialVersionUID = -1L;
    private ArrayList m_serviceBindings = new ArrayList();
    private Organization m_providingOrganization;

    public ServiceImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
    }

    public ServiceImpl(Service service2, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryEntry)service2, registryServiceImpl);
        if (service2 != null) {
            this.duplicateServiceBindings(service2.getServiceBindings());
            this.m_providingOrganization = new OrganizationImpl(service2.getProvidingOrganization(), registryServiceImpl);
        }
    }

    public Organization getProvidingOrganization() throws JAXRException {
        return this.m_providingOrganization;
    }

    public void setProvidingOrganization(Organization organization) throws JAXRException {
        this.m_providingOrganization = organization;
    }

    public void addServiceBinding(ServiceBinding serviceBinding) throws JAXRException {
        if (serviceBinding != null) {
            ((ServiceBindingImpl)serviceBinding).setService(this);
            this.m_serviceBindings.add(serviceBinding);
        }
    }

    public void addServiceBindings(Collection collection) throws JAXRException {
        JAXRUtil.verifyCollectionContent(collection, ServiceBinding.class);
        for (ServiceBinding serviceBinding : collection) {
            this.addServiceBinding(serviceBinding);
        }
    }

    public void removeServiceBinding(ServiceBinding serviceBinding) throws JAXRException {
        if (null != serviceBinding) {
            this.m_serviceBindings.remove(serviceBinding);
        }
    }

    public void removeServiceBindings(Collection collection) throws JAXRException {
        if (null != collection) {
            this.m_serviceBindings.removeAll(collection);
        }
    }

    public Collection getServiceBindings() throws JAXRException {
        return this.m_serviceBindings;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_serviceBindings, this.getName(this.m_providingOrganization)};
        Object[] objectArray2 = ServiceImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_serviceBindings", "m_providingOrganization.Name"};
        String[] stringArray2 = ServiceImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    private void duplicateServiceBindings(Collection collection) throws JAXRException {
        if (collection != null) {
            for (ServiceBinding serviceBinding : collection) {
                ServiceBindingImpl serviceBindingImpl = new ServiceBindingImpl(serviceBinding, this.getRegistryService());
                this.m_serviceBindings.add(serviceBindingImpl);
            }
        }
    }
}

