/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.ConceptImpl;
import weblogic.xml.jaxr.registry.infomodel.InternationalStringImpl;
import weblogic.xml.jaxr.registry.infomodel.KeyImpl;
import weblogic.xml.jaxr.registry.infomodel.OrganizationImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryObjectImpl;
import weblogic.xml.jaxr.registry.infomodel.ServiceBindingImpl;
import weblogic.xml.jaxr.registry.infomodel.ServiceImpl;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;

public class SpecificationLinkImpl
extends RegistryObjectImpl
implements SpecificationLink {
    private static final long serialVersionUID = -1L;
    private Concept m_registryObject;
    private InternationalString m_usageDescription;
    private ArrayList m_usageParameters = new ArrayList();
    private ServiceBinding m_serviceBinding;

    public SpecificationLinkImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
    }

    public SpecificationLinkImpl(SpecificationLink specificationLink, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryObject)specificationLink, registryServiceImpl);
        if (specificationLink != null) {
            this.m_registryObject = new ConceptImpl((Concept)specificationLink.getSpecificationObject(), registryServiceImpl);
            this.m_usageDescription = new InternationalStringImpl(specificationLink.getUsageDescription(), registryServiceImpl);
            this.m_usageParameters = new ArrayList(specificationLink.getUsageParameters());
            this.duplicateAncestorKeys(specificationLink, registryServiceImpl);
        }
    }

    public RegistryObject getSpecificationObject() throws JAXRException {
        return this.m_registryObject;
    }

    public void setSpecificationObject(RegistryObject registryObject) throws JAXRException {
        if (!(registryObject instanceof Concept)) {
            String string = JAXRMessages.getMessage("jaxr.infomodle.SpecificationLinkImpl.invalidSpecificationObject");
            throw new JAXRException(string);
        }
        this.m_registryObject = (Concept)registryObject;
    }

    public InternationalString getUsageDescription() throws JAXRException {
        return this.m_usageDescription == null ? this.getEmptyInternationalString() : this.m_usageDescription;
    }

    public void setUsageDescription(InternationalString internationalString) throws JAXRException {
        this.m_usageDescription = internationalString;
    }

    public Collection getUsageParameters() throws JAXRException {
        return this.m_usageParameters;
    }

    public void setUsageParameters(Collection collection) throws JAXRException {
        this.m_usageParameters = new ArrayList();
        if (null != collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() instanceof String) continue;
                String string = JAXRMessages.getMessage("jaxr.infomodle.SpecificationLinkImpl.invalidUsageParameters");
                throw new JAXRException(string);
            }
            this.m_usageParameters = new ArrayList(collection);
        }
    }

    public ServiceBinding getServiceBinding() throws JAXRException {
        return this.m_serviceBinding;
    }

    public void setServiceBinding(ServiceBinding serviceBinding) throws JAXRException {
        this.m_serviceBinding = serviceBinding;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.m_registryObject, this.m_usageDescription, this.m_usageParameters, this.getName(this.m_serviceBinding)};
        Object[] objectArray2 = SpecificationLinkImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_registryObject", "m_usageDescription", "m_usageParameters", "m_serviceBinding"};
        String[] stringArray2 = SpecificationLinkImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    private void duplicateAncestorKeys(SpecificationLink specificationLink, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        ServiceBinding serviceBinding = specificationLink.getServiceBinding();
        if (serviceBinding != null) {
            this.m_serviceBinding = new ServiceBindingImpl(registryServiceImpl);
            if (serviceBinding.getKey() != null) {
                KeyImpl keyImpl = new KeyImpl(serviceBinding.getKey(), registryServiceImpl);
                this.m_serviceBinding.setKey((Key)keyImpl);
                Service service2 = serviceBinding.getService();
                if (service2 != null) {
                    ServiceImpl serviceImpl = new ServiceImpl(registryServiceImpl);
                    if (service2.getKey() != null) {
                        keyImpl = new KeyImpl(service2.getKey(), registryServiceImpl);
                        serviceImpl.setKey(keyImpl);
                        Organization organization = service2.getProvidingOrganization();
                        if (organization != null) {
                            OrganizationImpl organizationImpl = new OrganizationImpl(registryServiceImpl);
                            if (organization.getKey() != null) {
                                keyImpl = new KeyImpl(organization.getKey(), registryServiceImpl);
                                organizationImpl.setKey(keyImpl);
                            }
                            service2.setProvidingOrganization((Organization)organizationImpl);
                        }
                    }
                    ((ServiceBindingImpl)this.m_serviceBinding).setService(serviceImpl);
                }
            }
        }
    }
}

