/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.URIValidator;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.BaseInfoModelObject;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;

public class URIValidatorImpl
extends BaseInfoModelObject
implements URIValidator {
    private static final long serialVersionUID = -1L;
    private boolean m_validateURI;

    public URIValidatorImpl(RegistryServiceImpl registryServiceImpl) {
        super(registryServiceImpl);
        this.m_validateURI = true;
    }

    public URIValidatorImpl(URIValidator uRIValidator, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
        if (uRIValidator != null) {
            this.m_validateURI = uRIValidator.getValidateURI();
        }
    }

    public void setValidateURI(boolean bl) throws JAXRException {
        this.m_validateURI = bl;
    }

    public boolean getValidateURI() throws JAXRException {
        return this.m_validateURI;
    }

    protected void validate(String string) throws JAXRException {
        block10: {
            if (this.getValidateURI()) {
                try {
                    URL uRL = new URL(string);
                    if (!uRL.getProtocol().equalsIgnoreCase("http")) break block10;
                    try {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        int n = httpURLConnection.getResponseCode();
                        int n2 = n / 100;
                        if (n2 != 1 && n2 != 2 && n2 != 3) {
                            if (n2 == 4) {
                                String string2 = "jaxr.validation.uri.clientError";
                                Object[] objectArray = new String[]{string};
                                String string3 = JAXRMessages.getMessage(string2, objectArray);
                                throw new InvalidRequestException(string3);
                            }
                            if (n2 == 5) {
                                String string4 = "jaxr.validation.uri.serverError";
                                Object[] objectArray = new String[]{string};
                                String string5 = JAXRMessages.getMessage(string4, objectArray);
                                throw new InvalidRequestException(string5);
                            }
                            String string6 = "jaxr.validation.uri.unknownResponse";
                            Object[] objectArray = new String[]{string};
                            String string7 = JAXRMessages.getMessage(string6, objectArray);
                            throw new InvalidRequestException(string7);
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        String string8 = "jaxr.validation.uri.unknownHostException";
                        Object[] objectArray = new String[]{string};
                        String string9 = JAXRMessages.getMessage(string8, objectArray);
                        throw new InvalidRequestException(string9, (Throwable)unknownHostException);
                    }
                    catch (ConnectException connectException) {
                        String string10 = "jaxr.validation.uri.connectException";
                        Object[] objectArray = new String[]{string};
                        String string11 = JAXRMessages.getMessage(string10, objectArray);
                        throw new InvalidRequestException(string11, (Throwable)connectException);
                    }
                    catch (IOException iOException) {
                        String string12 = "jaxr.validation.uri.ioException";
                        Object[] objectArray = new String[]{string};
                        String string13 = JAXRMessages.getMessage(string12, objectArray);
                        throw new InvalidRequestException(string13, (Throwable)iOException);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    String string14 = "jaxr.validation.uri.malformed";
                    Object[] objectArray = new String[]{string};
                    String string15 = JAXRMessages.getMessage(string14, objectArray);
                    throw new InvalidRequestException(string15, (Throwable)malformedURLException);
                }
            }
        }
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{new Boolean(this.m_validateURI)};
        Object[] objectArray2 = URIValidatorImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_validateURI"};
        String[] stringArray2 = URIValidatorImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }
}

