/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.infomodel;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.infomodel.EmailAddressImpl;
import weblogic.xml.jaxr.registry.infomodel.OrganizationImpl;
import weblogic.xml.jaxr.registry.infomodel.PersonNameImpl;
import weblogic.xml.jaxr.registry.infomodel.PostalAddressImpl;
import weblogic.xml.jaxr.registry.infomodel.RegistryObjectImpl;
import weblogic.xml.jaxr.registry.infomodel.TelephoneNumberImpl;

public class UserImpl
extends RegistryObjectImpl
implements User {
    private static final long serialVersionUID = -1L;
    private Organization m_organization;
    private PersonName m_personName;
    private String m_type;
    private ArrayList m_emailAddresses = new ArrayList();
    private ArrayList m_postalAddresses = new ArrayList();
    private ArrayList m_telephoneNumbers = new ArrayList();

    public UserImpl(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super(registryServiceImpl);
    }

    public UserImpl(User user, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        super((RegistryObject)user, registryServiceImpl);
        if (user != null) {
            this.m_organization = new OrganizationImpl(user.getOrganization(), registryServiceImpl);
            this.m_personName = new PersonNameImpl(user.getPersonName(), registryServiceImpl);
            this.m_type = user.getType();
            this.duplcateEmailAddresses(user.getEmailAddresses());
            this.duplcatePostalAddresses(user.getPostalAddresses());
            this.duplcateTelephoneNumbers(user.getTelephoneNumbers(null));
        }
    }

    public Organization getOrganization() throws JAXRException {
        return this.m_organization;
    }

    public void setOrganization(Organization organization) throws JAXRException {
        this.m_organization = organization;
    }

    public PersonName getPersonName() throws JAXRException {
        return this.m_personName;
    }

    public void setPersonName(PersonName personName) throws JAXRException {
        this.m_personName = personName;
    }

    public Collection getPostalAddresses() throws JAXRException {
        return this.m_postalAddresses;
    }

    public void setPostalAddresses(Collection collection) throws JAXRException {
        this.m_postalAddresses.clear();
        if (null != collection) {
            this.m_postalAddresses.addAll(collection);
        }
    }

    public URL getUrl() throws JAXRException {
        this.checkCapability(1);
        return null;
    }

    public void setUrl(URL uRL) throws JAXRException {
        this.checkCapability(1);
    }

    public Collection getTelephoneNumbers(String string) throws JAXRException {
        if (string == null) {
            return this.m_telephoneNumbers;
        }
        ArrayList<TelephoneNumber> arrayList = new ArrayList<TelephoneNumber>();
        for (TelephoneNumber telephoneNumber : this.m_telephoneNumbers) {
            if (!telephoneNumber.getType().equals(string)) continue;
            arrayList.add(telephoneNumber);
        }
        return arrayList;
    }

    public void setTelephoneNumbers(Collection collection) throws JAXRException {
        this.m_telephoneNumbers.clear();
        if (collection != null) {
            this.m_telephoneNumbers.addAll(collection);
        }
    }

    public Collection getEmailAddresses() throws JAXRException {
        return this.m_emailAddresses;
    }

    public void setEmailAddresses(Collection collection) throws JAXRException {
        this.m_emailAddresses.clear();
        if (collection != null) {
            this.m_emailAddresses.addAll(collection);
        }
    }

    public String getType() throws JAXRException {
        return this.m_type;
    }

    public void setType(String string) throws JAXRException {
        this.m_type = string;
    }

    protected Object[] getDefiningElements() {
        Object[] objectArray = new Object[]{this.getName(this.m_organization), this.m_personName, this.m_type, this.m_emailAddresses, this.m_postalAddresses, this.m_telephoneNumbers};
        Object[] objectArray2 = UserImpl.mergeObjectArrays(super.getDefiningElements(), objectArray);
        return objectArray2;
    }

    protected String[] getVariableNames() {
        String[] stringArray = new String[]{"m_organization.Name", "m_personName", "m_type", "m_emailAddresses", "m_postalAddresses", "m_telephoneNumbers"};
        String[] stringArray2 = UserImpl.mergeStringArrays(super.getVariableNames(), stringArray);
        return stringArray2;
    }

    private void duplcateEmailAddresses(Collection collection) throws JAXRException {
        if (collection != null) {
            for (EmailAddress emailAddress : collection) {
                EmailAddressImpl emailAddressImpl = new EmailAddressImpl(emailAddress, this.getRegistryService());
                this.m_emailAddresses.add(emailAddressImpl);
            }
        }
    }

    private void duplcatePostalAddresses(Collection collection) throws JAXRException {
        if (collection != null) {
            for (PostalAddress postalAddress : collection) {
                PostalAddressImpl postalAddressImpl = new PostalAddressImpl(postalAddress, this.getRegistryService());
                this.m_postalAddresses.add(postalAddressImpl);
            }
        }
    }

    private void duplcateTelephoneNumbers(Collection collection) throws JAXRException {
        if (collection != null) {
            for (TelephoneNumber telephoneNumber : collection) {
                TelephoneNumberImpl telephoneNumberImpl = new TelephoneNumberImpl(telephoneNumber, this.getRegistryService());
                this.m_telephoneNumbers.add(telephoneNumberImpl);
            }
        }
    }
}

