/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.util;

import java.util.HashMap;
import java.util.Map;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import weblogic.xml.jaxr.registry.BaseJAXRObject;
import weblogic.xml.jaxr.registry.RegistryServiceImpl;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;

public class ClassificationSchemeHelper
extends BaseJAXRObject {
    private static Map s_jaxrSchemes;
    public static final String OBJECT_TYPE = "ObjectType";
    public static final String PHONE_TYPE = "PhoneType";
    public static final String ASSOCIATION_TYPE = "AssociationType";
    public static final String URL_TYPE = "URLType";
    public static final String POSTAL_ADDRESS_ATTR = "PostalAddressAttributes";

    private ClassificationSchemeHelper() {
    }

    public static ClassificationScheme getClassificationSchemeByName(String string, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        ClassificationScheme classificationScheme = ClassificationSchemeHelper.getJAXRClassificationScheme(string, registryServiceImpl);
        if (classificationScheme == null) {
            classificationScheme = registryServiceImpl.getRegistryProxy().getInternalClassificationSchemes().getClassificationSchemeByName(string, registryServiceImpl);
        }
        return classificationScheme;
    }

    public static void validateConcept(Concept concept, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        if (concept != null && concept.getClassificationScheme() != null) {
            String string = concept.getClassificationScheme().getName().getValue();
            ClassificationScheme classificationScheme = ClassificationSchemeHelper.getJAXRClassificationScheme(string, registryServiceImpl);
            if (classificationScheme != null) {
                Object object;
                boolean bl = false;
                String string2 = concept.getValue();
                Object[] objectArray = classificationScheme.getDescendantConcepts().iterator();
                while (objectArray.hasNext() && !bl) {
                    object = (Concept)objectArray.next();
                    if (!string2.equals(object.getValue())) continue;
                    bl = true;
                }
                if (!bl) {
                    objectArray = new Object[]{concept.getValue(), string};
                    object = "jaxr.validation.scheme.invalidValue";
                    String string3 = JAXRMessages.getMessage((String)object, objectArray);
                    throw new InvalidRequestException(string3);
                }
            } else {
                registryServiceImpl.getRegistryProxy().getInternalClassificationSchemes().validateConcept(concept, registryServiceImpl);
            }
        }
    }

    private static ClassificationScheme getJAXRClassificationScheme(String string, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        if (s_jaxrSchemes == null) {
            ClassificationSchemeHelper.loadSchemes(registryServiceImpl);
        }
        ClassificationScheme classificationScheme = (ClassificationScheme)s_jaxrSchemes.get(string);
        return classificationScheme;
    }

    private static void loadSchemes(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        s_jaxrSchemes = new HashMap();
        ClassificationSchemeHelper.getAssociationTypeScheme(registryServiceImpl);
        ClassificationSchemeHelper.getObjectTypeScheme(registryServiceImpl);
        ClassificationSchemeHelper.getPhoneTypeScheme(registryServiceImpl);
        ClassificationSchemeHelper.getPostalAddressAttributesScheme(registryServiceImpl);
        ClassificationSchemeHelper.getURLTypeScheme(registryServiceImpl);
    }

    private static ClassificationScheme getObjectTypeScheme(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        ClassificationScheme classificationScheme = (ClassificationScheme)s_jaxrSchemes.get(OBJECT_TYPE);
        if (classificationScheme == null) {
            String[] stringArray = new String[]{"ExternalLink", "Package", "ExternalId", "Association", "Classification", "Concept", "AuditableEvent", "User", "Organization", "CPA", "CPP", "Service", "ServiceBinding", "Process", "WSDL", "ExtrinsicObject", "Organization", "User", "ExternalIdentifier"};
            classificationScheme = ClassificationSchemeHelper.createSchemeWithConcepts(OBJECT_TYPE, stringArray, registryServiceImpl);
            s_jaxrSchemes.put(classificationScheme.getName().getValue(), classificationScheme);
        }
        return classificationScheme;
    }

    private static ClassificationScheme getPhoneTypeScheme(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        ClassificationScheme classificationScheme = (ClassificationScheme)s_jaxrSchemes.get(PHONE_TYPE);
        if (classificationScheme == null) {
            String[] stringArray = new String[]{"OfficePhone", "HomePhone", "MobilePhone", "Beeper", "FAX"};
            classificationScheme = ClassificationSchemeHelper.createSchemeWithConcepts(PHONE_TYPE, stringArray, registryServiceImpl);
            s_jaxrSchemes.put(classificationScheme.getName().getValue(), classificationScheme);
        }
        return classificationScheme;
    }

    private static ClassificationScheme getAssociationTypeScheme(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        ClassificationScheme classificationScheme = (ClassificationScheme)s_jaxrSchemes.get(ASSOCIATION_TYPE);
        if (classificationScheme == null) {
            String[] stringArray = new String[]{"RelatedTo", "ExternallyLinks", "Contains", "Extends", "Implements", "InstanceOf", "Supersedes", "Uses", "HasMember", "EquivalentTo", "HasChild", "HasParent", "Replaces", "ResponsibleFor", "SubmitterOf"};
            classificationScheme = ClassificationSchemeHelper.createSchemeWithConcepts(ASSOCIATION_TYPE, stringArray, registryServiceImpl);
            s_jaxrSchemes.put(classificationScheme.getName().getValue(), classificationScheme);
        }
        return classificationScheme;
    }

    private static ClassificationScheme getURLTypeScheme(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        ClassificationScheme classificationScheme = (ClassificationScheme)s_jaxrSchemes.get(URL_TYPE);
        if (classificationScheme == null) {
            String[] stringArray = new String[]{"HTTP", "HTTPS", "SMTP", "FAX", "PHONE", "OTHER"};
            classificationScheme = ClassificationSchemeHelper.createSchemeWithConcepts(URL_TYPE, stringArray, registryServiceImpl);
            s_jaxrSchemes.put(classificationScheme.getName().getValue(), classificationScheme);
        }
        return classificationScheme;
    }

    private static ClassificationScheme getPostalAddressAttributesScheme(RegistryServiceImpl registryServiceImpl) throws JAXRException {
        ClassificationScheme classificationScheme = (ClassificationScheme)s_jaxrSchemes.get(POSTAL_ADDRESS_ATTR);
        if (classificationScheme == null) {
            String[] stringArray = new String[]{"StreetNumber", "Street", "City", "State", "PostalCode", "Country"};
            classificationScheme = ClassificationSchemeHelper.createSchemeWithConcepts(POSTAL_ADDRESS_ATTR, stringArray, registryServiceImpl);
            s_jaxrSchemes.put(classificationScheme.getName().getValue(), classificationScheme);
        }
        return classificationScheme;
    }

    private static ClassificationScheme createSchemeWithConcepts(String string, String[] stringArray, RegistryServiceImpl registryServiceImpl) throws JAXRException {
        BusinessLifeCycleManager businessLifeCycleManager = registryServiceImpl.getBusinessLifeCycleManager();
        ClassificationScheme classificationScheme = businessLifeCycleManager.createClassificationScheme(string, null);
        String string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
        classificationScheme.setKey(businessLifeCycleManager.createKey(string2));
        for (int i = 0; i < stringArray.length; ++i) {
            Concept concept = businessLifeCycleManager.createConcept((RegistryObject)classificationScheme, stringArray[i], stringArray[i]);
            Key key = businessLifeCycleManager.createKey(string2 + "/" + stringArray[i]);
            concept.setKey(key);
            classificationScheme.addChildConcept(concept);
        }
        return classificationScheme;
    }
}

