/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.jaxr.registry.util;

import java.util.Collection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import weblogic.auddi.util.uuid.UUIDException;
import weblogic.xml.jaxr.registry.resource.JAXRMessages;

public class JAXRUtil {
    private JAXRUtil() {
    }

    public static JAXRException mapException(UUIDException uUIDException) {
        return new JAXRException(uUIDException.getMessage());
    }

    public static void verifyCollectionContent(Collection collection, Class clazz) throws UnexpectedObjectException {
        if (collection == null) {
            String string = JAXRMessages.getMessage("jaxr.infomodel.collection.nullCollection", new Object[]{clazz.getName()});
            throw new UnexpectedObjectException(string);
        }
        for (Object e : collection) {
            Class<?> clazz2;
            if (e == null) {
                clazz2 = JAXRMessages.getMessage("jaxr.infomodel.collection.invalidContent", new Object[]{clazz.getName(), "NULL"});
                throw new UnexpectedObjectException((String)((Object)clazz2));
            }
            clazz2 = e.getClass();
            if (clazz.isAssignableFrom(clazz2)) continue;
            String string = JAXRMessages.getMessage("jaxr.infomodel.collection.invalidContent", new Object[]{clazz.getName(), "NULL"});
            throw new UnexpectedObjectException(string);
        }
    }

    public static void verifyNotNull(Object object, Class clazz) throws InvalidRequestException {
        if (object == null) {
            String string = JAXRMessages.getMessage("jaxr.infomodel.argument.null", new Object[]{clazz.getName()});
            throw new InvalidRequestException(string);
        }
    }
}

