/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.process;

import java.io.IOException;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.compiler.CodeGenerator;
import weblogic.utils.compiler.CompilerInvoker;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.xml.process.GILoaderBase;
import weblogic.xml.process.GeneratorCompiler;
import weblogic.xml.process.PILoader;
import weblogic.xml.process.ProcessorCompiler;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.ProcessorFactoryException;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;
import weblogic.xml.process.XMLProcessor;

public class Compiler {
    private static final boolean debug = true;
    private static final boolean verbose = true;

    public static void compile(Getopt2 opts) throws ToolFailureException {
        CodeGenerator codeGen;
        Object instrux;
        block11: {
            String[] args = opts.args();
            String inputFilePath = args[0];
            instrux = null;
            codeGen = null;
            try {
                ProcessorFactory factory = new ProcessorFactory();
                XMLProcessor loader = factory.getProcessor(inputFilePath, null);
                Debug.assertion((loader != null ? 1 : 0) != 0);
                loader.process(inputFilePath);
                if (loader instanceof PILoader) {
                    instrux = ((PILoader)loader).getProcessingInstructions();
                    codeGen = new ProcessorCompiler(opts);
                    break block11;
                }
                if (loader instanceof GILoaderBase) {
                    instrux = ((GILoaderBase)((Object)loader)).getGeneratingInstructions();
                    codeGen = new GeneratorCompiler(opts);
                    break block11;
                }
                throw new AssertionError("unknown loader type");
            }
            catch (ProcessorFactoryException pfe) {
                pfe.printStackTrace();
                throw new ToolFailureException("ERROR: in obtaining a processor: ", (Throwable)((Object)pfe));
            }
            catch (XMLParsingException xmlpe) {
                xmlpe.printStackTrace();
                throw new ToolFailureException("ERROR: in parsing processing instructions: ", (Throwable)((Object)xmlpe));
            }
            catch (XMLProcessingException xmlpe) {
                xmlpe.printStackTrace();
                throw new ToolFailureException("ERROR: in loading processing instructions: ", (Throwable)((Object)xmlpe));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new ToolFailureException("ERROR: in reading processing instructions: ", (Throwable)ioe);
            }
        }
        try {
            Debug.assertion((instrux != null ? 1 : 0) != 0);
            String[] generated = codeGen.generate(new Object[]{instrux});
            if (opts.hasOption("nowrite")) {
                return;
            }
            CompilerInvoker compiler = new CompilerInvoker(opts);
            compiler.compile(generated);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new ToolFailureException("ERROR: during code compilation", (Throwable)ioe);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ToolFailureException("ERROR: during code generation", (Throwable)e);
        }
    }
}

