/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.process;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.InputSource;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.xml.process.Functions;
import weblogic.xml.process.GAction;
import weblogic.xml.process.GILoaderBase;
import weblogic.xml.process.InProcessor;
import weblogic.xml.process.ProcessingContext;
import weblogic.xml.process.ProcessorDriver;
import weblogic.xml.process.SAXProcessorException;
import weblogic.xml.process.SAXValidationException;
import weblogic.xml.process.SetAttrValFunctionRef;
import weblogic.xml.process.WriteTextFunctionRef;
import weblogic.xml.process.WriteXmlFunctionRef;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;
import weblogic.xml.process.XMLProcessor;

public final class GILoader
extends GILoaderBase
implements XMLProcessor,
InProcessor {
    private static final boolean debug = true;
    private static final boolean verbose = true;
    private static final Map paths = new HashMap();
    private ProcessorDriver driver;
    private static final String publicId = "-//BEA Systems, Inc.//DTD XML Generating Instructions//EN";
    private static final String localDTDResourceName = "/weblogic/xml/process/java-to-xml.dtd";

    public ProcessorDriver getDriver() {
        return this.driver;
    }

    public GILoader() {
        this(true);
    }

    public GILoader(boolean bl) {
        this.driver = new ProcessorDriver(this, publicId, localDTDResourceName, bl);
    }

    public void process(String string) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(string);
    }

    public void process(File file) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(file);
    }

    public void process(Reader reader) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(reader);
    }

    public void process(InputSource inputSource) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(inputSource);
    }

    public void process(InputStream inputStream) throws IOException, XMLParsingException, XMLProcessingException {
        this.driver.process(inputStream);
    }

    public void preProc(ProcessingContext processingContext) throws SAXProcessorException {
        Debug.assertion((processingContext != null ? 1 : 0) != 0);
        String string = processingContext.getPath();
        Debug.assertion((string != null ? 1 : 0) != 0);
        Integer n = (Integer)paths.get(string);
        if (n == null) {
            return;
        }
        switch (n) {
            case 137: {
                this.__pre_137(processingContext);
                break;
            }
            case 136: {
                this.__pre_136(processingContext);
                break;
            }
            case 139: {
                this.__pre_139(processingContext);
                break;
            }
            case 138: {
                this.__pre_138(processingContext);
                break;
            }
            case 129: {
                this.__pre_129(processingContext);
                break;
            }
            case 128: {
                this.__pre_128(processingContext);
                break;
            }
            case 131: {
                this.__pre_131(processingContext);
                break;
            }
            case 130: {
                this.__pre_130(processingContext);
                break;
            }
            case 133: {
                this.__pre_133(processingContext);
                break;
            }
            case 132: {
                this.__pre_132(processingContext);
                break;
            }
            case 135: {
                this.__pre_135(processingContext);
                break;
            }
            case 134: {
                this.__pre_134(processingContext);
                break;
            }
            default: {
                throw new AssertionError(n.toString());
            }
        }
    }

    public void postProc(ProcessingContext processingContext) throws SAXProcessorException {
        Debug.assertion((processingContext != null ? 1 : 0) != 0);
        String string = processingContext.getPath();
        Debug.assertion((string != null ? 1 : 0) != 0);
        Integer n = (Integer)paths.get(string);
        if (n == null) {
            return;
        }
        switch (n) {
            case 137: {
                this.__post_137(processingContext);
                break;
            }
            case 136: {
                this.__post_136(processingContext);
                break;
            }
            case 139: {
                this.__post_139(processingContext);
                break;
            }
            case 138: {
                this.__post_138(processingContext);
                break;
            }
            case 129: {
                this.__post_129(processingContext);
                break;
            }
            case 128: {
                this.__post_128(processingContext);
                break;
            }
            case 131: {
                this.__post_131(processingContext);
                break;
            }
            case 130: {
                this.__post_130(processingContext);
                break;
            }
            case 133: {
                this.__post_133(processingContext);
                break;
            }
            case 132: {
                this.__post_132(processingContext);
                break;
            }
            case 135: {
                this.__post_135(processingContext);
                break;
            }
            case 134: {
                this.__post_134(processingContext);
                break;
            }
            default: {
                throw new AssertionError(n.toString());
            }
        }
    }

    private void __pre_139(ProcessingContext processingContext) {
    }

    private void __post_139(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        ArrayList arrayList = (ArrayList)processingContext.getBoundObject("args");
        GAction gAction = (GAction)processingContext.getBoundObject("gi");
        ArrayList arrayList2 = (ArrayList)processingContext.getBoundObject("params");
        arrayList.add(string);
    }

    private void __pre_130(ProcessingContext processingContext) {
    }

    private void __post_130(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        this.instrux.setProcessorClass(string);
    }

    private void __pre_128(ProcessingContext processingContext) {
    }

    private void __post_128(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        this.instrux.setProcessorPackage(string);
    }

    private void __pre_137(ProcessingContext processingContext) {
    }

    private void __post_137(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext, "@from-var");
        String string2 = Functions.value(processingContext, "@name");
        GAction gAction = (GAction)processingContext.getBoundObject("gi");
        ArrayList arrayList = (ArrayList)processingContext.getBoundObject("params");
        SetAttrValFunctionRef setAttrValFunctionRef = new SetAttrValFunctionRef(string2);
        String string3 = string;
        if (string3 != null) {
            setAttrValFunctionRef.setFromVar(string3);
        }
        gAction.addCodeFragment(setAttrValFunctionRef);
    }

    private void __pre_135(ProcessingContext processingContext) {
    }

    private void __post_135(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        GAction gAction = (GAction)processingContext.getBoundObject("gi");
        ArrayList arrayList = (ArrayList)processingContext.getBoundObject("params");
        gAction.addCodeFragment(string);
    }

    private void __pre_131(ProcessingContext processingContext) {
    }

    private void __post_131(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        this.instrux.setPublicId(string);
    }

    private void __pre_132(ProcessingContext processingContext) {
    }

    private void __post_132(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        this.instrux.setDtdURL(string);
    }

    private void __pre_133(ProcessingContext processingContext) {
        GAction gAction = new GAction();
        processingContext.addBoundObject(gAction, "gi");
        ArrayList arrayList = new ArrayList();
        processingContext.addBoundObject(arrayList, "params");
    }

    private void __post_133(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext, "@element-context");
        String string2 = Functions.value(processingContext, "@element");
        GAction gAction = (GAction)processingContext.getBoundObject("gi");
        ArrayList arrayList = (ArrayList)processingContext.getBoundObject("params");
        gAction.setElementName(string2);
        gAction.setElementContext(string);
        gAction.setParams(arrayList);
        this.instrux.addGeneratingAction(gAction);
    }

    private void __pre_138(ProcessingContext processingContext) {
        ArrayList arrayList = new ArrayList();
        processingContext.addBoundObject(arrayList, "args");
    }

    private void __post_138(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext, " @from-var ");
        String string2 = Functions.value(processingContext, " @element-context ");
        String string3 = Functions.value(processingContext, " @element ");
        ArrayList arrayList = (ArrayList)processingContext.getBoundObject("args");
        GAction gAction = (GAction)processingContext.getBoundObject("gi");
        ArrayList arrayList2 = (ArrayList)processingContext.getBoundObject("params");
        WriteXmlFunctionRef writeXmlFunctionRef = new WriteXmlFunctionRef(string3, string2);
        if (string != null) {
            writeXmlFunctionRef.setFromVar(string);
        }
        writeXmlFunctionRef.setArgs(arrayList);
        gAction.addCodeFragment(writeXmlFunctionRef);
    }

    private void __pre_134(ProcessingContext processingContext) {
    }

    private void __post_134(ProcessingContext processingContext) throws SAXProcessorException, SAXValidationException {
        String string = Functions.value(processingContext, "@class");
        String string2 = Functions.value(processingContext, "@name");
        GAction gAction = (GAction)processingContext.getBoundObject("gi");
        ArrayList arrayList = (ArrayList)processingContext.getBoundObject("params");
        String string3 = string2;
        String string4 = string;
        try {
            Class<?> clazz = Class.forName(string4);
            arrayList.add(new GAction.Param(string3, clazz));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXValidationException("Invalid class " + string4 + "; could not be loaded");
        }
    }

    private void __pre_136(ProcessingContext processingContext) {
    }

    private void __post_136(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext, "@from-var");
        String string2 = Functions.value(processingContext);
        GAction gAction = (GAction)processingContext.getBoundObject("gi");
        ArrayList arrayList = (ArrayList)processingContext.getBoundObject("params");
        WriteTextFunctionRef writeTextFunctionRef = new WriteTextFunctionRef(string2);
        String string3 = string;
        if (string3 != null) {
            writeTextFunctionRef.setFromVar(string3);
        }
        gAction.addCodeFragment(writeTextFunctionRef);
    }

    private void __pre_129(ProcessingContext processingContext) {
    }

    private void __post_129(ProcessingContext processingContext) throws SAXProcessorException {
        String string = Functions.value(processingContext);
        this.instrux.setProcessorSuperClass(string);
    }

    public void addBoundObject(Object object, String string) {
        this.driver.currentNode().addBoundObject(object, string);
    }

    static {
        paths.put(".java-to-xml.generate-element.java.write-xml.param.", new Integer(139));
        paths.put(".java-to-xml.processor-params.processor-class.", new Integer(130));
        paths.put(".java-to-xml.processor-params.processor-package.", new Integer(128));
        paths.put(".java-to-xml.generate-element.java.set-attribute-value.", new Integer(137));
        paths.put(".java-to-xml.generate-element.java.#text.", new Integer(135));
        paths.put(".java-to-xml.processor-params.xml-public-id.", new Integer(131));
        paths.put(".java-to-xml.processor-params.dtd-url.", new Integer(132));
        paths.put(".java-to-xml.generate-element.", new Integer(133));
        paths.put(".java-to-xml.generate-element.java.write-xml.", new Integer(138));
        paths.put(".java-to-xml.generate-element.declare-param.", new Integer(134));
        paths.put(".java-to-xml.generate-element.java.write-text.", new Integer(136));
        paths.put(".java-to-xml.processor-params.processor-superclass.", new Integer(129));
    }
}

