/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.process;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import weblogic.xml.process.XMLProcessingException;

public abstract class Node {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    public static final String ELEMENT_NAME_SEPARATOR = ".";
    public static final String TEXT_NODE_TAG_NAME = "#text";
    public static final short ELEMENT_NODE = 1;
    public static final short TEXT_NODE = 2;
    protected String name;
    protected short type;
    protected String path;
    protected final Map attributes = new HashMap();
    protected StringBuffer value = new StringBuffer();
    protected Node parent;
    protected final List children = new LinkedList();
    protected int level = 0;

    public Node(String string) throws XMLProcessingException {
        this.name = string;
        this.path = ELEMENT_NAME_SEPARATOR + string + ELEMENT_NAME_SEPARATOR;
        this.parent = null;
        this.type = string.equals(TEXT_NODE_TAG_NAME) ? (short)2 : (short)1;
    }

    protected Node(Node node, String string) throws XMLProcessingException {
        this(string);
        if (node != null) {
            this.parent = node;
            this.path = this.parent.getPath() + string + ELEMENT_NAME_SEPARATOR;
            this.parent.children.add(this);
            this.level = this.parent.level + 1;
        }
    }

    public Node release() throws XMLProcessingException {
        boolean bl = true;
        if (this.parent != null) {
            bl = this.parent.children.remove(this);
        }
        return this.parent;
    }

    public void appendValue(char[] cArray, int n, int n2) {
        this.value.append(cArray, n, n2);
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
    }

    public Collection getAttributeNames() {
        return this.attributes.keySet();
    }

    public String getAttribute(String string) {
        return (String)this.attributes.get(string);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value.toString().trim();
    }

    public void setValue(String string) {
        this.value = new StringBuffer(string != null ? string : "");
    }

    public int getDepth() {
        return this.level;
    }

    public boolean isText() {
        return this.type == 2;
    }

    public List getChildNodes() {
        return this.children;
    }

    public Node getParent() {
        return this.parent;
    }
}

