/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import weblogic.utils.Debug;
import weblogic.utils.collections.MultiMap;
import weblogic.xml.process.DTDInfo;
import weblogic.xml.process.DTDParsingException;
import weblogic.xml.process.SAXProcessorException;

public abstract class PILoaderBase {
    private static final boolean debug = false;
    private MultiMap allPaths = new MultiMap();

    protected void setDTD(String dtdURL) throws SAXProcessorException {
        throw new SAXProcessorException("Not implemented yet");
    }

    protected void setDTD(InputStream dtdResource) throws IOException, DTDParsingException {
        Debug.assertion((dtdResource != null ? 1 : 0) != 0);
        InputStreamReader r = new InputStreamReader(dtdResource);
        DTDInfo dtd = new DTDInfo(r);
        this.addPaths(null, dtd.getNodeTree());
    }

    protected Collection getPaths(String elementName) {
        Debug.assertion((elementName != null ? 1 : 0) != 0);
        return this.allPaths.get((Object)elementName);
    }

    protected boolean isInDTD(String elementName) {
        return this.allPaths.get((Object)elementName) != null;
    }

    protected String[] getPathsFromContext(String elementName, String context) throws SAXProcessorException {
        Debug.assertion((elementName != null ? 1 : 0) != 0);
        ArrayList<String> matches = new ArrayList<String>();
        String pathFrag = null;
        pathFrag = context == null || context.length() == 0 ? "." + elementName + "." : "." + context + "." + elementName + ".";
        Collection c = this.getPaths(elementName);
        if (c == null) {
            return null;
        }
        for (String path : c) {
            if (!path.endsWith(pathFrag)) continue;
            matches.add(path);
        }
        if (matches.size() > 1) {
            // empty if block
        }
        return matches.toArray(new String[0]);
    }

    private void addPaths(StringBuffer sbuf, DTDInfo.DTDNode n) {
        sbuf = sbuf == null ? new StringBuffer(".") : new StringBuffer(sbuf.toString());
        String name = n.getName();
        sbuf.append(name + ".");
        this.allPaths.put((Object)name, (Object)sbuf.toString());
        String textNodeTagName = "#text";
        String textNodePath = sbuf.toString() + textNodeTagName + ".";
        this.allPaths.put((Object)textNodeTagName, (Object)textNodePath);
        Iterator i = n.getChildren().iterator();
        while (i.hasNext()) {
            this.addPaths(sbuf, (DTDInfo.DTDNode)i.next());
        }
    }
}

