/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.process;

import java.util.HashMap;
import java.util.Map;
import weblogic.utils.AssertionError;
import weblogic.xml.process.Node;
import weblogic.xml.process.XMLProcessingException;

public class ProcessingContext
extends Node {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    private boolean referenced = false;
    private final Map bound = new HashMap();

    public ProcessingContext(String string) throws XMLProcessingException {
        super(string);
    }

    public ProcessingContext(ProcessingContext processingContext, String string) throws XMLProcessingException {
        super(processingContext, string);
    }

    public ProcessingContext newTextNode() {
        ProcessingContext processingContext = this.newElementNode("#text");
        processingContext.referenced = true;
        return processingContext;
    }

    public ProcessingContext newElementNode(String string) {
        ProcessingContext processingContext = null;
        try {
            processingContext = new ProcessingContext(this, string);
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new AssertionError((Throwable)((Object)xMLProcessingException));
        }
        processingContext.bound.putAll(this.getAllBoundObjects());
        return processingContext;
    }

    public void addBoundObject(Object object, String string) {
        this.bound.put(string, object);
    }

    public void addBoundObjects(Map map) {
        this.bound.putAll(map);
    }

    public Object getBoundObject(String string) {
        return this.bound.get(string);
    }

    public Map getAllBoundObjects() {
        return this.bound;
    }

    public void setReferenced(boolean bl) {
        this.referenced = bl;
    }

    public boolean referenced() {
        return this.referenced;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name = " + this.name);
        stringBuffer.append("\npath = " + this.path);
        stringBuffer.append("\nvalue = " + this.value);
        stringBuffer.append("\nbound objects = ");
        for (String string : this.bound.keySet()) {
            Object v = this.bound.get(string);
            stringBuffer.append("\n\t" + string + " = " + v.getClass().getName() + "[" + v.hashCode() + "]");
        }
        return stringBuffer.toString();
    }
}

