/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import weblogic.utils.AssertionError;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.StringUtils;
import weblogic.utils.collections.CombinedIterator;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;
import weblogic.xml.process.Binding;
import weblogic.xml.process.FunctionRef;
import weblogic.xml.process.PAction;
import weblogic.xml.process.PActionCode;
import weblogic.xml.process.ProcessingInstructions;
import weblogic.xml.process.Validation;
import weblogic.xml.process.XPathFunctionRef;

public class ProcessorCompiler
extends CodeGenerator {
    private static final boolean debug = false;
    private static final boolean verbose = false;
    static final String EMPTY_STRING = new String();
    static final String PREPROC_METHOD_PREFIX = "__pre_";
    static final String POSTPROC_METHOD_PREFIX = "__post_";
    static final String TEMPLATE_FILE_NAME = "processor.j";
    private ProcessingInstructions instrux;
    private Map actionTable = new HashMap();
    private Map actionIDMap = new HashMap();
    private PAction currentAction;
    private PActionCode currentActionCode;
    private boolean generateMain = false;

    public ProcessorCompiler(Getopt2 opts) {
        super(opts);
        this.generateMain = opts.hasOption("generatemain");
    }

    public Enumeration outputs(Object[] inputs) throws Exception {
        Debug.assertion((inputs.length == 1 ? 1 : 0) != 0);
        Output out = new Output();
        try {
            out.setProcessingInstructions((ProcessingInstructions)inputs[0]);
        }
        catch (ClassCastException cce) {
            throw new AssertionError((Throwable)cce);
        }
        return new Vector<Object>(Arrays.asList((Object[])new Output[]{out})).elements();
    }

    protected void prepare(CodeGenerator.Output output) {
        this.instrux = ((Output)output).getProcessingInstructions();
        Debug.assertion((this.instrux != null ? 1 : 0) != 0);
    }

    public String main_method() throws CodeGenerationException {
        if (this.generateMain) {
            return this.parse(this.getProductionRule("main_method_code"));
        }
        return new String();
    }

    public String processor_package_decl() {
        return "package " + this.instrux.getProcessorPackage() + ";";
    }

    public String processor_class() {
        return this.instrux.getProcessorClass();
    }

    public String extends_super_class() {
        String superClassName = this.instrux.getProcessorSuperClass();
        if (superClassName == null) {
            return EMPTY_STRING;
        }
        return "extends " + superClassName;
    }

    public String public_id_decl() {
        if (this.instrux.getLocalDTDResourceName() != null) {
            return "private static final String publicId = \n  \"" + this.instrux.getPublicId() + "\";";
        }
        return EMPTY_STRING;
    }

    public String get_processor_driver() {
        if (this.instrux.getLocalDTDResourceName() != null) {
            return "new ProcessorDriver(this, publicId, localDTDResourceName, validate)";
        }
        return "new ProcessorDriver(this, validate)";
    }

    public String local_dtd_decl() {
        String localDtd = this.instrux.getLocalDTDResourceName();
        if (localDtd != null) {
            return "private static final String localDTDResourceName = \n  \"" + localDtd + "\";";
        }
        return EMPTY_STRING;
    }

    public String init_paths() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("  static {\n");
        Collection actions = this.instrux.getAllProcessingActions();
        for (PAction a : actions) {
            int actionId = a.getId();
            String[] paths = a.getPaths();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                sbuf.append("    paths.put(\n      \"" + path + "\",\n" + "      new Integer(" + actionId + ")\n" + "    );\n");
                this.actionTable.put(path, new Integer(actionId));
                this.actionIDMap.put(new Integer(actionId), a);
            }
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    public String preproc_dispatch() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("    switch (id.intValue()) {\n");
        for (Integer actionId : this.actionIDMap.keySet()) {
            sbuf.append("      case " + actionId + ": {\n");
            sbuf.append("        __pre_" + actionId + "(pctx);\n");
            if (((PAction)this.actionIDMap.get(actionId)).isStartAction()) {
                sbuf.append("       //phase=\"element-start\"\n");
                sbuf.append("        __post_" + actionId + "(pctx);\n");
            }
            sbuf.append("        break;\n");
            sbuf.append("      }\n");
        }
        sbuf.append("      default: {\n");
        sbuf.append("        throw new AssertionError(id.toString());\n");
        sbuf.append("      }\n");
        sbuf.append("    }\n");
        return sbuf.toString();
    }

    public String postproc_dispatch() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("    switch (id.intValue()) {\n");
        for (Integer actionId : this.actionIDMap.keySet()) {
            sbuf.append("      case " + actionId + ": {\n");
            if (!((PAction)this.actionIDMap.get(actionId)).isStartAction()) {
                sbuf.append("        __post_" + actionId + "(pctx);\n");
            } else {
                sbuf.append("        //phase=\"element-start\"\n");
            }
            sbuf.append("        break;\n");
            sbuf.append("      }\n");
        }
        sbuf.append("      default: {\n");
        sbuf.append("        throw new AssertionError(id.toString());\n");
        sbuf.append("      }\n");
        sbuf.append("    }\n");
        return sbuf.toString();
    }

    public String element_processing_dispatches() throws CodeGenerationException {
        StringBuffer sbuf = new StringBuffer();
        Collection actions = this.instrux.getAllProcessingActions();
        for (PAction this.currentAction : actions) {
            this.currentActionCode = new PActionCode(this.currentAction);
            sbuf.append(this.parse(this.getProductionRule("element_processing_dispatch")));
        }
        return sbuf.toString();
    }

    public String element_path() {
        Debug.assertion((this.currentAction != null ? 1 : 0) != 0);
        String[] paths = this.currentAction.getPaths();
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            sbuf.append("\n   *   " + paths[i]);
        }
        return sbuf.toString();
    }

    public String document_scope_binding_getters() {
        Debug.assertion((this.currentAction != null ? 1 : 0) != 0);
        Debug.assertion((this.currentActionCode != null ? 1 : 0) != 0);
        StringBuffer sbuf = new StringBuffer();
        Collection bindings = this.currentAction.getBindings();
        if (bindings != null && bindings.size() > 0) {
            for (Binding b : bindings) {
                if (!b.hasDocumentScope()) continue;
                String className = b.getClassName();
                String varName = b.getVariableName();
                sbuf.append("private " + className + " " + varName + ";\n");
                sbuf.append(ProcessorCompiler.getAGetter(className, varName) + "\n");
            }
        }
        return sbuf.toString();
    }

    public String element_preproc_method() {
        Debug.assertion((this.currentAction != null ? 1 : 0) != 0);
        int pathId = this.currentAction.getId();
        return PREPROC_METHOD_PREFIX + pathId;
    }

    public String element_postproc_method() {
        Debug.assertion((this.currentAction != null ? 1 : 0) != 0);
        int pathId = this.currentAction.getId();
        return POSTPROC_METHOD_PREFIX + pathId;
    }

    public String throws_processing_exceptions() {
        Debug.assertion((this.currentAction != null ? 1 : 0) != 0);
        Debug.assertion((this.currentActionCode != null ? 1 : 0) != 0);
        StringBuffer sbuf = new StringBuffer();
        String javaCode = this.currentActionCode.getJavaCode();
        if (javaCode != null) {
            sbuf.append("SAXProcessorException");
        }
        if (this.currentAction.getValidation() != null || javaCode != null && javaCode.indexOf("SAXValidationException") >= 0) {
            if (sbuf.length() == 0) {
                sbuf.append("SAXValidationException");
            } else {
                sbuf.append(", SAXValidationException");
            }
        }
        if (sbuf.length() > 0) {
            return "throws " + sbuf.toString();
        }
        return new String();
    }

    public String new_bindings() {
        Debug.assertion((this.currentAction != null ? 1 : 0) != 0);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("// bindings: ");
        HashSet varNames = new HashSet();
        Collection bindings = this.currentAction.getBindings();
        if (bindings.size() == 0) {
            sbuf.append("none\n");
        } else {
            sbuf.append("\n");
            for (Binding b : bindings) {
                String className = b.getClassName();
                String varName = b.getVariableName();
                if (b.hasDocumentScope()) {
                    if (!b.isInitialize()) continue;
                    sbuf.append("    " + varName + " = new " + className + "();\n");
                    continue;
                }
                sbuf.append("    " + className + " " + varName + " =");
                if (b.isInitialize()) {
                    sbuf.append(" new " + className + "();\n");
                } else {
                    sbuf.append(" null;\n");
                }
                sbuf.append("    pctx.addBoundObject(" + varName + ", \"" + varName + "\");\n");
            }
        }
        return sbuf.toString();
    }

    public String fetch_function_values() throws CodeGenerationException {
        StringBuffer sbuf = new StringBuffer();
        Debug.assertion((this.currentActionCode != null ? 1 : 0) != 0);
        for (Map.Entry ent : this.currentActionCode.getFunctionRefs().entrySet()) {
            FunctionRef fref = (FunctionRef)ent.getKey();
            String varName = (String)ent.getValue();
            String functionCall = ProcessorCompiler.getFunctionCallSyntax(fref);
            sbuf.append("String " + varName + " = " + functionCall + ";\n");
        }
        return sbuf.toString();
    }

    public String fetch_bound_objects() {
        Debug.assertion((this.currentAction != null ? 1 : 0) != 0);
        StringBuffer sbuf = new StringBuffer();
        Iterator bi = this.getAllBindingsIterator(this.currentAction);
        HashSet bindingVars = new HashSet();
        while (bi.hasNext()) {
            Binding b = (Binding)bi.next();
            if (b.hasDocumentScope()) continue;
            String varName = b.getVariableName();
            String className = b.getClassName();
            sbuf.append("    " + className + " " + varName + " = " + "(" + className + ")pctx.getBoundObject(\"" + varName + "\");\n");
        }
        return sbuf.toString();
    }

    public String validations() throws CodeGenerationException {
        Debug.assertion((this.currentAction != null ? 1 : 0) != 0);
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("// validations: ");
        Validation validation = this.currentAction.getValidation();
        if (validation == null) {
            sbuf.append("none\n");
        } else {
            Validation v;
            List validVals;
            sbuf.append('\n');
            String valueVarName = this.element_value_variable();
            if (!validation.isNullable()) {
                sbuf.append("    if (" + valueVarName + ".length() == 0) ");
                sbuf.append(ProcessorCompiler.getValidationErrorThrow(this.currentAction + " must be a non-empty string"));
                sbuf.append('\n');
            }
            if ((validVals = validation.getValidValues()) != null && validVals.size() > 0) {
                sbuf.append("    if (");
                for (int i = 0; i < validVals.size(); ++i) {
                    String value = (String)validVals.get(i);
                    if (i > 0) {
                        sbuf.append(" && ");
                    }
                    sbuf.append("!\"" + value + "\".equals(" + valueVarName + ")");
                }
                sbuf.append(") ");
                String possibleValues = StringUtils.join((String[])validVals.toArray(new String[0]), (String)",");
                sbuf.append(ProcessorCompiler.getValidationErrorThrow(this.currentAction + " must be one of the values: " + possibleValues) + "\n");
            }
            if ((v = this.currentAction.getValidation()) != null && v.getMethodName() != null) {
                sbuf.append(this.parse(this.getProductionRule("invoke_validation_method")));
            }
        }
        return sbuf.toString();
    }

    public String validation_method_name() {
        Debug.assertion((this.currentAction != null ? 1 : 0) != 0);
        Validation v = this.currentAction.getValidation();
        Debug.assertion((v != null ? 1 : 0) != 0);
        String methodName = v.getMethodName();
        Debug.assertion((methodName != null ? 1 : 0) != 0);
        return methodName;
    }

    public String element_value_variable() {
        Debug.assertion((this.currentActionCode != null ? 1 : 0) != 0);
        String varName = this.currentActionCode.getFunctionValueVarName(new XPathFunctionRef("VALUE", ""));
        return varName;
    }

    public String post_actions() {
        Debug.assertion((this.currentActionCode != null ? 1 : 0) != 0);
        this.currentActionCode.replaceFunctionRefs();
        String javaCode = this.currentActionCode.getJavaCode();
        if (javaCode == null) {
            return new String();
        }
        return javaCode;
    }

    protected Iterator getAllBindingsIterator(PAction action) {
        Debug.assertion((this.instrux != null ? 1 : 0) != 0);
        ArrayList l = new ArrayList();
        String[] paths = action.getPaths();
        for (int pi = 0; pi < paths.length; ++pi) {
            String path = paths[pi];
            int i = path.length() - 1;
            while (i > 0) {
                path = path.substring(0, i);
                i = path.lastIndexOf(46);
                PAction a = this.instrux.getProcessingAction(path + ".");
                if (a == null) continue;
                l.add(a.getBindings().iterator());
            }
        }
        return new CombinedIterator(l);
    }

    protected static String getValidationErrorThrow(String msg) {
        return "throw new SAXValidationException(\"" + msg + "\");";
    }

    protected static String getAGetter(String className, String varName) {
        Debug.assertion((className != null ? 1 : 0) != 0);
        Debug.assertion((varName != null ? 1 : 0) != 0);
        String rootClassName = ProcessorCompiler.getRootClassName(className);
        return "public " + className + " get" + rootClassName + "() { return " + varName + "; }";
    }

    protected static String getPackageName(String className) {
        Debug.assertion((className != null ? 1 : 0) != 0);
        int i = className.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        return className.substring(0, i);
    }

    protected static String getRootClassName(String fullClassName) {
        Debug.assertion((fullClassName != null ? 1 : 0) != 0);
        int i = fullClassName.lastIndexOf(46);
        if (i == -1) {
            return fullClassName;
        }
        return fullClassName.substring(i + 1);
    }

    protected static String getFunctionCallSyntax(FunctionRef fref) throws CodeGenerationException {
        String fname = fref.getName();
        if ("VALUE".equalsIgnoreCase(fname) && fref instanceof XPathFunctionRef) {
            String expr = ((XPathFunctionRef)fref).getExpr();
            if (expr.length() > 0) {
                return "Functions.value(pctx,\"" + expr + "\")";
            }
            return "Functions.value(pctx)";
        }
        throw new CodeGenerationException("Unrecognized function call: " + fref);
    }

    public static class Output
    extends CodeGenerator.Output
    implements Cloneable {
        private ProcessingInstructions pi;

        public Output() {
            this.setTemplate(ProcessorCompiler.TEMPLATE_FILE_NAME);
        }

        public void setProcessingInstructions(ProcessingInstructions p) {
            this.pi = p;
            this.setOutputFile(ProcessorCompiler.getRootClassName(p.getProcessorClass()) + ".java");
            this.setPackage(p.getProcessorPackage());
        }

        public ProcessingInstructions getProcessingInstructions() {
            return this.pi;
        }
    }
}

