/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import weblogic.utils.AssertionError;
import weblogic.xml.dom.ResourceEntityResolver;
import weblogic.xml.jaxp.WebLogicSAXParserFactory;
import weblogic.xml.process.InProcessor;
import weblogic.xml.process.ProcessingContext;
import weblogic.xml.process.SAXProcessorException;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public final class ProcessorDriver
extends HandlerBase {
    private static final boolean debug = false;
    private static final boolean verboseSAX = false;
    private static final boolean verboseProcessor = false;
    private InProcessor processor;
    private ProcessingContext procTree;
    private ProcessingContext currentNode;
    private Parser parser;
    int level = 0;

    public ProcessorDriver(InProcessor inProcessor, String string, String string2, boolean bl) {
        this.processor = inProcessor;
        this.setupSAXParser(string, string2, bl);
    }

    public ProcessorDriver(InProcessor inProcessor, boolean bl) {
        this(inProcessor, null, null, bl);
    }

    public void setCustomErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler != null && this.parser != null) {
            this.parser.setErrorHandler(errorHandler);
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            ProcessingContext processingContext = this.currentNode();
            if (processingContext != null && processingContext.isText()) {
                this.postProc();
                processingContext = this.popNode();
            }
            processingContext = this.pushNewNode(string);
            this.setAttributes(processingContext, attributeList);
            this.preProc();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string) throws SAXException {
        ProcessingContext processingContext = this.currentNode();
        if (processingContext.isText()) {
            try {
                this.postProc();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                processingContext = this.popNode();
                throw throwable;
            }
            processingContext = this.popNode();
            {
            }
        }
        try {
            this.postProc();
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            processingContext = this.popNode();
            throw throwable;
        }
        processingContext = this.popNode();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        ProcessingContext processingContext = this.currentNode();
        if (!processingContext.isText()) {
            processingContext = this.pushNewTextNode();
            this.preProc();
        }
        processingContext.appendValue(cArray, n, n2);
    }

    public void process(String string) throws IOException, XMLProcessingException, XMLParsingException {
        this.process(new File(string));
    }

    public void process(File file) throws IOException, XMLProcessingException, XMLParsingException {
        this.process(new FileInputStream(file));
    }

    public void process(InputStream inputStream) throws IOException, XMLProcessingException, XMLParsingException {
        try {
            InputSource inputSource = new InputSource(inputStream);
            this.parser.parse(inputSource);
        }
        catch (SAXProcessorException sAXProcessorException) {
            throw new XMLProcessingException(sAXProcessorException);
        }
        catch (SAXException sAXException) {
            throw new XMLParsingException(sAXException);
        }
    }

    public void process(Reader reader) throws IOException, XMLProcessingException, XMLParsingException {
        try {
            InputSource inputSource = new InputSource(reader);
            this.parser.parse(inputSource);
        }
        catch (SAXProcessorException sAXProcessorException) {
            throw new XMLProcessingException(sAXProcessorException);
        }
        catch (SAXException sAXException) {
            throw new XMLParsingException(sAXException);
        }
    }

    public void process(InputSource inputSource) throws IOException, XMLProcessingException, XMLParsingException {
        try {
            this.parser.parse(inputSource);
        }
        catch (SAXProcessorException sAXProcessorException) {
            throw new XMLProcessingException(sAXProcessorException);
        }
        catch (SAXException sAXException) {
            throw new XMLParsingException(sAXException);
        }
    }

    private void preProc() throws SAXException {
        ProcessingContext processingContext = this.currentNode();
        try {
            this.processor.preProc(processingContext);
        }
        catch (SAXException sAXException) {
            this.popNode();
            throw sAXException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    private void postProc() throws SAXException {
        ProcessingContext processingContext = this.currentNode();
        try {
            this.processor.postProc(processingContext);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    private ProcessingContext popNode() throws SAXException {
        ProcessingContext processingContext = this.currentNode();
        ProcessingContext processingContext2 = (ProcessingContext)processingContext.getParent();
        try {
            if (!processingContext.referenced()) {
                processingContext.release();
            }
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new AssertionError((Throwable)((Object)xMLProcessingException));
        }
        if (processingContext2 != null) {
            this.setCurrentNode(processingContext2);
        }
        return processingContext2;
    }

    private ProcessingContext pushNewTextNode() {
        ProcessingContext processingContext = this.currentNode();
        ProcessingContext processingContext2 = processingContext.newTextNode();
        this.setCurrentNode(processingContext2);
        return processingContext2;
    }

    private ProcessingContext pushNewNode(String string) {
        ProcessingContext processingContext = this.currentNode();
        ProcessingContext processingContext2 = null;
        try {
            processingContext2 = processingContext != null ? processingContext.newElementNode(string) : new ProcessingContext(string);
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new AssertionError((Throwable)((Object)xMLProcessingException));
        }
        this.setCurrentNode(processingContext2);
        return processingContext2;
    }

    public ProcessingContext currentNode() {
        return this.currentNode;
    }

    private void setCurrentNode(ProcessingContext processingContext) {
        this.currentNode = processingContext;
    }

    private void setAttributes(ProcessingContext processingContext, AttributeList attributeList) {
        for (int i = 0; i < attributeList.getLength(); ++i) {
            processingContext.setAttribute(attributeList.getName(i), attributeList.getValue(i));
        }
    }

    private void setupSAXParser(String string, String string2, boolean bl) {
        Object object;
        try {
            object = new WebLogicSAXParserFactory();
            ((WebLogicSAXParserFactory)object).setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            ((WebLogicSAXParserFactory)object).setValidating(bl);
            SAXParser sAXParser = ((WebLogicSAXParserFactory)object).newSAXParser();
            this.parser = sAXParser.getParser();
        }
        catch (Exception exception) {
            throw new AssertionError((Throwable)exception);
        }
        this.parser.setErrorHandler(new HandlerBase(){

            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }
        });
        if (string2 != null) {
            object = new ResourceEntityResolver();
            ((ResourceEntityResolver)object).setUnresolvedIsFatal(true);
            ((ResourceEntityResolver)object).addEntityResource(string, string2);
            this.parser.setEntityResolver((EntityResolver)object);
        }
        this.parser.setDocumentHandler(this);
    }
}

