/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.process;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import weblogic.ejb.container.EJBTextTextFormatter;
import weblogic.ejb.spi.XMLConstants;
import weblogic.utils.AssertionError;
import weblogic.xml.process.ParsingUtils;
import weblogic.xml.process.ProcessorConstants;
import weblogic.xml.process.ProcessorFactoryException;
import weblogic.xml.process.XMLProcessor;

public class ProcessorFactory {
    public static final String PROCESS_FACTORY_DEBUG = "weblogic.xml.process.debug";
    private static boolean debug;
    private static final String DOCTYPE_DECL_START = "<!DOCTYPE";
    private static final String PUBLIC_DECL_START = "PUBLIC";
    private static final String[] QUOTES;
    private boolean validate = true;
    Map registeredProcessors = new HashMap();

    public ProcessorFactory() {
        debug = Boolean.getBoolean(PROCESS_FACTORY_DEBUG);
        this.loadRegistry();
    }

    public ProcessorFactory(Map map) {
        debug = Boolean.getBoolean(PROCESS_FACTORY_DEBUG);
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            this.registerProcessor(string, string2);
        }
    }

    private void loadRegistry() {
        this.registerProcessor(ProcessorConstants.XML_TO_JAVA_PUBLIC_ID(), ProcessorConstants.XML_TO_JAVA_LOADER_CLASS());
        this.registerProcessor(ProcessorConstants.JAVA_TO_XML_PUBLIC_ID(), ProcessorConstants.JAVA_TO_XML_LOADER_CLASS());
        this.registerProcessors(XMLConstants.processors);
        this.registerProcessor("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "weblogic.j2ee.dd.xml.J2EEDeploymentDescriptorLoader_J2EE12");
        this.registerProcessor("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "weblogic.j2ee.dd.xml.J2EEDeploymentDescriptorLoader_J2EE13");
        this.registerProcessor("-//BEA Systems, Inc.//DTD WebLogic Application 7.0.0//EN", "weblogic.j2ee.dd.xml.WebLogicApplication_1_0");
        this.registerProcessor("-//BEA Systems, Inc.//DTD WebLogic Application 8.1.0//EN", "weblogic.j2ee.dd.xml.WebLogicApplication_2_0");
        this.registerProcessor("-//BEA Systems, Inc.//DTD WebLogic Application 9.0.0//EN", "weblogic.j2ee.dd.xml.WebLogicApplication_3_0");
    }

    private void registerProcessors(Map map) {
        for (String string : map.keySet()) {
            this.registerProcessor(string, (String)map.get(string));
        }
    }

    private void registerProcessor(String string, String string2) {
        if (debug) {
            System.out.println("Registering " + string2 + " for " + string);
        }
        this.registeredProcessors.put(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLProcessor getProcessor(String string, String[] stringArray) throws ProcessorFactoryException {
        XMLProcessor xMLProcessor;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            throw new ProcessorFactoryException(iOException);
        }
        try {
            xMLProcessor = this.getProcessor(fileInputStream, stringArray);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xMLProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLProcessor getProcessor(File file, String[] stringArray) throws ProcessorFactoryException {
        XMLProcessor xMLProcessor;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new ProcessorFactoryException(iOException);
        }
        try {
            xMLProcessor = this.getProcessor(fileInputStream, stringArray);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xMLProcessor;
    }

    public XMLProcessor getProcessor(InputStream inputStream, String[] stringArray) throws ProcessorFactoryException {
        return this.getProcessor(inputStream, false, stringArray);
    }

    public XMLProcessor getProcessor(Reader reader, String[] stringArray) throws ProcessorFactoryException {
        return this.getProcessor(reader, false, stringArray);
    }

    public XMLProcessor getProcessor(InputStream inputStream, boolean bl, String[] stringArray) throws ProcessorFactoryException {
        try {
            String string;
            String string2 = this.readPublicId(inputStream, bl);
            if (string2 != null) {
                string2 = string2.trim();
            }
            if ((string = (String)this.registeredProcessors.get(string2)) == null) {
                if (debug) {
                    System.out.println("Failed to find publicid = \"" + string2 + "\"");
                    System.out.println("processor registry = " + this.registeredProcessors);
                }
                EJBTextTextFormatter eJBTextTextFormatter = new EJBTextTextFormatter();
                String string3 = eJBTextTextFormatter.INVALID_PUBLIC_ID(string2);
                if (stringArray != null && stringArray.length > 0) {
                    String string4 = "\n";
                    for (int i = 0; i < stringArray.length; ++i) {
                        string4 = string4 + "\"" + stringArray[i] + "\"\n";
                    }
                    string3 = string3 + "  " + eJBTextTextFormatter.USE_VALID_ID(string4);
                }
                throw new ProcessorFactoryException(string3);
            }
            Constructor<?> constructor = Class.forName(string).getConstructor(Boolean.TYPE);
            return (XMLProcessor)constructor.newInstance(new Boolean(this.validate));
        }
        catch (EOFException eOFException) {
            throw new ProcessorFactoryException("XML document does not appear to contain a properly formed DOCTYPE header");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("Cannot find boolean constructor of processor");
        }
        catch (SecurityException securityException) {
            throw new AssertionError("Cannot invoke boolean constructor of processor", (Throwable)securityException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError("Cannot invoke boolean constructor of processor", (Throwable)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProcessorFactoryException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new ProcessorFactoryException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ProcessorFactoryException(illegalAccessException);
        }
        catch (IOException iOException) {
            throw new ProcessorFactoryException(iOException);
        }
    }

    public XMLProcessor getProcessor(Reader reader, boolean bl, String[] stringArray) throws ProcessorFactoryException {
        try {
            String string = this.readPublicId(reader, bl);
            String string2 = (String)this.registeredProcessors.get(string);
            if (string2 == null) {
                if (debug) {
                    System.out.println("Failed to find publicid = \"" + string + "\"");
                    System.out.println("processor registry = " + this.registeredProcessors);
                }
                EJBTextTextFormatter eJBTextTextFormatter = new EJBTextTextFormatter();
                String string3 = eJBTextTextFormatter.INVALID_PUBLIC_ID(string);
                if (stringArray != null && stringArray.length > 0) {
                    String string4 = "\n";
                    for (int i = 0; i < stringArray.length; ++i) {
                        string4 = string4 + "\"" + stringArray[i] + "\"\n";
                    }
                    string3 = string3 + "  " + eJBTextTextFormatter.USE_VALID_ID(string4);
                }
                throw new ProcessorFactoryException(string3);
            }
            Constructor<?> constructor = Class.forName(string2).getConstructor(Boolean.TYPE);
            return (XMLProcessor)constructor.newInstance(new Boolean(this.validate));
        }
        catch (EOFException eOFException) {
            throw new ProcessorFactoryException("XML document does not appear to contain a properly formed DOCTYPE header");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError("Cannot find boolean constructor of processor");
        }
        catch (SecurityException securityException) {
            throw new AssertionError("Cannot invoke boolean constructor of processor", (Throwable)securityException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError("Cannot invoke boolean constructor of processor", (Throwable)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProcessorFactoryException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new ProcessorFactoryException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ProcessorFactoryException(illegalAccessException);
        }
        catch (IOException iOException) {
            throw new ProcessorFactoryException(iOException);
        }
    }

    public void setValidating(boolean bl) {
        this.validate = bl;
    }

    public boolean isValidating() {
        return this.validate;
    }

    private String readPublicId(InputStream inputStream, boolean bl) throws IOException {
        String string;
        block11: {
            bl &= inputStream.markSupported();
            if (debug) {
                System.out.println("readPublicId: Reset = " + bl);
            }
            if (bl) {
                inputStream.mark(1000);
            }
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
            if (debug) {
                System.out.println("reading through <!DOCTYPE");
            }
            ParsingUtils.read(pushbackInputStream, DOCTYPE_DECL_START, true);
            if (debug) {
                System.out.println("reading through WS");
            }
            ParsingUtils.readWS(pushbackInputStream);
            if (debug) {
                System.out.println("reading through PUBLIC");
            }
            ParsingUtils.read(pushbackInputStream, PUBLIC_DECL_START, true);
            if (debug) {
                System.out.println("reading through first quote");
            }
            String string2 = ParsingUtils.read(pushbackInputStream, QUOTES, true);
            char c = string2.charAt(string2.length() - 1);
            String string3 = new String(new char[]{c});
            if (debug) {
                System.out.println("reading until close quote");
            }
            string = ParsingUtils.read(pushbackInputStream, string3, false);
            if (bl) {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    if (!debug) break block11;
                    iOException.printStackTrace();
                }
            }
        }
        if (debug) {
            System.out.println("Read publicId = " + string);
        }
        return string;
    }

    private String readPublicId(Reader reader, boolean bl) throws IOException {
        String string;
        block13: {
            bl &= reader.markSupported();
            if (debug) {
                System.out.println("readPublicId: Reset = " + bl);
            }
            if (bl) {
                try {
                    reader.mark(1000);
                }
                catch (IOException iOException) {
                    bl = false;
                }
            }
            PushbackReader pushbackReader = new PushbackReader(reader);
            if (debug) {
                System.out.println("reading through <!DOCTYPE");
            }
            ParsingUtils.read(pushbackReader, DOCTYPE_DECL_START, true);
            if (debug) {
                System.out.println("reading through WS");
            }
            ParsingUtils.readWS(pushbackReader);
            if (debug) {
                System.out.println("reading through PUBLIC");
            }
            ParsingUtils.read(pushbackReader, PUBLIC_DECL_START, true);
            if (debug) {
                System.out.println("reading through first quote");
            }
            String string2 = ParsingUtils.read(pushbackReader, QUOTES, true);
            char c = string2.charAt(string2.length() - 1);
            String string3 = new String(new char[]{c});
            if (debug) {
                System.out.println("reading until close quote");
            }
            string = ParsingUtils.read(pushbackReader, string3, false);
            if (bl) {
                try {
                    reader.reset();
                }
                catch (IOException iOException) {
                    if (!debug) break block13;
                    iOException.printStackTrace();
                }
            }
        }
        if (debug) {
            System.out.println("Read publicId = " + string);
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        if (debug) {
            ProcessorFactory processorFactory = new ProcessorFactory();
            FileReader fileReader = new FileReader(stringArray[0]);
            System.out.println("public id = " + processorFactory.readPublicId(fileReader, false));
        }
    }

    static {
        QUOTES = new String[]{"\"", "'"};
    }
}

