/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.process;

import org.xml.sax.SAXParseException;
import weblogic.utils.NestedException;

public class XMLParsingException
extends NestedException {
    private static final long serialVersionUID = -6330961353409169997L;
    protected String fileName;

    public XMLParsingException(String string) {
        super(string);
    }

    public XMLParsingException(Throwable throwable) {
        super(throwable);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMessage() {
        return this.getMessagePrefix() + super.getMessage();
    }

    public String toString() {
        return this.getMessagePrefix() + super.toString();
    }

    private String getMessagePrefix() {
        StringBuffer stringBuffer = new StringBuffer();
        Throwable throwable = this.getNestedException();
        boolean bl = throwable instanceof SAXParseException;
        if (this.fileName != null || bl) {
            stringBuffer.append("Error parsing file ");
            if (this.fileName != null) {
                stringBuffer.append('\'');
                stringBuffer.append(this.fileName);
                stringBuffer.append('\'');
                if (bl) {
                    stringBuffer.append(" ");
                } else {
                    stringBuffer.append(".  ");
                }
            }
            if (bl) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                stringBuffer.append("at line: ");
                stringBuffer.append(sAXParseException.getLineNumber());
                stringBuffer.append(" column: ");
                stringBuffer.append(sAXParseException.getColumnNumber());
                stringBuffer.append(".  ");
            }
        }
        return stringBuffer.toString();
    }
}

