/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.registry;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.xml.sax.InputSource;
import weblogic.xml.XMLLogger;
import weblogic.xml.registry.CacheKey;
import weblogic.xml.registry.XMLRegistry;
import weblogic.xml.registry.XMLRegistryException;
import weblogic.xml.registry.XMLRegistryExceptionCacheEntryExpired;
import weblogic.xml.util.InputSourceUtil;
import weblogic.xml.util.XMLConstants;
import weblogic.xml.util.cache.entitycache.CX;
import weblogic.xml.util.cache.entitycache.CacheEntry;

public final class EntityCache
implements XMLConstants {
    XMLRegistry registry = null;
    weblogic.xml.util.cache.entitycache.EntityCache underlyingCache = null;
    private weblogic.xml.util.cache.entitycache.EntityCache cache = null;

    public EntityCache(XMLRegistry xMLRegistry, weblogic.xml.util.cache.entitycache.EntityCache entityCache) {
        this.registry = xMLRegistry;
        this.underlyingCache = entityCache;
    }

    private weblogic.xml.util.cache.entitycache.EntityCache getCache() throws XMLRegistryException {
        return this.underlyingCache;
    }

    public void setMemorySize(int n) throws XMLRegistryException {
        if (this.underlyingCache == null) {
            return;
        }
        try {
            this.underlyingCache.setMemoryFootprint(n);
        }
        catch (CX.EntityCacheException entityCacheException) {
            throw new XMLRegistryException("Can't set Cache Memory Size", entityCacheException);
        }
    }

    public void setDiskSize(int n) throws XMLRegistryException {
        if (this.underlyingCache == null) {
            return;
        }
        try {
            this.underlyingCache.setDiskFootprint(n);
        }
        catch (CX.EntityCacheException entityCacheException) {
            throw new XMLRegistryException("Can't set Cache Disk Size", entityCacheException);
        }
    }

    public void add(InputSource inputSource, boolean bl, int n) throws XMLRegistryException, CX.EntryTooLarge {
        if (this.underlyingCache == null) {
            return;
        }
        CacheEntry cacheEntry = null;
        byte[] byArray = null;
        CacheKey cacheKey = null;
        try {
            byArray = InputSourceUtil.forceGetInputByteData(inputSource);
            cacheKey = new CacheKey(this.registry.getName(), inputSource.getPublicId(), inputSource.getSystemId());
            cacheEntry = new CacheEntry(this.getCache(), cacheKey, (Serializable)byArray, byArray.length, null, n);
            this.getCache().addEntry(cacheKey, cacheEntry, bl);
        }
        catch (IOException iOException) {
            throw new XMLRegistryException(iOException);
        }
        catch (CX.EntryTooLarge entryTooLarge) {
            XMLLogger.logEntityCacheRejection((String)("" + cacheKey), (String)String.valueOf(byArray.length), (String)String.valueOf(this.getCache().getMemoryFootprint()));
            throw entryTooLarge;
        }
        catch (CX.EntityCacheException entityCacheException) {
            throw new XMLRegistryException(entityCacheException);
        }
        catch (Exception exception) {
            throw new XMLRegistryException(exception);
        }
    }

    public InputSource get(String string, String string2) throws XMLRegistryException, XMLRegistryExceptionCacheEntryExpired {
        if (this.underlyingCache == null) {
            return null;
        }
        Object var3_3 = null;
        byte[] byArray = null;
        CacheKey cacheKey = null;
        try {
            if (string != null) {
                cacheKey = new CacheKey(this.registry.getName(), string, null);
                byArray = (byte[])this.getCache().getData(cacheKey);
            }
            if (byArray == null && string2 != null) {
                cacheKey = new CacheKey(this.registry.getName(), null, string2);
                byArray = (byte[])this.getCache().getData(cacheKey);
            }
        }
        catch (CX.EntryExpired entryExpired) {
            throw new XMLRegistryExceptionCacheEntryExpired(entryExpired);
        }
        catch (CX.EntityCacheException entityCacheException) {
            throw new XMLRegistryException("Failure getting: " + cacheKey + " from cache.", entityCacheException);
        }
        if (byArray == null) {
            return null;
        }
        return this.getInputSource(string, string2, byArray);
    }

    public void renew(String string, String string2) throws XMLRegistryException {
        if (this.underlyingCache == null) {
            return;
        }
        CacheKey cacheKey = null;
        try {
            CacheEntry cacheEntry = null;
            if (string != null) {
                cacheKey = new CacheKey(this.registry.getName(), string, null);
                cacheEntry = this.getCache().renewLease(cacheKey);
            }
            if (cacheEntry == null && string2 != null) {
                cacheKey = new CacheKey(this.registry.getName(), null, string2);
                this.getCache().renewLease(cacheKey);
            }
        }
        catch (CX.EntityCacheException entityCacheException) {
            throw new XMLRegistryException("Failure renewing: " + cacheKey, entityCacheException);
        }
    }

    public void remove(String string, String string2) throws XMLRegistryException {
        if (this.underlyingCache == null) {
            return;
        }
        CacheKey cacheKey = null;
        try {
            CacheEntry cacheEntry = null;
            if (string != null) {
                cacheKey = new CacheKey(this.registry.getName(), string, null);
                cacheEntry = this.getCache().removeEntry(cacheKey);
            }
            if (cacheEntry == null && string2 != null) {
                cacheKey = new CacheKey(this.registry.getName(), null, string2);
                this.getCache().removeEntry(cacheKey);
            }
        }
        catch (CX.EntityCacheException entityCacheException) {
            throw new XMLRegistryException("Failure removing: " + cacheKey, entityCacheException);
        }
    }

    public void putrify(String string, String string2) throws XMLRegistryException {
        if (this.underlyingCache == null) {
            return;
        }
        CacheKey cacheKey = null;
        try {
            CacheEntry cacheEntry = null;
            if (string != null) {
                cacheKey = new CacheKey(this.registry.getName(), string, null);
                cacheEntry = this.getCache().putrify(cacheKey);
            }
            if (cacheEntry == null && string2 != null) {
                cacheKey = new CacheKey(this.registry.getName(), null, string2);
                this.getCache().putrify(cacheKey);
            }
        }
        catch (CX.EntityCacheException entityCacheException) {
            throw new XMLRegistryException("Failure putrifying: " + cacheKey, entityCacheException);
        }
    }

    protected InputSource getInputSource(String string, String string2, byte[] byArray) {
        InputSource inputSource = new InputSource();
        inputSource.setPublicId(string);
        inputSource.setSystemId(string2);
        inputSource.setByteStream(new ByteArrayInputStream(byArray));
        return inputSource;
    }

    String getDescription(Serializable serializable) {
        if (serializable == null) {
            return "UNKNOWN (KEY NOT SET)";
        }
        String string = serializable.toString();
        return string.substring(string.indexOf(":"));
    }
}

