/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.registry;

import java.util.HashSet;
import java.util.Set;

public class RefreshCacheLock {
    private int capacity = 0;
    private Set<Key>[] containers = null;

    public RefreshCacheLock() {
        this(1);
    }

    public RefreshCacheLock(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("concurrent capacity must be great than 0");
        }
        this.capacity = n;
        this.containers = new Set[this.capacity];
        for (int i = 0; i < this.containers.length; ++i) {
            this.containers[i] = new HashSet<Key>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String string, String string2) {
        Set<Key> set;
        Key key = this.createKey(string, string2);
        Set<Key> set2 = set = this.containers[Math.abs(key.hashCode() % this.capacity)];
        synchronized (set2) {
            while (set.contains(key)) {
                try {
                    set.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!set.contains(key)) {
                set.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(String string, String string2) {
        Set<Key> set;
        Key key = this.createKey(string, string2);
        Set<Key> set2 = set = this.containers[Math.abs(key.hashCode() % this.capacity)];
        synchronized (set2) {
            if (set.contains(key)) {
                set.remove(key);
            }
            set.notifyAll();
        }
    }

    private Key createKey(String string, String string2) {
        return new Key(string, string2);
    }

    private class Key {
        private String publicId;
        private String systemId;

        public Key(String string, String string2) {
            this.publicId = string;
            this.systemId = string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            Key key = (Key)object;
            return (this.publicId == key.publicId || this.publicId != null && this.publicId.equals(key.publicId)) && (this.systemId == key.systemId || this.systemId != null && this.systemId.equals(key.systemId));
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.publicId == null ? 0 : this.publicId.hashCode());
            n = 31 * n + (this.systemId == null ? 0 : this.systemId.hashCode());
            return n;
        }
    }
}

